/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.examples.RedShift;
import alma.obsprep.guiutil.mvc.examples.RedShiftEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public class RedShiftModel
extends Model {
    private ValueUnitPairModel frequencyModel = new ValueUnitPairModel();
    private VelocityModel velocityModel = new VelocityModel();

    public RedShiftModel(Object object) {
        super(object);
        this.registerSubModel(this.frequencyModel);
        this.registerSubModel(this.velocityModel);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                RedShiftModel.this.updateRedshiftField();
            }
        };
        this.frequencyModel.subscribe(modelChangeSubscriber);
        this.velocityModel.subscribe(modelChangeSubscriber);
    }

    public RedShift getRedShift() {
        return (RedShift)this.getDocument();
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public VelocityModel getVelocityModel() {
        return this.velocityModel;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            this.publish(RedShiftEditor.NAME_FID, this.getRedShift().getName());
            this.frequencyModel.publish();
            this.velocityModel.publish();
            this.updateRedshiftField();
        }
    }

    private void updateRedshiftField() {
        Frequency frequency = this.getRedShift().getFrequency();
        Velocity velocity = this.getRedShift().getVelocity();
        this.publish(RedShiftEditor.REDSHIFT_FID, (Object)frequency.dopplerShifted(velocity));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(RedShiftEditor.NAME_FID)) {
            String string = (String)object;
            this.getRedShift().setName(string);
            return string;
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.frequencyModel.setDocument((Object)this.getRedShift().getFrequency());
        this.velocityModel.setDocument((Object)this.getRedShift().getVelocity());
        this.publish();
    }
}

