/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.PositiveVerifier;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.observingparameters.CalibratorParameterModel;
import alma.obsprep.ot.models.schedblock.observingparameters.PolarizationCalParameterModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CalibratorParameterEditor
extends ObservingParameterEditor {
    public static final FieldID FID_NAME = new FieldID("CalibratorParameter.name");
    public static final FieldID FID_DATA_ORIGIN = new FieldID("CalibratorParameter.dataOrigin");
    public static final FieldID FID_CYCLETIME_VALUE = new FieldID("CalibratorParameter.cycletime.value");
    public static final FieldID FID_CYCLETIME_UNIT = new FieldID("CalibratorParameter.cycletime.unit");
    public static final FieldID FID_DEFAULTINTEGRATIONTIME_VALUE = new FieldID("CalibratorParameter.defaultIntegrTime.value");
    public static final FieldID FID_DEFAULTINTEGRATIONTIME_UNIT = new FieldID("CalibratorParameter.defaultIntegrTime.unit");
    public static final FieldID FID_SUBSCANDURATION_VALUE = new FieldID("CalibratorParameter.subscanDuration.value");
    public static final FieldID FID_SUBSCANDURATION_UNIT = new FieldID("CalibratorParameter.subscanDuration.unit");
    public static final FieldID FID_CPADJUST_BUTTON = new FieldID("CalibratorParameter.btnAdjust");
    public static final FieldID FID_FORCEATMCAL = new FieldID("CalibratorParameter.forceAtmCal");
    public static final FieldID FID_FORCEEXECUTION = new FieldID("CalibratorParameter.forceExecution");
    public static final FieldID FID_REPEATINTERVALTIME_VALUE = new FieldID("CalibratorParameter.repeatIntervalTime.value");
    public static final FieldID FID_REPEATINTERVALTIME_UNIT = new FieldID("CalibratorParameter.repeatIntervalTime.value");
    private JComboBox dataOrigin;

    public CalibratorParameterEditor(Model model, boolean bl) {
        super(model, bl);
    }

    public CalibratorParameterEditor(Model model) {
        super(model);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Calibrator Parameters");
    }

    @Override
    protected void addComponents(String string) {
        this.addUsedByTargetInfoComponent();
        CalibratorParameterModel calibratorParameterModel = (CalibratorParameterModel)this.getModel();
        this.panel = this.createNewGroup();
        this.gl = this.createNewLayout(this.panel);
        this.gc = this.createNewConstraints();
        this.addTextComponent(this.panel, this.gl, this.gc, FID_NAME, string + " Name", "Name of this " + string);
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, calibratorParameterModel.getCycleTimeModel(), "Cycle Time", "Cycle Time");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(valueUnitPairEditor));
        valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, calibratorParameterModel.getDefaultIntegrationTimeModel(), "Default Integration Time", "Default Integration Time");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(valueUnitPairEditor));
        String[] stringArray = calibratorParameterModel.getKnownDataOriginList();
        this.addComboBox((JComponent)this.panel, this.gl, this.gc, FID_DATA_ORIGIN, "Data origin", "How this constraint should be evaluated", stringArray);
        valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, calibratorParameterModel.getSubScanDurationModel(), "Subscan Duration", "The number of seconds the subscan will last - it must be a multiple of the integration duration");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(valueUnitPairEditor));
        JButton jButton = this.makeButton(FID_CPADJUST_BUTTON, "ADJUST Subscan", "Adjust the subscan duration to be a multiple of the integration duration");
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Adjust subscan duration to a correct value:", (JComponent)jButton);
        this.addVerticalSpace(this.panel, this.gl, this.gc);
        this.addBooleanComponent(this.panel, this.gl, this.gc, FID_FORCEATMCAL, "Force Atmospheric Calibration", "Check to force an atmospheric (Tsys) calibration for this calibrator, regardless of script default");
        this.addVerticalSpace(this.panel, this.gl, this.gc);
        this.addBooleanComponent(this.panel, this.gl, this.gc, FID_FORCEEXECUTION, "Force Execution", "Check to force at least one observation of this calibrator in a single SB execution");
        this.addGroup(this.panel, string);
        this.addAdvancedPanel();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        PolarizationCalParameters polarizationCalParameters = PolarizationCalParameters.createPolarizationCalParameters();
        PolarizationCalParameterModel polarizationCalParameterModel = new PolarizationCalParameterModel(polarizationCalParameters);
        CalibratorParameterEditor calibratorParameterEditor = new CalibratorParameterEditor(polarizationCalParameterModel);
        EditorWithGridBagLayout.runTestApp(calibratorParameterEditor);
    }
}

