/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.IsoDatePicker;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.TimingConstraintsListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TimingConstraintEditor
extends EditorWithGridBagLayout
implements TableCellEditor {
    private static final long serialVersionUID = -4606878953621068475L;
    protected transient ChangeEvent changeEvent = null;
    public static final FieldID START_TIME_FID = new FieldID("TimingConstraintEditor.startTime");
    public static final FieldID END_TIME_FID = new FieldID("TimingConstraintEditor.endTime");

    public TimingConstraintEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        Dimension dimension = new Dimension(650, 10);
        this.setLayout(new BoxLayout(this, 2));
        this.setMaximumSize(dimension);
        this.add(this.makeLabel("Start : "));
        IsoDatePicker isoDatePicker = this.makeIsoDateTimePanel(this, START_TIME_FID, "start time for monitoring visit");
        isoDatePicker.getIsoDateTimeField().setEnabled(false);
        this.add(isoDatePicker);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.makeLabel("End : "));
        IsoDatePicker isoDatePicker2 = this.makeIsoDateTimePanel(this, END_TIME_FID, "end time for monitoring visit");
        isoDatePicker2.getIsoDateTimeField().setEnabled(false);
        this.add(isoDatePicker2);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        isoDatePicker.getHourLabel().setText("Time");
        isoDatePicker.getMinuteLabel().setText(":");
        isoDatePicker2.getHourLabel().setText("Time");
        isoDatePicker2.getMinuteLabel().setText(":");
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public Object getCellEditorValue() {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        return timingConstraintsListModel.getCurrentTimingConstraint();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        if (object instanceof TemporalParameters) {
            timingConstraintsListModel.setCurrentTimingConstraint(object);
            return this;
        }
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Visit Constraint Editor");
        jFrame.setDefaultCloseOperation(3);
        PerformanceParameters performanceParameters = PerformanceParameters.createPerformanceParameters();
        TimingConstraintsListModel timingConstraintsListModel = new TimingConstraintsListModel(null);
        TimingConstraintEditor timingConstraintEditor = new TimingConstraintEditor(timingConstraintsListModel);
        timingConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(timingConstraintEditor);
    }
}

