/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.observingparameters.OpticalPointingParameterEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class OpticalPointingParameterModel
extends Model {
    private ValueUnitPairModel elevationLimitModel = new ValueUnitPairModel(null, OpticalPointingParameterEditor.FID_ELEVATIONLIMIT_VALUE, OpticalPointingParameterEditor.FID_ELEVATIONLIMIT_UNIT);
    private ValueUnitPairModel antennaPositionToleranceModel = new ValueUnitPairModel(null, OpticalPointingParameterEditor.FID_ANNTENAPOSITIONTOLERANCE_VALUE, OpticalPointingParameterEditor.FID_ANNTENAPOSITIONTOLERANCE_UNIT);

    public OpticalPointingParameterModel(ScienceParameters scienceParameters) {
        super((Object)scienceParameters);
        this.setDocument(this.document);
    }

    private OpticalPointingParameters getOpticalPointingParameters() {
        return (OpticalPointingParameters)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        OpticalPointingParameters opticalPointingParameters = this.getOpticalPointingParameters();
        if (opticalPointingParameters == null) {
            return;
        }
        this.publish(OpticalPointingParameterEditor.FID_NAME, this.getOpticalPointingParameters().getName());
        this.publish(OpticalPointingParameterEditor.FID_RANDOMORDER, this.getOpticalPointingParameters().getRandomizeOrder());
        this.getElevationLimitModel().publish();
        this.getAntennaPositionToleranceModel().publish();
        this.publish(OpticalPointingParameterEditor.FID_MINMAGNITUDE, String.valueOf(opticalPointingParameters.getMinMagnitude().getValue()));
        this.publish(OpticalPointingParameterEditor.FID_MAXMAGNITUDE, String.valueOf(opticalPointingParameters.getMaxMagnitude().getValue()));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        OpticalPointingParameters opticalPointingParameters = this.getOpticalPointingParameters();
        if (fieldID.equals(OpticalPointingParameterEditor.FID_NAME)) {
            String string2 = (String)object;
            this.getOpticalPointingParameters().setName(string2);
            return string2;
        }
        if (fieldID.equals(OpticalPointingParameterEditor.FID_RANDOMORDER)) {
            Boolean bl = (Boolean)object;
            this.getOpticalPointingParameters().setRandomizeOrder(bl);
            return bl;
        }
        if (fieldID.equals(OpticalPointingParameterEditor.FID_MINMAGNITUDE)) {
            Double d = Double.parseDouble(string);
            opticalPointingParameters.getMinMagnitude().setValue(d);
            return d;
        }
        if (fieldID.equals(OpticalPointingParameterEditor.FID_MAXMAGNITUDE)) {
            Double d = Double.parseDouble(string);
            opticalPointingParameters.getMaxMagnitude().setValue(d);
            return d;
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        OpticalPointingParameters opticalPointingParameters;
        if (object != null && object instanceof OpticalPointingParameters && (opticalPointingParameters = (OpticalPointingParameters)((Object)object)) != null) {
            if (this.elevationLimitModel != null) {
                this.elevationLimitModel.setDocument((Object)opticalPointingParameters.getElevationLimit());
            }
            if (this.antennaPositionToleranceModel != null) {
                this.antennaPositionToleranceModel.setDocument((Object)opticalPointingParameters.getAntennaPositionTolerance());
            }
        }
        super.setDocument(object);
    }

    public ValueUnitPairModel getElevationLimitModel() {
        return this.elevationLimitModel;
    }

    public ValueUnitPairModel getAntennaPositionToleranceModel() {
        return this.antennaPositionToleranceModel;
    }
}

