/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.scripting.PythonEnv;
import java.io.PrintStream;

public abstract class PyAction
implements Interactor {
    private Performer performer = null;
    protected PrintStream pyout;

    public PyAction() {
        PythonEnv pythonEnv = PythonEnv.getInstance();
        this.pyout = pythonEnv.getConsoleStream();
    }

    public boolean isGUI() {
        return false;
    }

    public void perform() {
        try {
            this.performer.perform();
        }
        catch (RuntimeException runtimeException) {
            this.error(this.getClass().getSimpleName() + ": failed to perform", runtimeException);
            throw runtimeException;
        }
    }

    public void error(String string, Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(": ").append(exception.toString()).append("\n");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (i == 3) {
                stringBuilder.append("\tskipping ").append(stackTraceElementArray.length - 3).append(" lines");
                break;
            }
            stringBuilder.append("\t").append(stackTraceElementArray[i]).append("\n");
        }
        this.pyout.println(stringBuilder.toString());
    }

    public void error(String string) {
        this.pyout.println(string);
    }

    public void info(String string) {
        this.pyout.println(string);
    }

    public void setPerformer(Performer performer) {
        this.performer = performer;
    }
}

