/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import lombok.NonNull;

public class ObservingGroupValidator
extends AbstractValidator {
    public ObservingGroupValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    public void localValidate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        Problem problem;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        ObservingGroup observingGroup = (ObservingGroup)businessObject;
        BusinessObject businessObject2 = null;
        try {
            businessObject2 = BOUtilities.findParent(businessObject, SchedBlock.class);
        }
        catch (BOUtilities.ParentNotFoundException parentNotFoundException) {
            Log.logger(ObservingGroupValidator.class).warning("Unable to locate the parent SB for the OUS " + String.valueOf(businessObject));
        }
        assert (businessObject2 != null);
        SchedBlock schedBlock = (SchedBlock)businessObject2;
        boolean bl = schedBlock.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString());
        if (!bl && observingGroup.getOrderedTargetCount() <= 0) {
            problem = DefaultProblem.createWarning("An observing group is empty: the first observing group should include calibrators unless this is a multi-tuning setup", "Add calibrators to the first observing group if necessary", observingGroup);
            problemListModel.add(problem);
        }
        boolean bl2 = false;
        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
            Target target = orderedTarget.getTarget();
            if (!target.hasScienceParameters()) continue;
            bl2 = true;
            break;
        }
        if (bl2 && observingGroup.getMainTarget() == null) {
            problem = DefaultProblem.createWarning("An observing group has science targets but no designated Doppler target", "Assign Doppler target to observing group", observingGroup);
            problemListModel.add(problem);
        }
    }
}

