/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.util.Convert;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import lombok.NonNull;

public class MeasurementTableModel
extends AbstractTableModel {
    private final Log.Logger logger = Log.logger((Object)this);
    private final DefaultCalibratorPrinter defaultCalibratorPrinter = new DefaultCalibratorPrinter();
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private double queryRa = 0.0;
    private double queryDec = 0.0;

    public Measurement get(int n) {
        return this.measurements.get(n);
    }

    public int indexOf(Measurement measurement) {
        return this.measurements.indexOf(measurement);
    }

    public void setQueryRA(String string) {
        try {
            this.queryRa = Convert.HHMMSSToDeg(string);
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            this.logger.warning("Error converting '" + string + "' to right ascension: " + exception.toString());
        }
    }

    public void setQueryDec(String string) {
        try {
            this.queryDec = Convert.DDMMSSToDeg(string);
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            this.logger.warning("Error converting '" + string + "' to declination: " + exception.toString());
        }
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public int getRowCount() {
        return this.measurements.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return Date.class;
            }
            case 7: {
                return Double.class;
            }
            case 8: {
                return Double.class;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Source Name";
            }
            case 1: {
                return "RA";
            }
            case 2: {
                return "Dec";
            }
            case 3: {
                return "Separation";
            }
            case 4: {
                return "Frequency";
            }
            case 5: {
                return "Flux Density";
            }
            case 6: {
                return "Last Observed";
            }
            case 7: {
                return "UV Min (k\u03bb)";
            }
            case 8: {
                return "UV Max (k\u03bb)";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Measurement measurement = this.measurements.get(n);
        return this.defaultCalibratorPrinter.getColumnValue(measurement, n2);
    }

    public void setCalibrators(List<Measurement> list) {
        if (list != null) {
            this.measurements.clear();
            this.measurements.addAll(list);
            this.fireTableDataChanged();
        }
    }

    public List<Measurement> getCalibrators() {
        return this.measurements;
    }

    class DefaultCalibratorPrinter
    extends CalibratorPrinter {
        DefaultCalibratorPrinter() {
        }

        @Override
        public Object getColumnValue(@NonNull Measurement measurement, int n) {
            if (measurement == null) {
                throw new NullPointerException("measurement is marked non-null but is null");
            }
            switch (n) {
                case 0: {
                    return measurement.getFormattedName();
                }
                case 1: {
                    return measurement.getRa() == null ? null : this.getHms(measurement.getRa());
                }
                case 2: {
                    return measurement.getDec() == null ? null : this.getDms(measurement.getDec());
                }
                case 3: {
                    return this.getSeparation(measurement);
                }
                case 4: {
                    return measurement.getFrequency() == null ? null : measurement.getFrequency();
                }
                case 5: {
                    return measurement.getFlux() == null ? null : measurement.getFlux();
                }
                case 6: {
                    return measurement.getDateObserved() == null ? null : measurement.getDateObserved();
                }
                case 7: {
                    return measurement.getUvMin() == null ? null : measurement.getUvMin();
                }
                case 8: {
                    return measurement.getUvMax() == null ? null : measurement.getUvMax();
                }
            }
            throw new IllegalStateException();
        }
    }

    abstract class CalibratorPrinter {
        CalibratorPrinter() {
        }

        public abstract Object getColumnValue(Measurement var1, int var2);

        protected Double getSeparation(Measurement measurement) {
            double d;
            double d2;
            double d3;
            Double d4 = measurement.getRa();
            Double d5 = measurement.getDec();
            if (d4 == null || d5 == null) {
                return null;
            }
            double d6 = Math.toRadians(MeasurementTableModel.this.queryRa);
            double d7 = Math.toRadians(d4);
            double d8 = Math.toRadians(MeasurementTableModel.this.queryDec);
            double d9 = Math.toRadians(d5);
            double d10 = Math.pow(Math.cos(d9), 2.0) * Math.pow(Math.sin(d7 - d6), 2.0);
            double d11 = Math.sqrt(d10 + Math.pow((d3 = Math.cos(d8) * Math.sin(d9)) - (d2 = Math.sin(d8) * Math.cos(d9) * Math.cos(d7 - d6)), 2.0));
            double d12 = 57.29577951308232 * Math.atan(d11 / (d = Math.sin(d8) * Math.sin(d9) + Math.cos(d8) * Math.cos(d9) * Math.cos(d7 - d6)));
            if (d12 < 0.0) {
                d12 += 180.0;
            }
            return d12;
        }

        protected String getHms(Double d) {
            try {
                return Convert.degToHHMMSS(d);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                return "N/A";
            }
        }

        protected String getDms(Double d) {
            try {
                return Convert.degToDDMMSS(d);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                return "N/A";
            }
        }
    }
}

