/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcer;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.RevisedIntegrationParameters;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import lombok.NonNull;

public class FixedSubscanIntegerMosaicEnforcer
extends IntegerMosaicEnforcer
implements IntegerMosaicEnforcerInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean enforceCompleteMosaicScansPerSBExec(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws UnknownEntityException, InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("requestedArray is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        boolean bl = false;
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            return false;
        }
        Array array = requestedArray.getArray();
        ArrayList<RevisedIntegrationParameters> arrayList = new ArrayList<RevisedIntegrationParameters>();
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    Target target = orderedTarget.getTarget();
                    if (!target.hasScienceParameters()) continue;
                    int n = target.getFieldSource().getFieldPattern().getNumberOfPointings();
                    ScienceParameters scienceParameters = target.getScienceParametersList()[0];
                    if (hashSet.contains((Object)scienceParameters)) continue;
                    if (!target.getFieldSource().getFieldPattern().isPointingPattern()) {
                        Log.logger(SchedBlockWorker.class).fine("Unable to apply integer mosaic scan algorithm: not a pointing pattern");
                        return false;
                    }
                    Time time = (Time)scienceParameters.getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount());
                    RevisedIntegrationParameters revisedIntegrationParameters = this.adjustTimingParametersForMosaicBasedSources(target, n, time.getContentInDefaultUnits(), enumSet, array, schedBlock, false);
                    if (revisedIntegrationParameters == null) {
                        return false;
                    }
                    arrayList.add(revisedIntegrationParameters);
                    hashSet.add(scienceParameters);
                }
            }
            int n = 0;
            double d = 0.0;
            for (RevisedIntegrationParameters revisedIntegrationParameters : arrayList) {
                Log.logger(SchedBlockWorker.class).fine("revisedIntegrationParameters: " + String.valueOf(revisedIntegrationParameters));
                ScienceParameters scienceParameters = revisedIntegrationParameters.getScienceTarget().getScienceParametersList()[0];
                assert (scienceParameters != null);
                bl = true;
                assert (revisedIntegrationParameters.getNoOfSBExecs() > 0);
                if (revisedIntegrationParameters.getNoOfSBExecs() > n) {
                    n = revisedIntegrationParameters.getNoOfSBExecs();
                    schedBlock.getSchedBlockControl().setExecutionCount(n);
                }
                scienceParameters.setSubScanDuration(revisedIntegrationParameters.getSubScanDuration());
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)revisedIntegrationParameters.getScienceIntegrationTime().getContentInDefaultUnits(), (String)IntTimeSource.UNIT_S));
                scienceParameters.setIntegrationTimeChangeable(false);
                d += scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S);
                assert (n > 0);
                assert (d < SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet));
            }
        }
        return bl;
    }

    private RevisedIntegrationParameters adjustTimingParametersForMosaicBasedSources(@NonNull Target target, int n, double d, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull Array array, @NonNull SchedBlock schedBlock, boolean bl) {
        double d2;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (n == 0 || d == 0.0) {
            throw new IllegalArgumentException("totalOnSourceTimeForTarget and noOfPointings should be greater than zero");
        }
        if (!target.hasScienceParameters()) {
            throw new IllegalArgumentException("target should be a science target");
        }
        if (Array.ARRAY_TP.equals((Object)array)) {
            return null;
        }
        RevisedIntegrationParameters.RevisedIntegrationParametersBuilder revisedIntegrationParametersBuilder = RevisedIntegrationParameters.builder();
        double d3 = 0.0;
        ScienceParameters scienceParameters = target.getScienceParametersList()[0];
        assert (scienceParameters != null);
        double d4 = this.getProportionOfTOSForScienceTarget(enumSet, target, schedBlock.getScienceTargets());
        double d5 = SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet) * d4;
        if (bl) {
            Time time = this.getActualTOSRequiredForSingleSBExec(schedBlock.getScienceTargets());
            d5 = time.getContentInUnits(Time.UNIT_S) * d4;
        }
        double d6 = d / (double)n;
        assert (d6 > 0.0);
        double d7 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        int n2 = (int)Math.ceil(d6 * (double)n / d5);
        if (n2 == 0) {
            return null;
        }
        if (n2 == Integer.MAX_VALUE) {
            throw new WizardSBGenerationException("The calculated required number of SB executions is too high, is the desired sensitivity too high?");
        }
        if (n2 > 5000) {
            Log.logger(SchedBlockWorker.class).info("SB execution count exceeds limits: not running algorithm");
            return null;
        }
        double d8 = (double)n * d7;
        boolean bl2 = false;
        double d9 = 0.0;
        while (!bl2) {
            d2 = d6 * (double)n / (double)n2;
            if (d2 <= 0.0) {
                throw new WizardSBGenerationException("Unable to calculate integer mosaic scan: requested TOS per SB execution is zero or less");
            }
            if (d8 > d5) {
                throw new WizardSBGenerationException("Unable to determine integer number of mosaic scans per SB execution: too many pointings?");
            }
            d3 = Math.ceil(d2 / d8);
            assert (d3 > 0.0);
            d9 = d8 * d3;
            assert (d9 > 0.0);
            if (d9 > d5) {
                ++n2;
                continue;
            }
            bl2 = true;
            break;
        }
        assert (d3 > 0.0 && d7 > 0.0 && n2 > 0 && d9 > 0.0);
        revisedIntegrationParametersBuilder.subScanDuration(Time.createTimeSec(d7)).noOfSBExecs(n2).scienceIntegrationTime(Time.createTimeSec(d9 - 0.1));
        revisedIntegrationParametersBuilder.scienceTarget(target);
        d2 = (double)n2 * d9;
        RevisedIntegrationParameters revisedIntegrationParameters = revisedIntegrationParametersBuilder.build();
        Log.logger(SchedBlockWorker.class).info("No of required SB execs : " + n2 + " On-source time per SB : " + String.valueOf(revisedIntegrationParameters.getScienceIntegrationTime()) + " Total on-source time actually required : " + d2 + " Total time initially requested : " + d + " No Of Mosaics per SB : " + d3 + " Initial time per pointing : " + d / (double)n + " Recalculated time per pointing : " + revisedIntegrationParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S) * d3 * (double)n2 + " Subscan duration : " + String.valueOf(revisedIntegrationParameters.getSubScanDuration()) + " No of Pointings : " + n + " target : " + revisedIntegrationParameters.getScienceTarget().getName());
        Log.logger(SchedBlockWorker.class).fine("Ratio of requested to required time : " + d2 / d);
        return revisedIntegrationParameters;
    }
}

