/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.summaryfeedback.TuningInfo;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.Velocity;
import javax.swing.table.AbstractTableModel;

public class SpectralTuningsTableModel
extends AbstractTableModel {
    protected TuningInfo tuningInfo;
    private final String[] longvalues = new String[]{" 1 ", " 1,2,3,4,5 ", " 100.123456 ", "  xxx.xxx mJy, yy.yyy K   ", "  xxx.xxx - xxx.xxx mJy  "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        int n = this.tuningInfo == null ? 0 : this.tuningInfo.getNumTunings();
        return n;
    }

    public TuningInfo getParameters() {
        return this.tuningInfo;
    }

    public void setDocument(TuningInfo tuningInfo) {
        this.tuningInfo = tuningInfo;
    }

    @Override
    public int getColumnCount() {
        return TuningCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        TuningCols tuningCols = TuningCols.getColumnDescriptor(n);
        return tuningCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.tuningInfo == null) {
            return null;
        }
        this.tuningInfo.ssp.getScienceGoal();
        this.tuningInfo.getNumTunings();
        this.tuningInfo.getNumSpectralWindows();
        int n3 = n;
        MinTuningsCalculator.TuningResult tuningResult = this.tuningInfo.tunings.get(n3);
        Frequency frequency = this.tuningInfo.ssp.getRepresentativeFrequency();
        Velocity velocity = tuningResult.getKeyTarget().getSourceVelocity();
        Frequency frequency2 = velocity.dopplerShift(frequency);
        TuningCols tuningCols = TuningCols.getColumnDescriptor(n2);
        switch (tuningCols) {
            case TUNING: {
                return n + 1;
            }
            case TARGET: {
                return this.tuningInfo.targetsString.get(n3);
            }
            case FREQUENCY: {
                return frequency2;
            }
            case RMS: {
                return this.tuningInfo.rmsAtRepFreq.get(tuningResult);
            }
            case RMSRANGE: {
                return this.tuningInfo.achievedRms.get(tuningResult);
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longvalues;
    }

    public static enum TuningCols {
        TUNING("<html>Tuning<br>&nbsp;</html>", Integer.class),
        TARGET("<html>Target<br>&nbsp;</html>", String.class),
        FREQUENCY("<html>Rep. Freq.<br>Sky GHz</html>", Double.class),
        RMS("<html>RMS<br>(Rep. Freq.)</html>", UserSensitivity.class),
        RMSRANGE("<html>RMS<br>Achieved</html>", String.class);

        public final String columnName;
        public final Class columnClass;

        protected static int getColumnCount() {
            return TuningCols.values().length;
        }

        protected static TuningCols getColumnDescriptor(int n) {
            return TuningCols.values()[n];
        }

        private TuningCols(String string2, Class clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }
    }
}

