/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.capabilities;

import alma.common.sensitivitycalculatorcore.enumerations.BasicArray;
import java.util.HashMap;
import java.util.Map;

public class BasicAlmaArrayCapabilities {
    private final String[] AVAILABLE_RECEIVER_BANDS = new String[]{"ALMA_RB_01", "ALMA_RB_02", "ALMA_RB_03", "ALMA_RB_04", "ALMA_RB_05", "ALMA_RB_06", "ALMA_RB_07", "ALMA_RB_08", "ALMA_RB_09", "ALMA_RB_10"};
    private final double MAX_BASELINE_KM = 1.0;
    private final double MIN_BASELINE_KM = 0.03;
    private final int NUMBER_OF_ARRAY_12M_ANTENNAS = 43;
    private final int NUMBER_OF_ARRAY_7M_ANTENNAS = 10;
    private final int NUMBER_OF_ARRAY_TP_ANTENNAS = 3;
    private final double maxBaseline = 1.0;
    private final double minBaseline = 0.03;
    private Map<BasicArray, Integer> nAntennas = new HashMap<BasicArray, Integer>();
    private static BasicAlmaArrayCapabilities sc = null;

    public BasicAlmaArrayCapabilities() {
        this.nAntennas.put(BasicArray.ARRAY_12M, 43);
        this.nAntennas.put(BasicArray.ARRAY_7M, 10);
        this.nAntennas.put(BasicArray.ARRAY_TP, 3);
    }

    public static BasicAlmaArrayCapabilities getInstance() {
        if (sc == null) {
            sc = new BasicAlmaArrayCapabilities();
        }
        return sc;
    }

    public String[] getAvailableReceiverBands() {
        return this.AVAILABLE_RECEIVER_BANDS;
    }

    public double getMaxBaseline() {
        return 1.0;
    }

    public double getMinBaseline() {
        return 0.03;
    }

    public int getNumAntennas(BasicArray array) {
        return this.nAntennas.get((Object)array);
    }
}

