/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.HashMap;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public class PairsRowLink
extends RowLink {
    public PairsRowLink(RowRef ref0, RowRef[] ref1s, double[] scores, boolean bestOnly) {
        super(PairsRowLink.amalgamateRefs(ref0, ref1s, scores, bestOnly));
    }

    public double getScore(int i) {
        RowRef ref = this.getRef(i);
        return ref instanceof ScoredRowRef ? ((ScoredRowRef)ref).getScore() : Double.NaN;
    }

    private static RowRef[] amalgamateRefs(RowRef ref0, RowRef[] ref1s, double[] scores, boolean bestOnly) {
        ScoredRowRef[] sref1s = new ScoredRowRef[ref1s.length];
        for (int i = 0; i < ref1s.length; ++i) {
            sref1s[i] = new ScoredRowRef(ref1s[i], scores[i]);
        }
        if (bestOnly) {
            HashMap<Integer, ScoredRowRef> refMap = new HashMap<Integer, ScoredRowRef>();
            for (int i = 0; i < sref1s.length; ++i) {
                ScoredRowRef ref = sref1s[i];
                Integer key = new Integer(ref.getTableIndex());
                if (refMap.containsKey(key)) {
                    ScoredRowRef bestRef = (ScoredRowRef)refMap.get(key);
                    if (!(ref.getScore() < bestRef.getScore())) continue;
                    refMap.put(key, ref);
                    continue;
                }
                refMap.put(key, ref);
            }
            sref1s = refMap.values().toArray(new ScoredRowRef[0]);
        }
        RowRef[] refs = new RowRef[1 + sref1s.length];
        refs[0] = ref0;
        System.arraycopy(sref1s, 0, refs, 1, sref1s.length);
        return refs;
    }

    private static class ScoredRowRef
    extends RowRef {
        private final double score_;

        ScoredRowRef(RowRef ref, double score) {
            super(ref.getTableIndex(), ref.getRowIndex());
            this.score_ = score;
        }

        public double getScore() {
            return this.score_;
        }
    }
}

