/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Hashtable;
import org.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Structure;

public final class GroupNaming {
    private Hashtable<String, Hashtable<Group, String>> _packageGroupNames = new Hashtable();
    private JavaNaming _javaNaming;

    public GroupNaming(JavaNaming javaNaming) {
        this._javaNaming = javaNaming;
    }

    private String getGroupName(Group group, String packageName) {
        Hashtable<Group, String> groupNames = this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            return null;
        }
        return groupNames.get(group);
    }

    private void putGroupName(Group group, String packageName, String name) {
        Hashtable<Group, String> groupNames = this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            groupNames = new Hashtable();
            this._packageGroupNames.put(packageName, groupNames);
        }
        groupNames.put(group, name);
    }

    private boolean containsGroupName(String packageName, String name) {
        Hashtable<Group, String> groupNames = this._packageGroupNames.get(packageName);
        if (groupNames == null) {
            return false;
        }
        return groupNames.contains(name);
    }

    public String createClassName(Group group, String packageName) {
        Object name = group.getName();
        if (name != null) {
            return this._javaNaming.toJavaClassName((String)name);
        }
        name = this.getGroupName(group, packageName);
        if (name != null) {
            return name;
        }
        Structure parent = group.getParent();
        if (parent == null) {
            return null;
        }
        boolean addOrder = true;
        switch (parent.getStructureType()) {
            case 10: {
                name = this.createClassName((Group)parent, packageName);
                break;
            }
            case 16: {
                name = ((ModelGroup)parent).getName();
                name = this._javaNaming.toJavaClassName((String)name);
                addOrder = false;
                break;
            }
            case 6: {
                name = this.getClassName((ComplexType)parent);
                addOrder = false;
                break;
            }
        }
        if (name != null) {
            if (addOrder) {
                String order = group.getOrder().toString();
                name = (String)name + this._javaNaming.toJavaClassName(order);
            }
            int count = 2;
            String tmpName = name;
            while (this.containsGroupName(packageName, (String)name)) {
                name = tmpName + count;
                ++count;
            }
            this.putGroupName(group, packageName, (String)name);
        }
        return name;
    }

    private String getClassName(ComplexType complexType) {
        String name = complexType.getName();
        if (name != null) {
            return this._javaNaming.toJavaClassName(name);
        }
        Structure parent = complexType.getParent();
        if (parent != null && parent.getStructureType() == 8) {
            name = ((ElementDecl)parent).getName();
        }
        if (name != null) {
            name = this._javaNaming.toJavaClassName(name);
        }
        return name;
    }
}

