/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exolab.javasource.JAnnotationTypeElement;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public final class JAnnotationType
extends JStructure {
    private Map<String, JAnnotationTypeElement> _elements = new LinkedHashMap<String, JAnnotationTypeElement>();

    public JAnnotationType(String name) {
        super(name);
        this.getJDocComment().appendComment("Annotation " + this.getLocalName() + ".");
    }

    @Override
    public void addImport(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        this.addImportInternal(className);
    }

    @Override
    public void addMember(JMember jMember) {
        if (!(jMember instanceof JAnnotationTypeElement)) {
            throw new IllegalArgumentException("Must be a JAnnotationTypeElement.");
        }
        this.addElement((JAnnotationTypeElement)jMember);
    }

    public JAnnotationTypeElement[] getElements() {
        return this._elements.values().toArray(new JAnnotationTypeElement[this._elements.size()]);
    }

    public JAnnotationTypeElement getElement(String name) {
        return this._elements.get(name);
    }

    public void addElement(JAnnotationTypeElement jElement) {
        if (jElement == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jElement.getName();
        if (this._elements.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._elements.put(name, jElement);
        JType type = jElement.getType();
        while (type.isArray()) {
            type = ((JArrayType)type).getComponentType();
        }
        if (!type.isPrimitive()) {
            this.addImport(type.getName());
        }
    }

    @Override
    public JField[] getFields() {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public JField getField(String name) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void addField(JField jField) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void print(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuilder buffer = new StringBuilder(100);
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        this.printImportDeclarations(jsw);
        this.getJDocComment().print(jsw);
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("@interface ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.writeln();
        jsw.indent();
        for (JAnnotationTypeElement jElement : this._elements.values()) {
            jElement.print(jsw);
            jsw.writeln();
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }
}

