/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.app;

import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.commandcenter.util.VariableString;
import alma.acs.util.ACSPorts;
import alma.acs.util.AcsLocations;
import alma.entity.xmlbinding.acscommandcenterproject.AcsCommandCenterProject;
import alma.entity.xmlbinding.acscommandcenterproject.ContainerT;
import alma.entity.xmlbinding.acscommandcenterproject.types.ModeType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProjectRunModel
implements RunModel {
    protected AcsCommandCenterProject project;
    protected int selectedContainerIndex = 0;
    protected Map<String, Object> variables = null;

    public ProjectRunModel(AcsCommandCenterProject project) {
        this.setProject(project);
    }

    public void setProject(AcsCommandCenterProject project) {
        this.project = project;
    }

    public AcsCommandCenterProject getProject() {
        return this.project;
    }

    public ModeType getMode() {
        return this.project.getMode();
    }

    public ProjectRunModel createViewOnContainer(int containerIndex) {
        ProjectRunModel ret = new ProjectRunModel(this.project);
        ret.selectedContainerIndex = containerIndex;
        return ret;
    }

    public String deriveIRfromCommonSettings() {
        int basePort = this.deriveInstanceFromCommonSettings();
        String port = ACSPorts.globalInstance((int)basePort).giveIRPort();
        String host = this.deriveMgrHostfromCommonSettings();
        String ret = AcsLocations.convertToInterfaceRepositoryLocation((String)host, (String)port);
        return ret;
    }

    public String deriveNSfromCommonSettings() {
        int basePort = this.deriveInstanceFromCommonSettings();
        String port = ACSPorts.globalInstance((int)basePort).giveNamingServicePort();
        String host = this.deriveMgrHostfromCommonSettings();
        String ret = AcsLocations.convertToNameServiceLocation((String)host, (String)port);
        return ret;
    }

    public String deriveCDBfromCommonSettings() {
        int basePort = this.deriveInstanceFromCommonSettings();
        String port = ACSPorts.globalInstance((int)basePort).giveCDBPort();
        String host = this.deriveMgrHostfromCommonSettings();
        String ret = AcsLocations.convertToCdbLocation((String)host, (String)port);
        return ret;
    }

    public String deriveMgrHostfromCommonSettings() {
        String host = ModeType.REMOTE.equals(this.project.getMode()) || ModeType.REMOTE_NATIVE.equals(this.project.getMode()) || ModeType.REMOTE_DAEMON.equals(this.project.getMode()) ? this.read(this.project.getRemoteHost()) : ACSPorts.getIP();
        return host;
    }

    public String deriveMgrPortfromCommonSettings() {
        int basePort = this.deriveInstanceFromCommonSettings();
        String port = ACSPorts.globalInstance((int)basePort).giveManagerPort();
        return port;
    }

    protected int deriveInstanceFromCommonSettings() {
        return MiscUtils.parseInt(this.read(this.project.getScriptBase()));
    }

    protected int selectedContainerIndex() {
        return this.selectedContainerIndex;
    }

    protected ContainerT selectedContainer() {
        int selectedContainerIndex = this.selectedContainerIndex();
        return this.project.getContainers().getContainer(selectedContainerIndex);
    }

    protected String read(String stringWithVars) {
        return new VariableString(stringWithVars, false).toString(this.getVariables());
    }

    public Map<String, Object> getVariables() {
        if (this.variables == null) {
            this.readDefaultVariables();
        }
        return this.variables;
    }

    public void readDefaultVariables() {
        Map<String, Object> m = Collections.synchronizedMap(new HashMap());
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String n = (String)e.getKey();
            if (n.startsWith("java.") || n.startsWith("sun.") || n.startsWith("os.") || n.startsWith("file.") || n.startsWith("awt.") || n.startsWith("org.omg.") || n.startsWith("jacorb.") || n.startsWith("path.") || n.startsWith("line.") || n.startsWith("user.country") || n.startsWith("user.language") || n.startsWith("user.timezone") || n.startsWith("user.variant") || n.startsWith("deployment.") || n.startsWith("javaplugin.") || n.startsWith("jnlpx.") || n.startsWith("org.apache.")) continue;
            m.put(n, e.getValue());
        }
        this.variables = m;
    }

    public void readVariables(Properties p) {
        Map<Object, Object> m = Collections.synchronizedMap(new HashMap<Object, Object>(p));
        this.variables = m;
    }

    @Override
    public String getServicesLocalJavaRoot() {
        return this.read(this.project.getServicesLocalJavaRoot());
    }

    @Override
    public String getServicesLocalJavaPort() {
        ACSPorts ports = ACSPorts.globalInstance((int)this.deriveInstanceFromCommonSettings());
        return ports.giveCDBPort();
    }

    @Override
    public String getManagerLocalJavaPort() {
        ACSPorts ports = ACSPorts.globalInstance((int)this.deriveInstanceFromCommonSettings());
        return ports.giveManagerPort();
    }

    @Override
    public String getManagerLocalJavaAgainstCDBHost() {
        return this.read(this.project.getManagerLocalJavaAgainstCDBHost());
    }

    @Override
    public String getManagerLocalJavaAgainstCDBPort() {
        return this.getServicesLocalJavaPort();
    }

    @Override
    public String getContainerLocalJavaPort() {
        int selectedContainerIndex = this.selectedContainerIndex();
        int scriptbase = this.deriveInstanceFromCommonSettings();
        return String.valueOf(3000 + scriptbase * 100 + 50 + selectedContainerIndex * 2);
    }

    @Override
    public String getScriptBase() {
        return this.read(this.project.getScriptBase());
    }

    @Override
    public String getRemoteHost() {
        return this.read(this.project.getRemoteHost());
    }

    @Override
    public String getRemoteAccount() {
        return this.read(this.project.getRemoteAccount());
    }

    @Override
    public String getRemotePassword() {
        return this.read(this.project.getRemotePassword());
    }

    @Override
    public String getToolAgainstManagerHost() {
        String ret = this.project.getToolRunAgainstDedicatedSettings() ? this.read(this.project.getToolAgainstManagerHost()) : this.deriveMgrHostfromCommonSettings();
        return ret;
    }

    @Override
    public String getToolAgainstManagerPort() {
        String ret = this.project.getToolRunAgainstDedicatedSettings() ? this.read(this.project.getToolAgainstManagerPort()) : this.deriveMgrPortfromCommonSettings();
        return ret;
    }

    @Override
    public String getToolAgainstInterfaceRepository() {
        String ret = this.project.getToolRunAgainstDedicatedSettings() ? this.read(this.project.getToolAgainstInterfaceRepository()) : this.deriveIRfromCommonSettings();
        return ret;
    }

    @Override
    public String getToolAgainstNameService() {
        String ret = this.project.getToolRunAgainstDedicatedSettings() ? this.read(this.project.getToolAgainstNameService()) : this.deriveNSfromCommonSettings();
        return ret;
    }

    @Override
    public String getContainerName() {
        return this.read(this.selectedContainer().getName());
    }

    @Override
    public String getContainerType() {
        return this.read(this.selectedContainer().getType());
    }

    @Override
    public String[] getContainerTypeModifiers() {
        String[] ss = this.selectedContainer().getTypeModifier();
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.read(ss[i]);
        }
        return ss;
    }

    @Override
    public String getContainerHeapSize() {
        return this.read(this.selectedContainer().getHeapSizeMB());
    }

    @Override
    public String getContainerScriptBase() {
        if (this.selectedContainer().getUseDedicatedSettings()) {
            return this.read(this.selectedContainer().getScriptBase());
        }
        return this.read(this.project.getScriptBase());
    }

    @Override
    public String getContainerRemoteHost() {
        if (this.selectedContainer().getUseDedicatedSettings()) {
            return this.read(this.selectedContainer().getRemoteHost());
        }
        return this.read(this.project.getRemoteHost());
    }

    @Override
    public String getContainerRemoteAccount() {
        if (this.selectedContainer().getUseDedicatedSettings()) {
            return this.read(this.selectedContainer().getRemoteAccount());
        }
        return this.read(this.project.getRemoteAccount());
    }

    @Override
    public String getContainerRemotePassword() {
        if (this.selectedContainer().getUseDedicatedSettings()) {
            return this.read(this.selectedContainer().getRemotePassword());
        }
        return this.read(this.project.getRemotePassword());
    }

    @Override
    public String getContainerAgainstManagerHost() {
        String ret = this.project.getContainers().getRunAgainstDedicatedSettings() ? this.read(this.project.getContainers().getAgainstManagerHost()) : this.deriveMgrHostfromCommonSettings();
        return ret;
    }

    @Override
    public String getContainerAgainstManagerPort() {
        String ret = this.project.getContainers().getRunAgainstDedicatedSettings() ? this.read(this.project.getContainers().getAgainstManagerPort()) : this.deriveMgrPortfromCommonSettings();
        return ret;
    }

    @Override
    public String getContainerAgainstCDB() {
        String ret = this.project.getContainers().getRunAgainstDedicatedSettings() ? this.read(this.project.getContainers().getAgainstCDB()) : this.deriveCDBfromCommonSettings();
        return ret == null ? "" : ret;
    }

    @Override
    public String getContainerAgainstInterfaceRepository() {
        String ret = this.project.getContainers().getRunAgainstDedicatedSettings() ? this.read(this.project.getContainers().getAgainstInterfaceRepository()) : this.deriveIRfromCommonSettings();
        return ret == null ? "" : ret;
    }
}

