/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import java.io.Serializable;

public class HandleDataStore
implements Serializable {
    private static final long serialVersionUID = -6137572272422678754L;
    private int capacity;
    public static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    private int maxCapacity = Integer.MAX_VALUE;
    private int size;
    private Element[] elements;
    private int first;
    private int last;

    public HandleDataStore() {
        this(10, Integer.MAX_VALUE);
    }

    public HandleDataStore(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public HandleDataStore(int initialCapacity, int maxCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        if (maxCapacity < initialCapacity) {
            throw new IllegalArgumentException("Illegal maxCapacity (less than capacity): " + maxCapacity);
        }
        this.maxCapacity = maxCapacity;
        this.setCapacity(initialCapacity);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity - 1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(int handle) {
        return this.elements[handle].data;
    }

    public void set(int handle, Object data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        this.elements[handle].data = data;
    }

    public void setCapacity(int newCapacity) {
        int i;
        if (++newCapacity <= this.capacity || newCapacity > this.maxCapacity) {
            return;
        }
        Element[] newElements = new Element[newCapacity];
        for (i = this.capacity; i < newCapacity; ++i) {
            newElements[i] = new Element();
            newElements[i].next = i + 1;
            newElements[i].previous = i - 1;
            newElements[i].free = true;
        }
        for (i = 0; i < this.capacity; ++i) {
            newElements[i] = this.elements[i];
        }
        if (this.capacity != 0) {
            newElements[newElements[0].previous].next = this.capacity;
            newElements[this.capacity].previous = newElements[0].previous;
            newElements[newCapacity - 1].next = 0;
            newElements[0].previous = newCapacity - 1;
        } else {
            newElements[0].previous = newCapacity - 1;
            newElements[newCapacity - 1].next = 0;
        }
        this.elements = newElements;
        this.capacity = newCapacity;
    }

    public int first() {
        return this.first;
    }

    public int last() {
        return this.last;
    }

    public int next(int handle) {
        return this.elements[handle].next;
    }

    public int previous(int handle) {
        return this.elements[handle].previous;
    }

    public boolean isAllocated(int handle) {
        if (handle <= 0 || handle >= this.capacity) {
            return false;
        }
        return !this.elements[handle].free;
    }

    public int allocate() {
        return this.allocate(this.elements[0].next, false);
    }

    public int allocate(int handle) {
        return this.allocate(handle, false);
    }

    public int preallocate() {
        return this.allocate(this.elements[0].next, true);
    }

    public int allocate(int handle, boolean preallocate) {
        if (handle == 0) {
            int newCapacity = Math.min(2 * (this.capacity - 1), this.maxCapacity - 1);
            this.setCapacity(newCapacity);
            handle = this.elements[0].next;
        } else if (handle >= this.capacity && handle < this.maxCapacity) {
            this.setCapacity(handle + 1);
        }
        if (handle == 0 || handle >= this.capacity || !this.elements[handle].free) {
            return 0;
        }
        this.elements[this.elements[handle].previous].next = this.elements[handle].next;
        this.elements[this.elements[handle].next].previous = this.elements[handle].previous;
        if (!preallocate) {
            this.ackAllocation(handle);
        }
        this.elements[handle].free = false;
        ++this.size;
        return handle;
    }

    public void ackAllocation(int handle) {
        if (this.first == 0) {
            this.first = handle;
        }
        this.elements[handle].next = 0;
        this.elements[handle].previous = this.last;
        if (this.last != 0) {
            this.elements[this.last].next = handle;
        }
        this.last = handle;
    }

    public void deallocate(int handle) {
        this.deallocate(handle, false);
    }

    public void deallocate(int handle, boolean depreallocate) {
        if (this.elements[handle].free) {
            return;
        }
        if (!depreallocate) {
            if (this.elements[handle].previous != 0) {
                this.elements[this.elements[handle].previous].next = this.elements[handle].next;
            } else {
                this.first = this.elements[handle].next;
            }
            if (this.elements[handle].next != 0) {
                this.elements[this.elements[handle].next].previous = this.elements[handle].previous;
            } else {
                this.last = this.elements[handle].previous;
            }
        }
        this.elements[handle].free = true;
        this.elements[this.elements[0].previous].next = handle;
        this.elements[handle].previous = this.elements[0].previous;
        this.elements[handle].next = 0;
        this.elements[0].previous = handle;
        this.elements[handle].data = null;
        --this.size;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("HandleDataStore = { ");
        sbuff.append("size = '");
        sbuff.append(this.size);
        sbuff.append("', capacity = '");
        sbuff.append(this.capacity);
        sbuff.append("', elements = { ");
        int h = this.first();
        while (h != 0) {
            sbuff.append(this.get(h));
            if ((h = this.next(h)) == 0) continue;
            sbuff.append(", ");
        }
        sbuff.append(" }}");
        return new String(sbuff);
    }

    private class Element
    implements Serializable {
        private static final long serialVersionUID = -6225830724337396211L;
        int previous;
        int next;
        Object data;
        boolean free;

        private Element() {
        }
    }
}

