/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.Tables;

public class Strings {
    private static Map patterns = new HashMap();

    private Strings() {
    }

    public static String concat(String s1, String s2) {
        return (s1 == null ? "" : s1) + (s2 == null ? "" : s2);
    }

    public static String concat(String s1, String s2, String s3) {
        return (s1 == null ? "" : s1) + (s2 == null ? "" : s2) + (s3 == null ? "" : s3);
    }

    public static String concat(String s1, String s2, String s3, String s4) {
        return (s1 == null ? "" : s1) + (s2 == null ? "" : s2) + (s3 == null ? "" : s3) + (s4 == null ? "" : s4);
    }

    public static boolean equals(String s1, String s2) {
        boolean b1 = Tables.isBlank((Object)s1);
        boolean b2 = Tables.isBlank((Object)s2);
        if (b1 && b2) {
            return true;
        }
        if (b1 || b2) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        boolean b1 = Tables.isBlank((Object)s1);
        boolean b2 = Tables.isBlank((Object)s2);
        if (b1 && b2) {
            return true;
        }
        if (b1 || b2) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean startsWith(String whole, String start) {
        return whole != null && whole.startsWith(start);
    }

    public static boolean endsWith(String whole, String end) {
        return whole != null && whole.endsWith(end);
    }

    public static boolean contains(String whole, String sub) {
        return whole != null && whole.indexOf(sub) >= 0;
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static boolean matches(String str, String regex) {
        return str != null && Strings.getPattern(regex).matcher(str).find();
    }

    public static String matchGroup(String str, String regex) {
        Matcher matcher;
        if (str != null && (matcher = Strings.getPattern(regex).matcher(str)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String replaceFirst(String str, String regex, String replacement) {
        return str == null ? null : Strings.getPattern(regex).matcher(str).replaceFirst(replacement == null ? "" : replacement);
    }

    public static String replaceAll(String str, String regex, String replacement) {
        return str == null ? null : Strings.getPattern(regex).matcher(str).replaceAll(replacement == null ? "" : replacement);
    }

    public static String substring(String str, int startIndex) {
        return str == null || str.length() < startIndex ? null : str.substring(startIndex);
    }

    public static String substring(String str, int startIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        int leng = str.length();
        return str.substring(Math.min(startIndex, leng), Math.min(endIndex, leng));
    }

    public static String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String padWithZeros(long value, int ndigit) {
        String sval = Long.toString(value);
        int sl = sval.length();
        if (sl < ndigit) {
            char[] cbuf = new char[ndigit - sl];
            Arrays.fill(cbuf, '0');
            sval = new String(cbuf) + sval;
        }
        return sval;
    }

    private static Pattern getPattern(String regex) {
        Pattern pat = (Pattern)patterns.get(regex);
        if (pat == null) {
            pat = Pattern.compile(regex);
            patterns.put(regex, pat);
        }
        return pat;
    }
}

