/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.ResourceHandler;
import org.astrogrid.samp.httpd.ServerResource;
import org.astrogrid.samp.httpd.URLMapperHandler;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.DefaultMultiParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;

public class SampMode
implements ProcessingMode {
    private final DefaultMultiParameter formatsParam_ = new DefaultMultiParameter("format", ' ');
    private final Parameter clientParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.mode");
    static /* synthetic */ Class class$uk$ac$starlink$ttools$Stilts;

    public SampMode() {
        this.formatsParam_.setPrompt("Format(s) for SAMP transmission of table");
        this.formatsParam_.setDescription(new String[]{"<p>Gives one or more table format types for attempting the", "table transmission over SAMP.", "If multiple values are supplied, they should be separated", "by spaces.", "Each value supplied for this parameter corresponds to a different", "MType which may be used for the transmission.", "If a single value is used, a SAMP broadcast will be used.", "If multiple values are used, each registered client will be", "interrogated to see whether it subscribes to the corresponding", "MTypes in order; the first one to which it is subscribed will be", "used to send the table.", "The standard options are", "<ul>", "<li><code>votable</code>:", "use MType <code>table.load.votable</code></li>", "<li><code>fits</code>:", "use MType <code>table.load.fits</code></li>", "</ul>", "If any other string is used which corresponds to one of", "STILTS's known table output formats,", "an attempt will be made to use an ad-hoc MType of the form", "<code>table.load.format</code>.", "</p>"});
        this.formatsParam_.setDefault("votable fits");
        this.clientParam_ = new Parameter("client");
        this.clientParam_.setDescription(new String[]{"<p>Identifies a registered SAMP client which is to", "receive the table.", "Either the client ID or the (case-insensitive) application name", "may be used.", "If a non-null value is given, then the table will be sent to", "only the first client with the given name or ID.", "If no value is supplied the table will be sent to", "all suitably subscribed clients.", "</p>"});
        this.clientParam_.setNullPermitted(true);
        this.clientParam_.setPrompt("Recipient client name or ID");
        this.clientParam_.setUsage("<name-or-id>");
    }

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Sends the table to registered SAMP-aware applications", "subscribed to a suitable table load MType.", "SAMP, the Simple Application Messaging Protocol,", "is a tool interoperability protocol.", "A <em>SAMP Hub</em> must be running for this to work.", "</p>"});
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.formatsParam_, this.clientParam_};
    }

    public TableConsumer createConsumer(Environment env) throws TaskException {
        final String[] formats = this.formatsParam_.stringsValue(env);
        final StarTableWriter[] writers = new StarTableWriter[formats.length];
        final String targetClient = this.clientParam_.stringValue(env);
        StarTableOutput sto = LineTableEnvironment.getTableOutput(env);
        final PrintStream out = env.getOutputStream();
        for (int i = 0; i < formats.length; ++i) {
            try {
                writers[i] = sto.getHandler(formats[i]);
            }
            catch (TableFormatException e) {
                // empty catch block
            }
            if (writers[i] != null) continue;
            throw new ParameterValueException((Parameter)this.formatsParam_, "Unknown table format " + formats[i]);
        }
        return new TableConsumer(){

            public void consume(StarTable table) throws IOException {
                TableTransmitter transmitter = new TableTransmitter(formats, writers, table, targetClient, out);
                transmitter.run();
                transmitter.close();
            }
        };
    }

    public static Metadata getStiltsMetadata() {
        Metadata meta = new Metadata();
        meta.setName("STILTS");
        meta.setDescriptionText("STIL Tool Set - table manipulation suite");
        meta.setDocumentationUrl("http://www.starlink.ac.uk/stilts/");
        meta.put((Object)"author.name", (Object)"Mark Taylor");
        meta.put((Object)"author.affiliation", (Object)"Astrophysics Group, Bristol University, UK");
        meta.put((Object)"author.email", (Object)"m.b.taylor@bristol.ac.uk");
        return meta;
    }

    static Message createSendMessage(final StarTable table, String format, final StarTableWriter writer, ResourceHandler resHandler) {
        Message msg = new Message("table.load." + format);
        ServerResource tableResource = new ServerResource(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return writer.getMimeType();
            }

            public void writeBody(OutputStream out) throws IOException {
                writer.writeStarTable(table, out);
            }
        };
        msg.addParam("url", (Object)resHandler.addResource("table." + format, tableResource).toString());
        String name = table.getName();
        if (name == null) {
            name = "(stilts)";
        }
        if (name != null && name.length() > 0) {
            msg.addParam("name", (Object)name);
        }
        return msg;
    }

    private static class ResponseCollector
    implements CallableClient {
        private final TableTransmitter transmitter_;
        private String[] recipientIds_;
        private final Map responseMap_;
        private boolean interrupted_;

        ResponseCollector(TableTransmitter transmitter) {
            this.transmitter_ = transmitter;
            this.responseMap_ = new HashMap();
        }

        public String getTag() {
            return "table";
        }

        public synchronized void waitForResponses(String[] recipientIds) throws InterruptedException {
            HashSet<String> recipientIdList = new HashSet<String>(Arrays.asList(recipientIds));
            while (!this.responseMap_.keySet().containsAll(recipientIdList) && !this.interrupted_) {
                if (this.interrupted_) {
                    throw new InterruptedException();
                }
                this.wait();
            }
        }

        synchronized void interrupt() {
            this.interrupted_ = true;
            this.notifyAll();
        }

        public void receiveCall(String senderId, String msgId, Message msg) {
            throw new UnsupportedOperationException();
        }

        public void receiveNotification(String senderId, Message msg) {
            throw new UnsupportedOperationException();
        }

        public synchronized void receiveResponse(String responderId, String msgTag, Response response) {
            if (msgTag.equals(this.getTag())) {
                this.responseMap_.put(responderId, response);
                String responderString = this.transmitter_.formatId(responderId);
                this.transmitter_.println("Response " + response.getStatus() + " from " + responderString);
                if (!response.isOK()) {
                    logger_.info(responderString + " error info:\n" + SampUtils.formatObject((Object)response.getErrInfo(), (int)2));
                }
            } else {
                throw new IllegalArgumentException("Unknown tag " + msgTag + "??");
            }
            this.notifyAll();
        }
    }

    static class TableTransmitter {
        private final String[] formats_;
        private final StarTableWriter[] writers_;
        private final StarTable table_;
        private final String targetClient_;
        private final PrintStream out_;
        private final HubConnection connection_;
        private final HttpServer httpd_;
        private final ResponseCollector responseCollector_;
        private final Map nameMap_;

        TableTransmitter(String[] formats, StarTableWriter[] writers, StarTable table, String targetClient, PrintStream out) throws IOException {
            if (formats.length != writers.length) {
                throw new IllegalArgumentException();
            }
            this.formats_ = formats;
            this.writers_ = writers;
            this.table_ = table;
            this.targetClient_ = targetClient;
            this.out_ = out;
            this.nameMap_ = new HashMap();
            if (!SampUtils.getLockFile().exists()) {
                throw new IOException("No SAMP hub is running");
            }
            this.connection_ = StandardClientProfile.getInstance().register();
            if (this.connection_ == null) {
                throw new IOException("No SAMP hub running");
            }
            this.httpd_ = new HttpServer();
            this.httpd_.setDaemon(true);
            this.httpd_.start();
            URL iconUrl = (class$uk$ac$starlink$ttools$Stilts == null ? (class$uk$ac$starlink$ttools$Stilts = SampMode.class$("uk.ac.starlink.ttools.Stilts")) : class$uk$ac$starlink$ttools$Stilts).getResource("images/stilts_icon.gif");
            Metadata meta = SampMode.getStiltsMetadata();
            if (iconUrl != null) {
                URLMapperHandler iconHandler = new URLMapperHandler(this.httpd_, "stilts_icon.gif", iconUrl, false);
                this.httpd_.addHandler((HttpServer.Handler)iconHandler);
                meta.setIconUrl(iconHandler.getBaseUrl().toString());
            }
            this.connection_.declareMetadata((Map)meta);
            this.responseCollector_ = new ResponseCollector(this);
            this.connection_.setCallable((CallableClient)this.responseCollector_);
        }

        public void run() throws IOException {
            Set<Object> recipientList;
            ResourceHandler resourceHandler = new ResourceHandler(this.httpd_, "stilts-table");
            this.httpd_.addHandler((HttpServer.Handler)resourceHandler);
            String msgTag = this.responseCollector_.getTag();
            if (this.targetClient_ != null) {
                String[] clientIds = this.connection_.getRegisteredClients();
                String targetId = null;
                for (int ic = 0; ic < clientIds.length && targetId == null; ++ic) {
                    String clientId = clientIds[ic];
                    if (!this.targetClient_.equals(clientId) && !this.targetClient_.equalsIgnoreCase(this.getClientName(clientId))) continue;
                    targetId = clientId;
                }
                if (targetId == null) {
                    throw new IOException("No registered client with name or ID " + this.targetClient_);
                }
                Subscriptions subs = this.connection_.getSubscriptions(targetId);
                boolean sent = false;
                for (int i = 0; i < this.formats_.length && !sent; ++i) {
                    Message msg = SampMode.createSendMessage(this.table_, this.formats_[i], this.writers_[i], resourceHandler);
                    if (!subs.isSubscribed(msg.getMType())) continue;
                    this.connection_.call(targetId, msgTag, (Map)msg);
                    this.println("Send " + msg.getMType() + " to " + this.formatId(targetId));
                    sent = true;
                }
                if (!sent) {
                    throw new IOException("Client " + this.formatId(targetId) + " not subscribed to any suitable" + " MType");
                }
                recipientList = Collections.singleton(targetId);
            } else if (this.formats_.length == 1) {
                Message msg = SampMode.createSendMessage(this.table_, this.formats_[0], this.writers_[0], resourceHandler);
                Map recipientMap = this.connection_.callAll(msgTag, (Map)msg);
                recipientList = recipientMap.keySet();
                StringBuffer sbuf = new StringBuffer().append("Broadcast ").append(msg.getMType()).append(" to ");
                Iterator it = recipientList.iterator();
                while (it.hasNext()) {
                    String clientId = (String)it.next();
                    sbuf.append(this.formatId(clientId));
                    if (!it.hasNext()) continue;
                    sbuf.append(", ");
                }
                this.println(sbuf.toString());
            } else {
                recipientList = new HashSet();
                for (int i = 0; i < this.formats_.length; ++i) {
                    Message msg = SampMode.createSendMessage(this.table_, this.formats_[i], this.writers_[i], resourceHandler);
                    Set clientIdSet = this.connection_.getSubscribedClients(msg.getMType()).keySet();
                    Iterator it = clientIdSet.iterator();
                    while (it.hasNext()) {
                        String clientId = (String)it.next();
                        if (recipientList.contains(clientId)) continue;
                        this.connection_.call(clientId, msgTag, (Map)msg);
                        recipientList.add(clientId);
                        this.println("Send " + msg.getMType() + " to " + this.formatId(clientId));
                    }
                }
            }
            try {
                this.responseCollector_.waitForResponses(recipientList.toArray(new String[0]));
            }
            catch (InterruptedException e) {
                logger_.warning("Interrupted");
            }
        }

        public void close() throws IOException {
            this.httpd_.stop();
            this.connection_.unregister();
        }

        private void println(String line) {
            if (this.out_ != null) {
                this.out_.println(line);
            }
        }

        private String getClientName(String clientId) {
            if (!this.nameMap_.containsKey(clientId)) {
                String name = null;
                try {
                    Metadata meta = this.connection_.getMetadata(clientId);
                    if (meta != null) {
                        name = meta.getName();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.nameMap_.put(clientId, name);
            }
            return (String)this.nameMap_.get(clientId);
        }

        private String formatId(String clientId) {
            StringBuffer sbuf = new StringBuffer().append(clientId);
            String name = this.getClientName(clientId);
            if (name != null && name.length() > 0) {
                sbuf.append(" (").append(name).append(')');
            }
            return sbuf.toString();
        }
    }
}

