/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ContourPlot {
    static final int N_CONTOURS = 10;
    static final double Z_MAX_MAX = 1.0E10;
    static final double Z_MIN_MIN = -1.0E10;
    int xSteps;
    int ySteps;
    double[][] z;
    Dimension d;
    double deltaX;
    double deltaY;
    int ncv = 10;
    int[] l1 = new int[4];
    int[] l2 = new int[4];
    int[] ij = new int[2];
    int[] i1 = new int[2];
    int[] i2 = new int[2];
    int[] i3 = new int[6];
    int ibkey;
    int icur;
    int jcur;
    int ii;
    int jj;
    int elle;
    int ix;
    int iedge;
    int iflag;
    int ni;
    int ks;
    int cntrIndex;
    int prevIndex;
    int idir;
    int nxidir;
    int k;
    double z1;
    double z2;
    double cval;
    double zMax;
    double zMin;
    double[] intersect = new double[4];
    double[] xy = new double[2];
    double[] prevXY = new double[2];
    double[] cv = new double[this.ncv];
    String[] labels;
    boolean jump;

    int sign(int a, int b) {
        a = Math.abs(a);
        if (b < 0) {
            return -a;
        }
        return a;
    }

    void assignContourValues() {
        double delta = (this.zMax - this.zMin) / (double)this.ncv;
        for (int i = 0; i < this.ncv; ++i) {
            this.cv[i] = this.zMin + (double)(i + 1) * delta;
        }
    }

    void setMeasurements(Dimension d) {
        this.deltaX = (double)d.height / ((double)this.xSteps - 1.0);
        this.deltaY = (double)d.width / ((double)this.ySteps - 1.0);
    }

    void setColour(Graphics g) {
        Color c = new Color(255, 255, 255);
        g.setColor(c);
    }

    void drawKernel(Graphics g) {
        if (this.iflag == 1 || this.iflag == 4 || this.iflag == 5) {
            if (this.cntrIndex != this.prevIndex) {
                this.setColour(g);
                this.prevIndex = this.cntrIndex;
            }
            int prevU = (int)((this.prevXY[0] - 1.0) * this.deltaX);
            int prevV = (int)((this.prevXY[1] - 1.0) * this.deltaY);
            int u = (int)((this.xy[0] - 1.0) * this.deltaX);
            int v = (int)((this.xy[1] - 1.0) * this.deltaY);
            g.drawLine(prevV, prevU, v, u);
            if (this.iflag == 4 || this.iflag == 5) {
                if (u == 0) {
                    u += 10;
                } else if (v == this.d.width) {
                    v -= 60;
                }
                g.drawString(this.labels[this.cntrIndex], v, u);
            }
        }
        this.prevXY[0] = this.xy[0];
        this.prevXY[1] = this.xy[1];
    }

    void detectBoundary() {
        this.ix = 1;
        if (this.ij[1 - this.elle] != 1) {
            this.ii = this.ij[0] - this.i1[1 - this.elle];
            this.jj = this.ij[1] - this.i1[this.elle];
            if (this.z[this.ii - 1][this.jj - 1] <= 1.0E10) {
                this.ii = this.ij[0] + this.i2[this.elle];
                this.jj = this.ij[1] + this.i2[1 - this.elle];
                if (this.z[this.ii - 1][this.jj - 1] < 1.0E10) {
                    this.ix = 0;
                }
            }
            if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                this.ix += 2;
                return;
            }
        }
        this.ii = this.ij[0] + this.i1[1 - this.elle];
        this.jj = this.ij[1] + this.i1[this.elle];
        if (this.z[this.ii - 1][this.jj - 1] > 1.0E10) {
            this.ix += 2;
            return;
        }
        if (this.z[this.ij[0]][this.ij[1]] >= 1.0E10) {
            this.ix += 2;
        }
    }

    boolean routine_label_020() {
        this.l2[0] = this.ij[0];
        this.l2[1] = this.ij[1];
        this.l2[2] = -this.ij[0];
        this.l2[3] = -this.ij[1];
        this.idir = 0;
        this.nxidir = 1;
        this.k = 1;
        this.ij[0] = Math.abs(this.ij[0]);
        this.ij[1] = Math.abs(this.ij[1]);
        if (this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
            this.elle = this.idir % 2;
            this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
            return true;
        }
        this.elle = 0;
        return false;
    }

    boolean routine_label_050() {
        block2: {
            while (true) {
                if (this.ij[this.elle] >= this.l1[this.elle]) {
                    if (++this.elle <= 1) continue;
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (!this.routine_label_150()) continue;
                    return true;
                }
                this.ii = this.ij[0] + this.i1[this.elle];
                this.jj = this.ij[1] + this.i1[1 - this.elle];
                if (!(this.z[this.ii - 1][this.jj - 1] > 1.0E10)) break block2;
                if (++this.elle <= 1) continue;
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.routine_label_150()) break;
            }
            return true;
        }
        this.jump = false;
        return false;
    }

    boolean routine_label_150() {
        while (true) {
            if (this.ij[this.elle] < this.l1[this.k - 1]) {
                int n = this.elle;
                this.ij[n] = this.ij[n] + 1;
                if (this.ij[this.elle] > this.l2[this.k - 1]) {
                    this.l2[this.k - 1] = this.ij[this.elle];
                    this.idir = this.nxidir;
                    this.k = this.nxidir = this.idir + 1;
                    if (this.nxidir > 3) {
                        this.nxidir = 0;
                    }
                }
                this.ij[0] = Math.abs(this.ij[0]);
                this.ij[1] = Math.abs(this.ij[1]);
                if (this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    continue;
                }
                this.elle = 0;
                return false;
            }
            if (this.idir != this.nxidir) {
                this.ij[this.elle] = this.l1[this.k - 1];
                this.k = ++this.nxidir;
                this.elle = 1 - this.elle;
                this.ij[this.elle] = this.l2[this.k - 1];
                if (this.nxidir <= 3) continue;
                this.nxidir = 0;
                continue;
            }
            if (this.ibkey != 0) {
                return true;
            }
            this.ibkey = 1;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (!this.routine_label_020()) break;
        }
        return false;
    }

    short routine_label_200(Graphics g, boolean[] workSpace) {
        while (true) {
            this.xy[this.elle] = 1.0 * (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
            this.xy[1 - this.elle] = 1.0 * (double)this.ij[1 - this.elle];
            workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
            this.drawKernel(g);
            if (this.iflag >= 4) {
                this.icur = this.ij[0];
                this.jcur = this.ij[1];
                return 1;
            }
            this.continueContour();
            if (!workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                return 2;
            }
            this.iflag = 5;
            this.iedge = this.ks + 2;
            if (this.iedge > 4) {
                this.iedge -= 4;
            }
            this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
        }
    }

    boolean crossedByContour(boolean[] workSpace) {
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.z1 = this.z[this.ij[0] - 1][this.ij[1] - 1];
        this.z2 = this.z[this.ii - 1][this.jj - 1];
        this.cntrIndex = 0;
        while (this.cntrIndex < this.ncv) {
            double x;
            int i = 2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
            if (!workSpace[i] && (x = this.cv[this.cntrIndex]) > Math.min(this.z1, this.z2) && x <= Math.max(this.z1, this.z2)) {
                workSpace[i] = true;
                return true;
            }
            ++this.cntrIndex;
        }
        return false;
    }

    void continueContour() {
        this.ni = 1;
        if (this.iedge >= 3) {
            this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
            this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
        }
        for (int local_k = 1; local_k < 5; local_k = (int)((short)(local_k + 1))) {
            if (local_k == this.iedge) continue;
            this.ii = this.ij[0] + this.i3[local_k - 1];
            this.jj = this.ij[1] + this.i3[local_k];
            this.z1 = this.z[this.ii - 1][this.jj - 1];
            this.ii = this.ij[0] + this.i3[local_k];
            this.jj = this.ij[1] + this.i3[local_k + 1];
            this.z2 = this.z[this.ii - 1][this.jj - 1];
            if (!(this.cval > Math.min(this.z1, this.z2)) || !(this.cval <= Math.max(this.z1, this.z2))) continue;
            if (local_k == 1 || local_k == 4) {
                double zz = this.z2;
                this.z2 = this.z1;
                this.z1 = zz;
            }
            this.intersect[local_k - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
            ++this.ni;
            this.ks = local_k;
        }
        if (this.ni != 2) {
            this.ks = 5 - this.iedge;
            if (this.intersect[2] >= this.intersect[0]) {
                this.ks = 3 - this.iedge;
                if (this.ks <= 0) {
                    this.ks += 4;
                }
            }
        }
        this.elle = this.ks - 1;
        this.iflag = 1;
        this.jump = true;
        if (this.ks >= 3) {
            this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
            this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
            this.elle = this.ks - 3;
        }
    }

    void contourPlotKernel(Graphics g, boolean[] workSpace) {
        this.l1[0] = this.xSteps;
        this.l1[1] = this.ySteps;
        this.l1[2] = -1;
        this.l1[3] = -1;
        this.i1[0] = 1;
        this.i1[1] = 0;
        this.i2[0] = 1;
        this.i2[1] = -1;
        this.i3[0] = 1;
        this.i3[1] = 0;
        this.i3[2] = 0;
        this.i3[3] = 1;
        this.i3[4] = 1;
        this.i3[5] = 0;
        this.prevXY[0] = 0.0;
        this.prevXY[1] = 0.0;
        this.xy[0] = 1.0;
        this.xy[1] = 1.0;
        this.cntrIndex = 0;
        this.prevIndex = -1;
        this.iflag = 6;
        this.drawKernel(g);
        this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
        this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
        this.ibkey = 0;
        this.ij[0] = this.icur;
        this.ij[1] = this.jcur;
        if (this.routine_label_020() && this.routine_label_150()) {
            return;
        }
        if (this.routine_label_050()) {
            return;
        }
        while (true) {
            short val_label_200;
            this.detectBoundary();
            if (this.jump) {
                if (this.ix != 0) {
                    this.iflag = 4;
                }
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                val_label_200 = this.routine_label_200(g, workSpace);
                if (val_label_200 == 1) {
                    if (this.routine_label_020() && this.routine_label_150()) {
                        return;
                    }
                    if (!this.routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (this.ix != 3 && this.ix + this.ibkey != 0 && this.crossedByContour(workSpace)) {
                this.iedge = this.elle + 1;
                this.cval = this.cv[this.cntrIndex];
                if (this.ix != 1) {
                    this.iedge += 2;
                }
                this.iflag = 2 + this.ibkey;
                this.intersect[this.iedge - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                val_label_200 = this.routine_label_200(g, workSpace);
                if (val_label_200 == 1) {
                    if (this.routine_label_020() && this.routine_label_150()) {
                        return;
                    }
                    if (!this.routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (++this.elle > 1) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.routine_label_150()) {
                    return;
                }
            }
            if (this.routine_label_050()) break;
        }
    }

    public void paint(Graphics g, Dimension d) {
        this.d = d;
        int workLength = 2 * this.xSteps * this.ySteps * this.ncv;
        this.setMeasurements(d);
        if (this.cv[0] != this.cv[1]) {
            boolean[] workSpace = new boolean[workLength];
            this.contourPlotKernel(g, workSpace);
        }
    }

    public void setData(double[][] data, double[] levels) {
        this.setData(data, levels, null);
    }

    public void setData(double[][] data, double[] levels, String[] labels) {
        this.z = data;
        this.setLevels(levels, labels);
        this.calcParams();
    }

    public void setLevels(double[] levels, String[] labels) {
        this.cv = levels;
        int n = this.ncv = levels == null ? 0 : levels.length;
        if (this.ncv == 0) {
            this.cv = new double[]{0.0, 0.0};
            return;
        }
        if (labels == null) {
            this.labels = new String[this.ncv];
            for (int i = 0; i < this.ncv; ++i) {
                this.labels[i] = Float.toString((float)this.cv[i]);
            }
        } else {
            this.labels = labels;
        }
    }

    private void calcParams() {
        this.xSteps = this.z.length;
        this.ySteps = this.z[0].length;
        this.zMax = this.z[0][0];
        this.zMin = this.z[0][0];
        double[][] dArray = this.z;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] z1;
            for (double z2 : z1 = dArray[i]) {
                this.zMax = Math.max(this.zMax, z2);
                this.zMin = Math.min(this.zMin, z2);
            }
        }
        if (this.zMax > 1.0E10) {
            this.zMax = 1.0E10;
        }
        if (this.zMin < -1.0E10) {
            this.zMin = -1.0E10;
        }
        if (this.cv == null) {
            this.ncv = 10;
            this.cv = new double[this.ncv];
            this.assignContourValues();
        }
    }
}

