/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.ColumnReader;
import uk.ac.starlink.fits.HeaderCards;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;

public abstract class BintableStarTable
extends AbstractStarTable {
    private final int ncol;
    private final int nrow;
    private final ColumnInfo[] colInfos;
    private final ColumnReader[] colReaders;
    private final int rowLength;
    private final int[] colOffsets;
    public static final ValueInfo TNULL_INFO = new DefaultValueInfo(Tables.NULL_VALUE_INFO.getName(), Tables.NULL_VALUE_INFO.getContentClass(), "Bad value indicator (TNULLn card)");
    public static final ValueInfo TSCAL_INFO = new DefaultValueInfo("Scale", Double.class, "Multiplier for values (TSCALn card)");
    public static final ValueInfo TZERO_INFO = new DefaultValueInfo("Zero", Number.class, "Offset for values (TZEROn card)");
    public static final ValueInfo TDISP_INFO = new DefaultValueInfo("Format", String.class, "Display format in FORTRAN notation (TDISPn card)");
    public static final ValueInfo TBCOL_INFO = new DefaultValueInfo("Start column", Integer.class, "Start column for data (TBCOLn card)");
    public static final ValueInfo TFORM_INFO = new DefaultValueInfo("Format code", String.class, "Data type code (TFORMn card)");
    private static final List auxDataInfos = Arrays.asList(TNULL_INFO, TSCAL_INFO, TZERO_INFO, TDISP_INFO, TBCOL_INFO, TFORM_INFO);
    static final BigInteger TWO63 = BigInteger.ONE.shiftLeft(63);

    public static StarTable makeRandomStarTable(Header hdr, final RandomAccess rstream) throws FitsException {
        final long dataStart = rstream.getFilePointer();
        return new BintableStarTable(hdr, dataStart){
            final long rowLength;
            final int[] colOffsets;
            final int ncol;
            {
                super(x0, x1);
                this.rowLength = this.getRowLength();
                this.colOffsets = this.getColumnOffsets();
                this.ncol = this.getColumnCount();
            }

            public boolean isRandom() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getCell(long lrow, int icol) throws IOException {
                RandomAccess randomAccess = rstream;
                synchronized (randomAccess) {
                    long offset = dataStart + lrow * this.rowLength + (long)this.colOffsets[icol];
                    rstream.seek(offset);
                    return this.readCell(rstream, icol);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getRow(long lrow) throws IOException {
                Object[] row = new Object[this.ncol];
                RandomAccess randomAccess = rstream;
                synchronized (randomAccess) {
                    rstream.seek(dataStart + lrow * this.rowLength);
                    return this.readRow(rstream);
                }
            }

            public RowSequence getRowSequence() {
                return new RandomRowSequence(this);
            }
        };
    }

    static StarTable makeSequentialStarTable(Header hdr, final DataSource datsrc, final long offset) throws FitsException {
        final Object[] BEFORE_START = new Object[]{};
        return new BintableStarTable(hdr, -1L){

            public RowSequence getRowSequence() throws IOException {
                InputStream istrm = datsrc.getInputStream();
                if (!(istrm instanceof BufferedInputStream)) {
                    istrm = new BufferedInputStream(istrm);
                }
                final DataInputStream stream = new DataInputStream(istrm);
                IOUtils.skipBytes(stream, offset);
                return new RowSequence(){
                    final long nrow;
                    final int ncol;
                    final int rowLength;
                    long lrow;
                    Object[] row;
                    {
                        this.nrow = this.getRowCount();
                        this.ncol = this.getColumnCount();
                        this.rowLength = this.getRowLength();
                        this.lrow = -1L;
                        this.row = BEFORE_START;
                    }

                    public boolean next() throws IOException {
                        if (this.lrow < this.nrow - 1L) {
                            if (this.row == null) {
                                IOUtils.skipBytes(stream, this.rowLength);
                            }
                            this.row = null;
                            ++this.lrow;
                            return true;
                        }
                        return false;
                    }

                    public Object getCell(int icol) throws IOException {
                        return this.getRow()[icol];
                    }

                    public Object[] getRow() throws IOException {
                        if (this.row == BEFORE_START) {
                            throw new IllegalStateException("Attempted read before start of table");
                        }
                        if (this.row == null) {
                            this.row = this.readRow(stream);
                        }
                        return this.row;
                    }

                    public void close() throws IOException {
                        stream.close();
                    }
                };
            }
        };
    }

    public static void streamStarTable(Header hdr, DataInput stream, TableSink sink) throws FitsException, IOException {
        BintableStarTable meta = new BintableStarTable(hdr, -1L){

            public RowSequence getRowSequence() {
                throw new UnsupportedOperationException("Metadata only");
            }
        };
        sink.acceptMetadata(meta);
        long nrow = meta.getRowCount();
        for (long i = 0L; i < nrow; ++i) {
            Object[] row = meta.readRow(stream);
            sink.acceptRow(row);
        }
        sink.endRows();
        long datasize = nrow * (long)meta.getRowLength();
        int over = (int)(datasize % 2880L);
        if (over > 0) {
            IOUtils.skipBytes(stream, 2880 - over);
        }
    }

    BintableStarTable(Header hdr, long dataStart) throws FitsException {
        long heapStart;
        HeaderCards cards = new HeaderCards(hdr);
        if (!cards.getStringValue("XTENSION").equals("BINTABLE")) {
            throw new IllegalArgumentException("Not a binary table header");
        }
        this.ncol = cards.getIntValue("TFIELDS");
        this.nrow = cards.getIntValue("NAXIS2");
        if (dataStart >= 0L) {
            long theap = cards.containsKey("THEAP") ? cards.getLongValue("THEAP") : (long)(this.nrow * cards.getIntValue("NAXIS1"));
            heapStart = dataStart + theap;
        } else {
            heapStart = -1L;
        }
        this.colInfos = new ColumnInfo[this.ncol];
        this.colReaders = new ColumnReader[this.ncol];
        for (int icol = 0; icol < this.ncol; ++icol) {
            ColumnReader reader;
            String tutype;
            String tucd;
            String tcomm;
            String tform;
            Number zero;
            double scale;
            String[] sdims;
            boolean hasBlank;
            long blank;
            String blankKey;
            String tdisp;
            String tunit;
            int jcol = icol + 1;
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            List auxdata = cinfo.getAuxData();
            this.colInfos[icol] = cinfo;
            String ttype = cards.getStringValue("TTYPE" + jcol);
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = cards.getStringValue("TUNIT" + jcol)) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = cards.getStringValue("TDISP" + jcol)) != null) {
                auxdata.add(new DescribedValue(TDISP_INFO, tdisp));
            }
            if (cards.containsKey(blankKey = "TNULL" + jcol)) {
                blank = cards.getLongValue(blankKey);
                hasBlank = true;
                auxdata.add(new DescribedValue(TNULL_INFO, new Long(blank)));
            } else {
                cinfo.setNullable(false);
                blank = 0L;
                hasBlank = false;
            }
            int[] dims = null;
            String tdim = cards.getStringValue("TDIM" + jcol);
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    dims = new int[sdims.length];
                    for (int i = 0; i < sdims.length; ++i) {
                        dims[i] = Integer.parseInt(sdims[i]);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (cards.containsKey("TSCAL" + jcol)) {
                scale = cards.getDoubleValue("TSCAL" + jcol);
                auxdata.add(new DescribedValue(TSCAL_INFO, new Double(scale)));
            } else {
                scale = 1.0;
            }
            if (cards.containsKey("TZERO" + jcol)) {
                Object zval;
                boolean zInLongRange;
                String zstr = cards.getStringValue("TZERO" + jcol);
                BigDecimal zbig = new BigDecimal(zstr);
                boolean zIsInt = zbig.compareTo(new BigDecimal(zbig.toBigInteger())) == 0;
                boolean bl = zInLongRange = zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MIN_VALUE))) >= 0 && zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE))) <= 0;
                if (zbig.compareTo(new BigDecimal(TWO63)) == 0) {
                    zero = TWO63;
                    zval = zstr;
                } else if (zIsInt && zInLongRange) {
                    zero = new Long(zbig.longValue());
                    zval = zero;
                } else {
                    zero = new Double(zbig.doubleValue());
                    zval = zero;
                }
                DefaultValueInfo zInfo = new DefaultValueInfo(TZERO_INFO);
                zInfo.setContentClass(zval.getClass());
                auxdata.add(new DescribedValue(zInfo, zval));
            } else {
                zero = new Long(0L);
            }
            String tbcol = cards.getStringValue("TBCOL" + jcol);
            if (tbcol != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(TBCOL_INFO, new Integer(bcolval)));
            }
            if ((tform = cards.getStringValue("TFORM" + jcol)) != null) {
                auxdata.add(new DescribedValue(TFORM_INFO, tform));
            }
            if ((tcomm = cards.getStringValue("TCOMM" + jcol)) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = cards.getStringValue("TUCD" + jcol)) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = cards.getStringValue("TUTYP" + jcol)) != null) {
                Tables.setUtype(cinfo, tutype);
            }
            try {
                reader = ColumnReader.createColumnReader(tform, scale, zero, hasBlank, blank, dims, ttype, heapStart);
            }
            catch (FitsException e) {
                throw (FitsException)new FitsException("Error parsing header line TFORM" + jcol + " = " + tform).initCause(e);
            }
            if (reader.getContentClass().equals(class$java$lang$String == null ? BintableStarTable.class$("java.lang.String") : class$java$lang$String)) {
                cinfo.setNullable(true);
            }
            cinfo.setContentClass(reader.getContentClass());
            cinfo.setShape(reader.getShape());
            cinfo.setElementSize(reader.getElementSize());
            this.colReaders[icol] = reader;
        }
        int leng = 0;
        this.colOffsets = new int[this.ncol];
        for (int icol = 0; icol < this.ncol; ++icol) {
            this.colOffsets[icol] = leng;
            leng += this.colReaders[icol].getLength();
        }
        this.rowLength = leng;
        int nax1 = cards.getIntValue("NAXIS1");
        if (this.rowLength != nax1) {
            throw new FitsException("Got wrong row length: " + nax1 + " != " + this.rowLength);
        }
        this.getParameters().addAll(Arrays.asList(cards.getUnusedParams()));
    }

    public long getRowCount() {
        return this.nrow;
    }

    public int getColumnCount() {
        return this.ncol;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos[icol];
    }

    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    public Object readCell(DataInput stream, int icol) throws IOException {
        return this.colReaders[icol].readValue(stream);
    }

    public Object[] readRow(DataInput stream) throws IOException {
        Object[] row = new Object[this.ncol];
        this.readRow(stream, row);
        return row;
    }

    public void readRow(DataInput stream, Object[] row) throws IOException {
        for (int icol = 0; icol < this.ncol; ++icol) {
            row[icol] = this.colReaders[icol].readValue(stream);
        }
    }

    protected int getRowLength() {
        return this.rowLength;
    }

    protected int[] getColumnOffsets() {
        return this.colOffsets;
    }
}

