/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasPane;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.event.EventAcceptor;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PaneWrapper
extends AbstractFigure
implements EventAcceptor {
    private boolean _clipEnabled = true;
    private CanvasPane _wrappedPane = null;
    private Figure _background = null;

    public PaneWrapper(CanvasPane pane) {
        this._wrappedPane = pane;
        pane.setParent(this);
    }

    public void dispatchEvent(AWTEvent event) {
        if (event instanceof LayerEvent) {
            this.processLayerEvent((LayerEvent)event);
        } else {
            System.out.println("Bad event: " + event);
        }
    }

    public Figure getBackground() {
        return this._background;
    }

    public Shape getShape() {
        if (this._background != null) {
            return this._background.getShape();
        }
        Point2D d = this._wrappedPane.getSize();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, d.getX(), d.getY());
        AffineTransform at = this._wrappedPane.getTransformContext().getTransform();
        return at.createTransformedShape(r);
    }

    public CanvasPane getWrappedPane() {
        return this._wrappedPane;
    }

    public boolean isClipEnabled() {
        return this._clipEnabled;
    }

    public boolean isEnabled() {
        return this._wrappedPane.isEnabled();
    }

    public void paint(Graphics2D g) {
        if (this._background != null) {
            this._background.paint(g);
        }
        Shape currentClip = g.getClip();
        if (this.isClipEnabled() && currentClip != null) {
            Area a = new Area(currentClip);
            a.intersect(new Area(this.getShape()));
            g.setClip(a);
            this._wrappedPane.paint(g);
            g.setClip(currentClip);
        } else {
            this._wrappedPane.paint(g);
        }
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (this._background != null) {
            this._background.paint(g, region);
        }
        Shape currentClip = g.getClip();
        if (this.isClipEnabled() && currentClip != null) {
            Area a = new Area(currentClip);
            a.intersect(new Area(this.getShape()));
            g.setClip(a);
            this._wrappedPane.paint(g, region);
            g.setClip(currentClip);
        } else {
            this._wrappedPane.paint(g, region);
        }
    }

    protected void processLayerEvent(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Interactor r = this.getInteractor();
        if (r != null && r instanceof SelectionInteractor && ((SelectionInteractor)r).getSelectionModel().containsSelection(this)) {
            return;
        }
        double savedX = event.getLayerX();
        double savedY = event.getLayerX();
        AffineTransform at = this._wrappedPane.getTransformContext().getInverseTransform();
        if (!at.isIdentity()) {
            event.transform(at);
        }
        this._wrappedPane.dispatchEvent(event);
        event.setLayerX(savedX);
        event.setLayerY(savedY);
    }

    public void repaint(DamageRegion d) {
        if (this.getParent() != null) {
            this.getParent().repaint(d);
        }
    }

    public void setBackground(Figure background) {
        if (background != null) {
            background.setParent(null);
        }
        this._background = background;
        background.setParent(this);
        this.repaint();
    }

    public void setClipEnabled(boolean flag) {
        this._clipEnabled = flag;
    }

    public void setEnabled(boolean flag) {
        this._wrappedPane.setEnabled(flag);
    }

    public void setTransform(AffineTransform at) {
        this.repaint();
        this._wrappedPane.getTransformContext().setTransform(at);
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        if (this._background != null) {
            this._background.transform(at);
        }
        this._wrappedPane.getTransformContext().preConcatenate(at);
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        if (this._background != null) {
            this._background.translate(x, y);
        }
        this._wrappedPane.getTransformContext().translate(x, y);
        this.repaint();
    }
}

