/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.GraphModel;
import diva.graph.layout.GlobalLayout;
import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;

public class IncrLayoutAdapter
implements IncrementalLayout {
    private LayoutTarget _target;
    private GlobalLayout _layout;

    public IncrLayoutAdapter(GlobalLayout global) {
        this._layout = global;
        this._target = global.getLayoutTarget();
    }

    public void nodeDrawn(Object node) {
        this.layout(this._target.getGraphModel().getParent(node));
    }

    public void nodeMoved(Object node) {
    }

    public void edgeDrawn(Object edge) {
        GraphModel model = this._target.getGraphModel();
        Object root = model.getRoot();
        this.layout(root);
    }

    public void edgeRouted(Object edge) {
        GraphModel model = this._target.getGraphModel();
        Object root = model.getRoot();
        this.layout(root);
    }

    public LayoutTarget getLayoutTarget() {
        return this._layout.getLayoutTarget();
    }

    public void setLayoutTarget(LayoutTarget target) {
        this._layout.setLayoutTarget(target);
    }

    public void layout(Object composite) {
        try {
            this._layout.layout(composite);
        }
        catch (Exception e) {
            System.err.println("Layout Failed: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

