/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PolylineIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Polyline2D
implements Shape {
    protected int _coordCount = 0;

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public abstract Rectangle2D getBounds2D();

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolylineIterator(this, at);
    }

    public int getVertexCount() {
        return this._coordCount / 2;
    }

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    public boolean intersects(Rectangle2D r) {
        if (this._coordCount == 0) {
            return false;
        }
        if (this._coordCount == 1) {
            return r.contains(this.getX(0), this.getY(0));
        }
        int count = this.getVertexCount();
        double x2 = this.getX(0);
        double y2 = this.getY(0);
        for (int i = 1; i < count; ++i) {
            double x1 = x2;
            double y1 = y2;
            if (!r.intersectsLine(x1, y1, x2 = this.getX(i), y2 = this.getY(i))) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    public abstract void lineTo(double var1, double var3);

    public abstract void moveTo(double var1, double var3);

    public void reset() {
        this._coordCount = 0;
    }

    public abstract void setX(int var1, double var2);

    public abstract void setY(int var1, double var2);

    public String toString() {
        StringBuffer string = new StringBuffer(super.toString());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            string.append("(" + this.getX(i) + "," + this.getY(i) + "),");
        }
        return string.toString();
    }

    public abstract void transform(AffineTransform var1);

    public abstract void translate(double var1, double var3);

    public static class Double
    extends Polyline2D {
        double[] _coords = new double[4];

        public Double() {
        }

        public Double(int initSize) {
            this._coords = new double[initSize * 2];
        }

        public Double(double x1, double y1, double x2, double y2) {
            this._coords[0] = x1;
            this._coords[1] = y1;
            this._coords[2] = x2;
            this._coords[3] = y2;
            this._coordCount = 4;
        }

        public Double(Polyline2D in) {
            this._coordCount = in._coordCount;
            this._coords = new double[in._coordCount];
            if (in instanceof Double) {
                Double doubleIn = (Double)in;
                System.arraycopy(doubleIn._coords, 0, this._coords, 0, this._coordCount);
            } else {
                Float floatIn = (Float)in;
                for (int i = 0; i < this._coordCount; ++i) {
                    this._coords[i] = floatIn._coords[i];
                }
            }
        }

        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 0) {
                return new Rectangle2D.Double();
            }
            double x1 = this._coords[0];
            double y1 = this._coords[1];
            double x2 = x1;
            double y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }

        public double getX(int index) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            return this._coords[index * 2];
        }

        public double getY(int index) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            return this._coords[index * 2 + 1];
        }

        public void lineTo(double x, double y) {
            if (this._coordCount == this._coords.length) {
                double[] temp = new double[this._coordCount * 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = x;
            this._coords[this._coordCount++] = y;
        }

        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polyline already has vertices");
            }
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public void setX(int index, double x) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            this._coords[index * 2] = x;
        }

        public void setY(int index, double y) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            this._coords[index * 2 + 1] = y;
        }

        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        public void translate(double x, double y) {
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + x;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + y;
            }
        }
    }

    public static class Float
    extends Polyline2D {
        float[] _coords = new float[4];

        public Float() {
        }

        public Float(int initSize) {
            this._coords = new float[initSize * 2];
        }

        public Float(Polyline2D in) {
            this._coordCount = in._coordCount;
            this._coords = new float[in._coordCount];
            if (in instanceof Float) {
                Float floatIn = (Float)in;
                System.arraycopy(floatIn._coords, 0, this._coords, 0, this._coordCount);
            } else {
                Double doubleIn = (Double)in;
                for (int i = 0; i < this._coordCount; ++i) {
                    this._coords[i] = (float)doubleIn._coords[i];
                }
            }
        }

        public Float(float x1, float y1, float x2, float y2) {
            this._coords[0] = x1;
            this._coords[1] = y1;
            this._coords[2] = x2;
            this._coords[3] = y2;
            this._coordCount = 4;
        }

        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 1) {
                return new Rectangle2D.Float();
            }
            float x1 = this._coords[0];
            float y1 = this._coords[1];
            float x2 = x1;
            float y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
        }

        public double getX(int index) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            return this._coords[index * 2];
        }

        public double getY(int index) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            return this._coords[index * 2 + 1];
        }

        public void lineTo(double x, double y) {
            if (this._coordCount == this._coords.length) {
                float[] temp = new float[this._coordCount * 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = (float)x;
            this._coords[this._coordCount++] = (float)y;
        }

        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polyline already has vertices");
            }
            this._coords[0] = (float)x;
            this._coords[1] = (float)y;
            this._coordCount = 2;
        }

        public void setX(int index, double x) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            this._coords[index * 2] = (float)x;
        }

        public void setY(int index, double y) {
            if (index < 0 || index >= this.getVertexCount()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getVertexCount());
            }
            this._coords[index * 2 + 1] = (float)y;
        }

        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        public void translate(double x, double y) {
            float fx = (float)x;
            float fy = (float)y;
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + fx;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + fy;
            }
        }
    }
}

