#!/usr/bin/env python
#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) ESO - European Southern Observatory, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
# Holography Standard Script
# $Id: TowerHolographyScriptACA7m.py 212670 2014-12-17 01:58:56Z nphillip $
#

# Copyright (c) 2012 National Astronomical Observatory of Japan

from CCL.Global import *
from Observation.TowerHolography7mTarget import TowerHolography7mTarget
from CCL.logging import getLogger
from math import radians
import Control


array = getArray()
array.beginExecution()
executionStatus = Control.FAIL

if len(array.antennas()) != 1:
   # Throw something here
   logger = getLogger()
   logger.logCritical('Incorrect number of antennas in Holography Array')
   raise Exception("Incorrect number of antennas in Holography Array")

thOM = array.getTowerHolography7mObservingMode()
schedBlk =  getSB()

towerObservation = \
          TowerHolography7mTarget(schedBlk.HolographyParameters[0], thOM)

try:
   towerObservation.initializeHardware()
   towerObservation.execute()
   executionStatus = Control.SUCCESS
except Exception as ex:
   logger = getLogger()
   logger.logError('Terminating due to exception: %s' % ex)
   raise
finally:
   towerObservation.shutdownHardware()
   array.endExecution(executionStatus, 'holography test end')

