/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.LabelFigure;
import diva.canvas.toolbox.LabelWrapper;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class LabeledImageFigure
extends LabelWrapper
implements CanvasFigure {
    private Object _clientData;
    private CanvasFigureListenerManager _listenerManager = new CanvasFigureListenerManager(this);
    private List<CanvasFigure> _slaves;
    private boolean _persistent;

    public LabeledImageFigure(Figure fig, String label, int anchor, Paint color, Font font, Interactor interactor) {
        super(fig, label);
        this.setAnchor(anchor);
        LabelFigure labelFig = this.getLabel();
        labelFig.setFillPaint(color);
        labelFig.setFont(font);
        labelFig.setAnchor(7);
        if (interactor != null) {
            this.setInteractor(interactor);
        }
    }

    @Override
    public void setClientData(Object o) {
        this._clientData = o;
    }

    @Override
    public Object getClientData() {
        return this._clientData;
    }

    @Override
    public Rectangle2D getBoundsWithoutLabel() {
        return this.getChild().getBounds();
    }

    @Override
    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        Interactor interactor = this.getInteractor();
        if (interactor instanceof SelectionInteractor) {
            SelectionModel model = ((SelectionInteractor)interactor).getSelectionModel();
            model.removeSelection((Object)this);
        }
        this.repaint();
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    @Override
    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.addCanvasFigureListener(listener);
    }

    @Override
    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.removeCanvasFigureListener(listener);
    }

    @Override
    public void fireCanvasFigureEvent(int eventType) {
        this._listenerManager.fireCanvasFigureEvent(eventType);
    }

    @Override
    public void addSlave(CanvasFigure fig) {
        if (this._slaves == null) {
            this._slaves = new LinkedList<CanvasFigure>();
        }
        this._slaves.add(fig);
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        if (this._slaves != null) {
            ListIterator<CanvasFigure> it = this._slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = it.next();
                fig.translate(x, y);
            }
        }
    }
}

