/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.mapping.MappingSource;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.net.util.URIUtils;
import org.exolab.castor.util.DTDResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Mapping {
    private static final Log LOG = LogFactory.getLog(Mapping.class);
    private static final String DEFAULT_SOURCE_TYPE = "CastorXmlMapping";
    private final List<MappingSource> _mappings = new ArrayList<MappingSource>();
    private final Set<Object> _processed = new HashSet<Object>();
    private final MappingRoot _root = new MappingRoot();
    private final ClassLoader _classLoader;
    private DTDResolver _resolver = new DTDResolver();

    public Mapping(ClassLoader loader) {
        this._classLoader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    public Mapping() {
        this(null);
    }

    public List<MappingSource> getMappingSources() throws MappingException {
        return Collections.unmodifiableList(this._mappings);
    }

    public void markAsProcessed(Object id) {
        this._processed.add(id);
    }

    public boolean processed(Object id) {
        return this._processed.contains(id);
    }

    public MappingRoot getRoot() {
        return this._root;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._resolver = new DTDResolver(resolver);
    }

    public void setBaseURL(String url) {
        String location = url;
        if (location != null) {
            int extIdx;
            int idx = location.lastIndexOf(47);
            if (idx < 0) {
                idx = location.lastIndexOf(92);
            }
            if (idx >= 0 && (extIdx = location.indexOf(46, idx)) > 0) {
                location = location.substring(0, idx);
            }
        }
        try {
            this._resolver.setBaseURL(new URL(location));
        }
        catch (MalformedURLException except) {
            try {
                LOG.info((Object)Messages.format("mapping.wrongURL", location));
                this._resolver.setBaseURL(new URL("file", null, location));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void loadMapping(String url) throws IOException, MappingException {
        this.loadMapping(url, DEFAULT_SOURCE_TYPE);
    }

    public void loadMapping(String url, String type) throws IOException, MappingException {
        String location = url;
        if (this._resolver.getBaseURL() == null) {
            this.setBaseURL(location);
            location = URIUtils.getRelativeURI(location);
        }
        try {
            InputSource source = this._resolver.resolveEntity(null, location);
            if (source == null) {
                source = new InputSource(location);
            }
            if (source.getSystemId() == null) {
                source.setSystemId(location);
            }
            LOG.info((Object)Messages.format("mapping.loadingFrom", location));
            this.loadMapping(source, type);
        }
        catch (SAXException ex) {
            throw new MappingException(ex);
        }
    }

    public void loadMapping(URL url) throws IOException, MappingException {
        this.loadMapping(url, DEFAULT_SOURCE_TYPE);
    }

    public void loadMapping(URL url, String type) throws IOException, MappingException {
        try {
            InputSource source;
            if (this._resolver.getBaseURL() == null) {
                this._resolver.setBaseURL(url);
            }
            if ((source = this._resolver.resolveEntity(null, url.toExternalForm())) == null) {
                source = new InputSource(url.toExternalForm());
                source.setByteStream(url.openStream());
            } else {
                source.setSystemId(url.toExternalForm());
            }
            LOG.info((Object)Messages.format("mapping.loadingFrom", url.toExternalForm()));
            this.loadMapping(source, type);
        }
        catch (SAXException ex) {
            throw new MappingException(ex);
        }
    }

    public void loadMapping(InputSource source) {
        this.loadMapping(source, DEFAULT_SOURCE_TYPE);
    }

    public void loadMapping(InputSource source, String type) {
        this._mappings.add(new MappingSource(source, type, this._resolver));
    }
}

