/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import gnu.jel.DVMap;
import java.awt.Color;
import java.awt.Shape;
import java.util.Vector;
import jsky.catalog.RowCoordinates;
import jsky.catalog.TableQueryResult;
import jsky.util.JavaExpr;
import jsky.util.StringUtil;
import jsky.util.TclUtil;

public class TablePlotSymbol
extends DVMap {
    public static final int CIRCLE = 0;
    public static final int SQUARE = 1;
    public static final int PLUS = 2;
    public static final int CROSS = 3;
    public static final int TRIANGLE = 4;
    public static final int DIAMOND = 5;
    public static final int ELLIPSE = 6;
    public static final int COMPASS = 7;
    public static final int LINE = 8;
    public static final int ARROW = 9;
    public static final String[] SYMBOLS = new String[]{"circle", "square", "plus", "cross", "triangle", "diamond", "ellipse", "compass", "line", "arrow"};
    public static final String[] COLOR_NAMES = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    public static final Color[] COLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    public static final int DEFAULT_RA_COL = 1;
    public static final int DEFAULT_DEC_COL = 2;
    public static final double DEFAULT_EQUINOX = 2000.0;
    private String _name;
    private String _description;
    private TableQueryResult _table;
    private int _raCol = 1;
    private int _decCol = 2;
    private double _equinox = 2000.0;
    private String[] _colNames;
    private int[] _colIndexes;
    private Vector _rowVec;
    private int _shape = 1;
    private String _shapeName = SYMBOLS[1];
    private boolean _hasArea;
    private Color _fg = Color.white;
    private Color _bg = Color.black;
    private String _ratio = "1";
    private JavaExpr _ratioExpr;
    private String _angle = "0";
    private JavaExpr _angleExpr;
    private String _label = "";
    private JavaExpr _labelExpr;
    private String _cond = "1";
    private JavaExpr _condExpr;
    private String _size = "4";
    private JavaExpr _sizeExpr;
    private double _sizeVal = 4.0;
    private String _units = "image";
    private RowCoordinates _rowCoordinates;

    public TablePlotSymbol() {
    }

    public TablePlotSymbol(TableQueryResult table, String cols, String symbol, String expr) {
        this.setTable(table);
        this.setColNames(TclUtil.splitList((String)cols));
        this._parseSymbol(TclUtil.splitList((String)symbol));
        String[] exprList = TclUtil.splitList((String)expr);
        if (exprList.length == 0) {
            throw new RuntimeException("invalid symbol expression: " + expr);
        }
        this.setSize(exprList[0]);
        if (exprList.length > 1) {
            this.setUnits(exprList[1]);
        }
    }

    public TablePlotSymbol(TableQueryResult table, String[] colNames, String shapeName, String fg, String bg, String ratio, String angle, String label, String cond, String size, String units) {
        this.setTable(table);
        this.setColNames(colNames);
        this.setShapeName(shapeName);
        this.setFg(fg);
        this.setBg(bg);
        this.setRatio(ratio);
        this.setAngle(angle);
        this.setLabel(label);
        this.setCond(cond);
        this.setSize(size);
        this.setUnits(units);
    }

    public static TablePlotSymbol[] parsePlotSymbolInfo(String symbolInfo) {
        String[] ar;
        if (symbolInfo == null) {
            ar = new String[]{"", "square yellow", "4"};
        } else {
            ar = TclUtil.splitList((String)(symbolInfo = StringUtil.replace((String)symbolInfo, (String)":", (String)" : ")));
            if (ar.length < 3) {
                throw new RuntimeException("Bad plot symbol entry: " + symbolInfo);
            }
        }
        TablePlotSymbol[] symbols = new TablePlotSymbol[(ar.length + 1) / 4];
        int n = 0;
        for (int i = 0; i < ar.length; i += 4) {
            if (ar.length > i + 3 && !ar[i + 3].equals(":") || ar.length < i + 3) {
                throw new RuntimeException("Bad plot symbol entry: " + symbolInfo);
            }
            symbols[n++] = new TablePlotSymbol(null, ar[i], ar[i + 1], ar[i + 2]);
        }
        return symbols;
    }

    public static String getPlotSymbolInfo(TablePlotSymbol[] symbols) {
        if (symbols == null || symbols.length == 0) {
            return null;
        }
        StringBuffer symbolStr = new StringBuffer();
        for (int i = 0; i < symbols.length; ++i) {
            String[] ar = new String[3];
            ar[0] = symbols[i].getColNamesList();
            String[] shapeInfo = new String[]{symbols[i].getShapeName(), symbols[i].getColorName(symbols[i].getFg()), symbols[i].getRatio(), symbols[i].getAngle(), symbols[i].getLabel(), symbols[i].getCond()};
            ar[1] = TclUtil.makeList((String[])shapeInfo);
            String[] sizeInfo = new String[]{symbols[i].getSize(), symbols[i].getUnits()};
            ar[2] = TclUtil.makeList((String[])sizeInfo);
            symbolStr.append(TclUtil.makeList((String[])ar));
            if (i >= symbols.length - 1) continue;
            symbolStr.append(" : ");
        }
        return symbolStr.toString();
    }

    private void _parseSymbol(String[] symb) {
        if (symb.length < 1) {
            throw new RuntimeException("Bad plot symbol entry");
        }
        this.setShapeName(symb[0]);
        if (symb.length >= 2 && symb[1].length() > 0) {
            this.setFg(symb[1]);
            this.setBg(symb[1]);
        }
        if (symb.length >= 3 && symb[2].length() > 0) {
            this.setRatio(symb[2]);
        }
        if (symb.length >= 4 && symb[3].length() > 0) {
            this.setAngle(symb[3]);
        }
        if (symb.length >= 5 && symb[4].length() > 0) {
            this.setLabel(symb[4]);
        }
        if (symb.length >= 6 && symb[5].length() > 0) {
            this.setCond(symb[5]);
        }
    }

    private void _calculateColumnIndexes() {
        if (this._colNames != null && this._table != null) {
            this._colIndexes = new int[this._colNames.length];
            for (int i = 0; i < this._colNames.length; ++i) {
                this._colIndexes[i] = this._table.getColumnIndex(this._colNames[i]);
            }
        }
    }

    public RowCoordinates getRowCoordinates() {
        if (this._rowCoordinates != null) {
            return this._rowCoordinates;
        }
        this._rowCoordinates = new RowCoordinates(this._raCol, this._decCol, this._equinox);
        return this._rowCoordinates;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    private int _getSymbolIndex(String shapeName) {
        for (int i = 0; i < SYMBOLS.length; ++i) {
            if (!shapeName.equals(SYMBOLS[i])) continue;
            return i;
        }
        return 0;
    }

    private boolean _checkHasArea(int s) {
        return s == 0 || s == 1 || s == 4 || s == 5 || s == 6;
    }

    private Color _getColor(String name) {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!name.equals(COLOR_NAMES[i])) continue;
            return COLORS[i];
        }
        return Color.yellow;
    }

    public String getColorName(Color c) {
        for (int i = 0; i < COLORS.length; ++i) {
            if (!c.equals(COLORS[i])) continue;
            return COLOR_NAMES[i];
        }
        return "yellow";
    }

    public void setTable(TableQueryResult table) {
        this._table = table;
        if (this._table != null) {
            this._calculateColumnIndexes();
            this._compileExpressions();
        }
    }

    public TableQueryResult getTable() {
        return this._table;
    }

    public int getRaCol() {
        return this._raCol;
    }

    public void setRaCol(int raCol) {
        this._raCol = raCol;
        this._rowCoordinates = null;
    }

    public int getDecCol() {
        return this._decCol;
    }

    public void setDecCol(int decCol) {
        this._decCol = decCol;
        this._rowCoordinates = null;
    }

    public double getEquinox() {
        return this._equinox;
    }

    public void setEquinox(double equinox) {
        this._equinox = equinox;
        this._rowCoordinates = null;
    }

    public void setColNames(String[] colNames) {
        this._colNames = colNames;
        this._calculateColumnIndexes();
    }

    public String[] getColNames() {
        return this._colNames;
    }

    public int[] getColIndexes() {
        return this._colIndexes;
    }

    public String getColNamesList() {
        return TclUtil.makeList((String[])this._colNames);
    }

    public void setShape(int shape) {
        this._shape = shape;
        this._hasArea = this._checkHasArea(this._shape);
        this._shapeName = SYMBOLS[shape];
    }

    public int getShape() {
        return this._shape;
    }

    public void setShapeName(String shapeName) {
        this._shapeName = shapeName;
        this._shape = this._getSymbolIndex(shapeName);
        this._hasArea = this._checkHasArea(this._shape);
    }

    public String getShapeName() {
        return this._shapeName;
    }

    public Shape getBoundingShape(Shape shape) {
        if (this._hasArea) {
            return shape;
        }
        return shape.getBounds2D();
    }

    public void setFg(String colorName) {
        this._fg = this._getColor(colorName);
    }

    public void setFg(Color color) {
        this._fg = color;
    }

    public Color getFg() {
        return this._fg;
    }

    public void setBg(String colorName) {
        this._bg = this._getColor(colorName);
    }

    public void setBg(Color color) {
        this._bg = color;
    }

    public Color getBg() {
        return this._bg;
    }

    public void setRatio(String ratio) {
        this._ratio = ratio;
    }

    public String getRatio() {
        return this._ratio;
    }

    public double getRatio(Vector rowVec) {
        if (this._ratioExpr != null) {
            this._rowVec = rowVec;
            try {
                return this._ratioExpr.eval();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 1.0;
    }

    public void setAngle(String angle) {
        this._angle = angle;
    }

    public String getAngle() {
        return this._angle;
    }

    public double getAngle(Vector rowVec) {
        if (this._angleExpr != null) {
            this._rowVec = rowVec;
            try {
                return this._angleExpr.eval();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label;
    }

    public String getLabel(Vector rowVec) {
        if (this._labelExpr != null) {
            this._rowVec = rowVec;
            try {
                return this._labelExpr.evalObject().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCond(String cond) {
        this._cond = cond;
    }

    public String getCond() {
        return this._cond;
    }

    public boolean getCond(Vector rowVec) {
        if (this._condExpr != null) {
            this._rowVec = rowVec;
            try {
                return this._condExpr.evalBoolean();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return true;
    }

    public void setSize(String size) {
        this._size = size;
    }

    public String getSize() {
        return this._size;
    }

    public double getSize(Vector rowVec) {
        if (this._sizeExpr != null) {
            this._rowVec = rowVec;
            try {
                return this._sizeExpr.eval();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this._sizeVal;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    public String getUnits() {
        return this._units;
    }

    public String getTypeName(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this._colNames.length; ++i) {
            if (!this._colNames[i].equals(name)) continue;
            Class<?> c = this._table.getColumnClass(this._colIndexes[i]);
            String className = c.getName();
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return "Object";
    }

    public double getFloatProperty(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this._colNames.length; ++i) {
            Object value;
            if (!this._colNames[i].equals(name) || !((value = this._rowVec.get(this._colIndexes[i])) instanceof Float)) continue;
            return ((Float)value).floatValue();
        }
        return 0.0;
    }

    public double getDoubleProperty(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this._colNames.length; ++i) {
            Object value;
            if (!this._colNames[i].equals(name) || !((value = this._rowVec.get(this._colIndexes[i])) instanceof Double)) continue;
            return (Double)value;
        }
        return 0.0;
    }

    public String getStringProperty(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this._colNames.length; ++i) {
            String value;
            if (!this._colNames[i].equals(name) || (value = (String)this._rowVec.get(this._colIndexes[i])) == null) continue;
            return value;
        }
        return null;
    }

    public Object getObjectProperty(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this._colNames.length; ++i) {
            if (!this._colNames[i].equals(name)) continue;
            return this._rowVec.get(this._colIndexes[i]);
        }
        return null;
    }

    private void _compileExpressions() {
        try {
            this._sizeVal = Double.parseDouble(this._size);
        }
        catch (Exception e) {
            try {
                this._sizeExpr = new JavaExpr("(double)" + this._size, this);
            }
            catch (Throwable t) {
                this._sizeVal = 5.0;
                this._units = "image";
            }
        }
        if (this._cond.length() != 0 && !this._cond.equals("1")) {
            try {
                this._condExpr = new JavaExpr(this._cond, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._angle.length() != 0 && !this._angle.equals("0")) {
            try {
                this._angleExpr = new JavaExpr("(double)" + this._angle, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._ratio.length() != 0 && !this._ratio.equals("1")) {
            try {
                this._ratioExpr = new JavaExpr("(double)" + this._ratio, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._label.length() != 0) {
            try {
                this._labelExpr = new JavaExpr(this._label, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

