/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

class StarResultSet {
    private final ResultSet rset_;
    private final ColumnInfo[] colInfos_;
    private final boolean isRandom_;
    private long nrow_ = -1L;
    private static final Logger logger_;
    private static final ValueInfo LABEL_INFO;
    private static final List AUX_DATA_INFOS;
    static /* synthetic */ Class class$java$lang$Object;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StarResultSet(ResultSet rset) throws SQLException {
        this.rset_ = rset;
        ResultSetMetaData meta = rset.getMetaData();
        int ncol = meta.getColumnCount();
        this.colInfos_ = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            int jcol = icol + 1;
            String name = meta.getColumnName(jcol);
            this.colInfos_[icol] = new ColumnInfo(name);
            ColumnInfo col = this.colInfos_[icol];
            String className = meta.getColumnClassName(jcol);
            try {
                this.getClass();
                Class<?> clazz = Class.forName(className);
                col.setContentClass(clazz);
            }
            catch (ClassNotFoundException e) {
                logger_.warning("Cannot determine class " + className + " for column " + name);
                col.setContentClass(class$java$lang$Object == null ? StarResultSet.class$("java.lang.Object") : class$java$lang$Object);
            }
            if (meta.isNullable(jcol) == 0) {
                col.setNullable(false);
            }
            List auxdata = col.getAuxData();
            String label = meta.getColumnLabel(jcol);
            if (label == null || label.trim().length() <= 0 || label.equalsIgnoreCase(name)) continue;
            auxdata.add(new DescribedValue(LABEL_INFO, label.trim()));
        }
        switch (this.rset_.getType()) {
            case 1003: {
                this.isRandom_ = false;
                break;
            }
            case 1004: 
            case 1005: {
                this.isRandom_ = true;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown ResultSet type");
                }
                this.isRandom_ = false;
            }
        }
    }

    public ResultSet getResultSet() {
        return this.rset_;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.colInfos_;
    }

    public boolean isRandom() {
        return this.isRandom_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCount() {
        if (this.isRandom_) {
            if (this.nrow_ < 0L) {
                try {
                    StarResultSet starResultSet = this;
                    synchronized (starResultSet) {
                        this.rset_.afterLast();
                        this.rset_.previous();
                        this.nrow_ = this.rset_.getRow();
                    }
                }
                catch (SQLException e) {
                    logger_.warning("Failed to get table length: " + e);
                    this.nrow_ = 0L;
                }
            }
            return this.nrow_;
        }
        return -1L;
    }

    public static List getColumnAuxDataInfos() {
        return AUX_DATA_INFOS;
    }

    public void setRowIndex(long lrow) throws IOException {
        if (this.isRandom_) {
            try {
                this.rset_.absolute(Tables.checkedLongToInt(lrow) + 1);
            }
            catch (SQLException e) {
                throw (IOException)new IOException("Error setting to row " + lrow).initCause(e);
            }
        } else {
            throw new UnsupportedOperationException("No random access");
        }
    }

    public Object getCell(int icol) throws IOException {
        Object base;
        try {
            base = this.rset_.getObject(icol + 1);
        }
        catch (SQLException e) {
            throw (IOException)new IOException("SQL read error" + e).initCause(e);
        }
        Class colclass = this.colInfos_[icol].getContentClass();
        if (base instanceof byte[] && !colclass.equals([B.class)) {
            return new String((byte[])base);
        }
        if (base instanceof char[] && !colclass.equals([C.class)) {
            return new String((char[])base);
        }
        return base;
    }

    public Object[] getRow() throws IOException {
        int ncol = this.colInfos_.length;
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.getCell(icol);
        }
        return row;
    }

    public RowSequence createRowSequence() throws IOException {
        return new ResultSetRowSequence();
    }

    static {
        $assertionsDisabled = !StarResultSet.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");
        LABEL_INFO = new DefaultValueInfo("Label", String.class);
        AUX_DATA_INFOS = Collections.unmodifiableList(Arrays.asList(LABEL_INFO));
    }

    private class ResultSetRowSequence
    implements RowSequence {
        private ResultSetRowSequence() {
        }

        public boolean next() throws IOException {
            try {
                return StarResultSet.this.rset_.next();
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        public Object getCell(int icol) throws IOException {
            this.checkHasCurrentRow();
            return StarResultSet.this.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            this.checkHasCurrentRow();
            return StarResultSet.this.getRow();
        }

        public void close() throws IOException {
            try {
                StarResultSet.this.rset_.close();
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        private void checkHasCurrentRow() {
            try {
                if (StarResultSet.this.rset_.isBeforeFirst()) {
                    throw new NoSuchElementException("No current row");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

