/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.util.XMLEncodeDecode;

public abstract class PrimitiveXMLEncodeDecode
implements XMLEncodeDecode {
    protected EventListenerList listeners = new EventListenerList();

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void fireChanged() {
        Object[] la = this.listeners.getListenerList();
        ChangeEvent e = null;
        for (int i = la.length - 2; i >= 0; i -= 2) {
            if (la[i] != (class$javax$swing$event$ChangeListener == null ? PrimitiveXMLEncodeDecode.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)la[i + 1]).stateChanged(e);
        }
    }

    public abstract void encode(Element var1);

    public void decode(Element rootElement) {
        List children = PrimitiveXMLEncodeDecode.getChildElements(rootElement);
        int size = children.size();
        Element element = null;
        String name = null;
        String value = null;
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            name = PrimitiveXMLEncodeDecode.getElementName(element);
            value = PrimitiveXMLEncodeDecode.getElementValue(element);
            this.setFromString(name, value);
        }
    }

    public static List getChildElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> elementList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            elementList.add(nodeList.item(i));
        }
        return elementList;
    }

    public abstract void setFromString(String var1, String var2);

    public static Element addChildElement(Element rootElement, String name) {
        Document parent = rootElement.getOwnerDocument();
        Element element = parent.createElement(name);
        rootElement.appendChild(element);
        return element;
    }

    public static CDATASection addCDATASection(Element rootElement, String value) {
        Document parent = rootElement.getOwnerDocument();
        CDATASection cdata = parent.createCDATASection(value);
        rootElement.appendChild(cdata);
        return cdata;
    }

    public static Element addChildElement(Element rootElement, String name, String value) {
        Element newElement = PrimitiveXMLEncodeDecode.addChildElement(rootElement, name);
        if (value != null) {
            PrimitiveXMLEncodeDecode.addCDATASection(newElement, value);
        }
        return newElement;
    }

    public static Element addChildElement(Element rootElement, String name, boolean value) {
        return PrimitiveXMLEncodeDecode.addChildElement(rootElement, name, PrimitiveXMLEncodeDecode.booleanToString(value));
    }

    public static Element addChildElement(Element rootElement, String name, int value) {
        return PrimitiveXMLEncodeDecode.addChildElement(rootElement, name, PrimitiveXMLEncodeDecode.intToString(value));
    }

    public static Element addChildElement(Element rootElement, String name, double value) {
        return PrimitiveXMLEncodeDecode.addChildElement(rootElement, name, PrimitiveXMLEncodeDecode.doubleToString(value));
    }

    public static NodeList getChildren(Element rootElement) {
        return rootElement.getChildNodes();
    }

    public static String getElementName(Element element) {
        return element.getTagName();
    }

    public static String getElementValue(Element element) {
        Node firstChild = element.getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return null;
    }

    public static String doubleToString(double value) {
        return new Double(value).toString();
    }

    public static double doubleFromString(String value) {
        return Double.parseDouble(value);
    }

    public static String booleanToString(boolean value) {
        return new Boolean(value).toString();
    }

    public static boolean booleanFromString(String value) {
        return new Boolean(value);
    }

    public static String intToString(int value) {
        return new Integer(value).toString();
    }

    public static int intFromString(String value) {
        return Integer.parseInt(value);
    }

    public static String longToString(long value) {
        return new Long(value).toString();
    }

    public static long longFromString(String value) {
        return Long.parseLong(value);
    }
}

