/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.config.validators;

import alma.acs.config.validators.ConfigFileRedeemer;
import alma.acs.config.validators.XmlNamespaceContextContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigFileRedeemerXml
extends ConfigFileRedeemer {
    protected List<XPathMatchSetup> xpathMatchSetupList = new ArrayList<XPathMatchSetup>();
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";

    public ConfigFileRedeemerXml(Logger logger) throws Exception {
        super(logger);
        this.configure();
    }

    protected void configure() {
        this.addXPathMatch(new XPathMatchSetup("/EntitybuilderSettings/EntitySchema", null, null, XPathConstants.NODESET));
        this.addXPathMatch(new XPathMatchSetup("/Type/@type", null, null, XPathConstants.NUMBER));
        this.addXPathMatch(new XPathMatchSetup("/bla:Type/@type", "bla", "Alma/ACSError", XPathConstants.NUMBER));
        this.addXPathMatch(new XPathMatchSetup("/XMI/@xmi.version", null, null, XPathConstants.NUMBER));
        this.addXPathMatch(new XPathMatchSetup("/oprp:ObsProposal", "oprp", "Alma/ObsPrep/ObsProposal", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/oprj:ObsProject", "oprj", "Alma/ObsPrep/ObsProject", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/sbl:SchedBlock", "sbl", "Alma/ObsPrep/SchedBlock", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ObsPrep/ObsProposal']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ObsPrep/ObsProject']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ObsPrep/ObsReview']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ObsPrep/SchedBlock']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ObsPrep/ProjectStatus']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema[@targetNamespace='Alma/ValueTypes']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/MetaMap", null, null, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/MetaModel", null, null, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/bla:AcsCommandCenterProject", "bla", "Alma/Acs/AcsCommandCenterProject", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/bla:AcsCommandCenterTools", "bla", "Alma/Acs/AcsCommandCenterTools", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/bla:cosydoc", "bla", "urn:schemas-cosylab-com:Document", XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:simpleType[@name='ErrorType']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='AcsCommandCenterProject']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='AcsCommandCenterTools']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:complexType[@name='EventChannel']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='SimulatedComponent']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:complexType[@name='EntityT']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='IdentifierRange']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='ComponentHelperInfo']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='EntitybuilderSettings']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:complexType[@name='ComponentInfo']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:complexType[@name='Container']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:complexType[@name='Manager']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='Log']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='paramset']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/xsd:schema/xsd:element[@name='pset']", "xsd", XSD_NS, XPathConstants.NODE));
        this.addXPathMatch(new XPathMatchSetup("/project/@basedir", null, null, XPathConstants.STRING));
        this.addXPathMatch(new XPathMatchSetup("/project/target/javadoc", null, null, XPathConstants.NODESET));
    }

    @Override
    public String[] getFileEndings() {
        return new String[]{".xml", ".xsd", ".xslt"};
    }

    @Override
    public boolean _isNotAConfigFile(File xmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element rootElement = builder.parse(xmlFile).getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            for (XPathMatchSetup xpathSetup : this.xpathMatchSetupList) {
                XmlNamespaceContextContainer nsContext = new XmlNamespaceContextContainer();
                nsContext.addNamespace(xpathSetup.getPrefix(), xpathSetup.getNamespace());
                xpath.setNamespaceContext(nsContext);
                Object xpathResult = xpath.evaluate(xpathSetup.getExpression(), rootElement, xpathSetup.getReturnType());
                if (xpathResult == null || xpathSetup.getReturnType().equals(XPathConstants.NUMBER) && ((Double)xpathResult).isNaN() || xpathSetup.getReturnType().equals(XPathConstants.NODESET) && ((NodeList)xpathResult).getLength() == 0 || xpathSetup.getReturnType().equals(XPathConstants.STRING) && ((String)xpathResult).trim().length() == 0) continue;
                if (xpathSetup.getReturnType().equals(XPathConstants.NODE)) {
                    // empty if block
                }
                System.out.println("XML file '" + xmlFile + "' is not a config file. The query '" + xpathSetup.getExpression() + "' found a matching " + xpathSetup.getReturnType().getLocalPart());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "xml file '" + xmlFile + "' failed to be parsed and will be treated as suspect.", e);
            return false;
        }
    }

    public void addXPathMatch(XPathMatchSetup xpathMatchSetup) {
        this.xpathMatchSetupList.add(xpathMatchSetup);
    }

    public static class XPathMatchSetup {
        private String expression;
        private String prefix;
        private String namespace;
        private QName returnType;

        public XPathMatchSetup(String expression, String prefix, String namespace, QName returnType) {
            this.expression = expression;
            this.namespace = namespace;
            this.prefix = prefix;
            this.returnType = returnType;
        }

        String getExpression() {
            return this.expression;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getNamespace() {
            return this.namespace;
        }

        QName getReturnType() {
            return this.returnType;
        }
    }
}

