/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import alma.acs.monitoring.RemoteThreadsMBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.openmbean.CompositeData;
import sun.management.ThreadInfoCompositeData;

public class RemoteThreads
implements RemoteThreadsMBean {
    public static String[] JACORB_CLASSES = new String[]{"org.jacorb.", "org.omg."};
    public static String[] ACS_CLASSES = new String[]{"alma."};
    protected ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();

    @Override
    public CompositeData[] getAllThreadsInfo() {
        ThreadInfo[] info = this.tmxb.dumpAllThreads(true, true);
        CompositeData[] data = new CompositeData[info.length];
        for (int i = 0; i != info.length; ++i) {
            data[i] = ThreadInfoCompositeData.toCompositeData(info[i]);
        }
        return data;
    }

    @Override
    public int getJacORBThreadsCount() {
        return this.getThreadsCount(JACORB_CLASSES, null);
    }

    @Override
    public CompositeData[] getJacORBThreadsInfo() {
        return this.getJacORBThreadsInfo(null);
    }

    @Override
    public CompositeData[] getJacORBThreadsInfo(Thread.State state) {
        return this.getThreadsInfo(JACORB_CLASSES, state);
    }

    @Override
    public int getAcsContainerThreadsCount() {
        return this.getThreadsCount(ACS_CLASSES, null);
    }

    @Override
    public CompositeData[] getAcsContainerThreadsInfo() {
        return this.getAcsContainerThreadsInfo(null);
    }

    @Override
    public CompositeData[] getAcsContainerThreadsInfo(Thread.State state) {
        return this.getThreadsInfo(ACS_CLASSES, state);
    }

    @Override
    public int getAllThreadsCount() {
        return this.tmxb.dumpAllThreads(true, true).length;
    }

    @Override
    public CompositeData[] getThreadsInfo(String className, Thread.State state) {
        return this.getThreadsInfo(new String[]{className}, state);
    }

    @Override
    public int getThreadsCount(String className, Thread.State state) {
        return this.getThreadsCount(new String[]{className}, state);
    }

    protected CompositeData[] getThreadsInfo(String[] classes, Thread.State state) {
        ThreadInfo[] info = this.tmxb.dumpAllThreads(true, true);
        CompositeData[] dataList = new CompositeData[info.length];
        int includedData = 0;
        block0: for (int i = 0; i != info.length; ++i) {
            StackTraceElement[] stackElements = info[i].getStackTrace();
            int idx = stackElements.length - 1;
            if (stackElements.length <= 0) continue;
            String cName = stackElements[idx].getClassName();
            if (cName.equals("java.lang.Thread")) {
                cName = stackElements[idx - 1].getClassName();
            }
            for (int j = 0; j != classes.length; ++j) {
                if (!cName.startsWith(classes[j]) || state != null && info[i].getThreadState() != state) continue;
                dataList[includedData++] = ThreadInfoCompositeData.toCompositeData(info[i]);
                continue block0;
            }
        }
        CompositeData[] newDataList = new CompositeData[includedData];
        System.arraycopy(dataList, 0, newDataList, 0, includedData);
        return newDataList;
    }

    protected int getThreadsCount(String[] classes, Thread.State state) {
        ThreadInfo[] info = this.tmxb.dumpAllThreads(true, true);
        int threadCount = 0;
        block0: for (int i = 0; i != info.length; ++i) {
            StackTraceElement[] stackElements = info[i].getStackTrace();
            int idx = stackElements.length - 1;
            if (stackElements.length <= 0) continue;
            String cName = stackElements[idx].getClassName();
            if (cName.equals("java.lang.Thread") && stackElements.length >= 2) {
                cName = stackElements[idx - 1].getClassName();
            }
            for (int j = 0; j != classes.length; ++j) {
                if (!cName.startsWith(classes[j]) || state != null && info[i].getThreadState() != state) continue;
                ++threadCount;
                continue block0;
            }
        }
        return threadCount;
    }
}

