/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

public class XmlNormalizer {
    private static String normalize(String s, boolean normalizeXMLEmbeddedTextOnly) {
        if (s == null) {
            return s;
        }
        StringBuffer str = null;
        int begin = 0;
        boolean currentlyInsideText = false;
        boolean currentlyInsideCharacterContent = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String trans = null;
            if (normalizeXMLEmbeddedTextOnly && !currentlyInsideText) {
                if (ch == '<') {
                    currentlyInsideCharacterContent = false;
                    continue;
                }
                if (ch == '>') {
                    currentlyInsideCharacterContent = true;
                    continue;
                }
            }
            if (ch == '\"') {
                boolean bl = currentlyInsideText = !currentlyInsideText;
                if (!normalizeXMLEmbeddedTextOnly) {
                    trans = XmlNormalizer.translate(ch);
                }
            } else if (!normalizeXMLEmbeddedTextOnly || currentlyInsideText || currentlyInsideCharacterContent) {
                trans = XmlNormalizer.translate(ch);
            }
            if (trans == null) continue;
            if (str == null) {
                str = new StringBuffer(s.length() + 16);
            }
            str.append(s.substring(begin, i)).append(trans);
            begin = i + 1;
        }
        if (str != null) {
            str.append(s.substring(begin));
            return str.toString();
        }
        return s;
    }

    public static String normalize(String s) {
        return XmlNormalizer.normalize(s, false);
    }

    public static String normalizeXMLEmbeddedTextOnly(String xmlString) {
        return XmlNormalizer.normalize(xmlString, true);
    }

    public static String translate(char ch) {
        switch (ch) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return null;
    }
}

