/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import alma.tools.idlgen.AcsXmlNamingExpert;
import alma.tools.idlgen.XmlIdlCompiler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.jacorb.idl.AcsHolderPrinter;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.Interface;
import org.jacorb.idl.Member;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class AcsStructPrinter {
    private final StructType struct;
    private final AcsXmlNamingExpert namingExpert;
    private final Set<AliasTypeSpec> xmlTypedefs;
    private final Set<StructType> xmlAwareStructs;
    private final Set<Interface> xmlAwareIFs;

    public AcsStructPrinter(StructType structType, Set<AliasTypeSpec> set, Set<StructType> set2, Set<Interface> set3, AcsXmlNamingExpert acsXmlNamingExpert) {
        this.struct = structType;
        this.namingExpert = acsXmlNamingExpert;
        this.xmlTypedefs = set;
        this.xmlAwareStructs = set2;
        this.xmlAwareIFs = set3;
    }

    public static String java_name(StructType structType) {
        return structType.javaName();
    }

    public void printStructClass() throws IOException {
        String string = this.struct.full_name();
        String string2 = this.namingExpert.getClassNameForStruct(this.struct);
        String string3 = this.struct.full_name();
        String string4 = string3.substring(0, string3.lastIndexOf(46));
        File file = XmlIdlCompiler.createFile(string4, string2);
        if (!GlobalInputStream.isMoreRecentThan((File)file)) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        if (!string4.equals("")) {
            printWriter.println("package " + string4 + ";");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Class for IDL struct " + string);
        printWriter.println(" * ");
        printWriter.println(" * @author ACS xml transparency layer generator");
        printWriter.println(" */");
        printWriter.println("public" + parser.getFinalString() + " class " + string2);
        printWriter.println("{");
        if (this.struct.memberlist != null) {
            class StructMember {
                String typeName;
                String memberName;

                public StructMember(String string, String string2) {
                    this.typeName = string;
                    this.memberName = string2;
                }
            }
            ArrayList<StructMember> arrayList = new ArrayList<StructMember>();
            Iterator iterator = this.struct.memberlist.v.elements();
            while (iterator.hasMoreElements()) {
                Member object2 = (Member)iterator.nextElement();
                TypeSpec typeSpec = object2.type_spec;
                String string5 = this.namingExpert.getAcsTypeName(typeSpec, this.xmlTypedefs, this.xmlAwareStructs, this.xmlAwareIFs);
                arrayList.add(new StructMember(string5, object2.declarator.name()));
            }
            for (StructMember structMember : arrayList) {
                printWriter.print("\tpublic " + structMember.typeName + " " + structMember.memberName + ";");
                printWriter.println();
            }
            printWriter.println();
            printWriter.println("\tpublic " + string2 + "() {}");
            printWriter.print("\tpublic " + string2 + "(");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                StructMember structMember = (StructMember)iterator.next();
                printWriter.print(structMember.typeName + " " + structMember.memberName);
                if (!iterator.hasNext()) continue;
                printWriter.print(", ");
            }
            printWriter.println(")");
            printWriter.println("\t{");
            for (StructMember structMember : arrayList) {
                printWriter.print("\t\tthis.");
                printWriter.print(structMember.memberName);
                printWriter.print(" = ");
                printWriter.println(structMember.memberName + ";");
            }
            printWriter.println("\t}");
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void printHolderClass() throws IOException {
        String string = this.struct.full_name();
        String string2 = this.namingExpert.getHolderClassNameForStruct(this.struct);
        String string3 = this.namingExpert.getJavaTypeForXmlStruct(this.struct);
        String string4 = this.struct.full_name();
        String string5 = string4.substring(0, string4.lastIndexOf(46));
        AcsHolderPrinter acsHolderPrinter = new AcsHolderPrinter();
        acsHolderPrinter.printHolderClass("struct", string, string2, string5, string3);
    }
}

