/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.navigator;

import alma.obsprep.guiutil.jsky.image.gui.AlmaImageDisplayStatusPanel;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplay;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.ReadonlyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import jsky.image.gui.ImageDisplayStatusPanel;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.NavigatorImageDisplayControl;

public class AlmaNavigatorImageDisplayControl
extends NavigatorImageDisplayControl {
    private static final long serialVersionUID = -7804799280523552319L;
    private JTextField filenameField;
    private final boolean compact;

    public AlmaNavigatorImageDisplayControl(int n, boolean bl) {
        super(n);
        this.compact = bl;
        this.panZoomPanel = new JPanel();
        this.imageDisplayStatusPanel = this.makeStatusPanel();
        this.imageDisplayStatusPanel.setImageDisplay((MainImageDisplay)this.imageDisplay);
        ((AlmaNavigatorImageDisplay)this.imageDisplay).addImageFileLoadedListener(changeEvent -> {
            try {
                AlmaNavigatorImageDisplay almaNavigatorImageDisplay = (AlmaNavigatorImageDisplay)((Object)((Object)changeEvent.getSource()));
                this.filenameField.setText(almaNavigatorImageDisplay.getFilename());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        this.panZoomToggleButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.imageDisplay.putClientProperty((Object)"readonly-handler", (Object)new ReadonlyHandler(){

            @Override
            public void handleReadOnly(Component component) {
                ((AlmaNavigatorImageDisplay)((Object)component)).getCanvasPane().setEnabled(false);
            }

            @Override
            public void handleNotReadOnly(Component component) {
                ((AlmaNavigatorImageDisplay)((Object)component)).getCanvasPane().setEnabled(true);
            }
        });
        this.makeLayout(n);
    }

    protected void makeLayout(int n) {
        this.setName("SpatialVisualEditor.ImageDisplayControl");
        this.setLayout(new BorderLayout());
        this.colorbar.setBorder(BorderFactory.createEtchedBorder());
        this.colorbar.setPreferredSize(new Dimension(0, 20));
        this.colorbar.setToolTipText("<html><p>Left click and drag the mouse within this bar to change the image contrast.</p><p>Right click anywhere in this bar to reset the display.</p></html>");
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints((Component)this.imageDisplay, gridBagConstraints);
        this.panZoomPanel.setLayout(new BoxLayout(this.panZoomPanel, 1));
        this.imagePanner.setBorder((Border)new LineBorder(this.getBackground(), 1));
        this.panZoomPanel.add((Component)this.imagePanner);
        this.imageZoom.setBorder((Border)new LineBorder(this.getBackground(), 1));
        this.panZoomPanel.add((Component)this.imageZoom);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.panZoomPanel, gridBagConstraints);
        gridBagLayout.setConstraints(this.panZoomToggleButton, gridBagConstraints);
        jPanel.add(this.panZoomToggleButton);
        jPanel.add(this.panZoomPanel);
        jPanel.add((Component)this.imageDisplay);
        this.add(jPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Image Filename "));
        this.filenameField = new JTextField();
        this.filenameField.setName("SpatialVisualEditor.filenameField");
        this.filenameField.setEditable(false);
        box.add(this.filenameField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.colorbar, "North");
        jPanel2.add((Component)this.imageDisplayStatusPanel, "Center");
        jPanel2.add((Component)box, "South");
        this.add(jPanel2, "South");
    }

    protected AlmaNavigatorImageDisplay makeImageDisplay() {
        return new AlmaNavigatorImageDisplay();
    }

    public AlmaNavigatorImageDisplay getImageDisplay() {
        return (AlmaNavigatorImageDisplay)this.imageDisplay;
    }

    protected ImageDisplayStatusPanel makeStatusPanel() {
        return new AlmaImageDisplayStatusPanel(this.compact);
    }
}

