/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.mvc.Controller;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTBasicTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.guiutil.mvc.widgets.OTFileArea;
import alma.obsprep.guiutil.mvc.widgets.OTJTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class View
extends JPanel
implements ModelStatusSubscriber {
    public static String BO_MAPPING_CLIENT_PROPERTY = "BoMapping";
    public static String UI_MAPPING_CLIENT_PROPERTY = "UIMapping";
    private Integer insetAboveComponent = 0;
    private Integer insetBelowComponent = 0;
    private static final String INVALID = "Invalid!";
    protected static final String TOOLTIP_TEXT = "TOOLTIP_TEXT";
    private Controller controller;
    private Model model;
    protected final Map<Component, Map<String, String>> uiLabelToBOMapping = new HashMap<Component, Map<String, String>>();
    protected int labeledWidgetsCount = 0;
    protected final Map<Object, Object> listeners = new HashMap<Object, Object>();
    protected String title = null;
    private final Map<FieldID, JComponent> widgets = new HashMap<FieldID, JComponent>();
    private static Color enabledBackgroundColour;
    private static Color enabledForegroundColour;
    private static Color disabledBackgroundColour;
    private static Color disabledForegroundColour;
    private GuiApi guiApi;
    private final Set<View> subViews;

    protected View() {
        JTextField jTextField = new JTextField();
        enabledForegroundColour = jTextField.getForeground();
        enabledBackgroundColour = jTextField.getBackground();
        disabledForegroundColour = UIManager.getColor("Label.disabledForeground");
        disabledBackgroundColour = UIManager.getColor("Label.disabledBackground");
        this.guiApi = new GuiApi.Default();
        this.subViews = new HashSet<View>();
    }

    protected View(Model model) {
        this(model, true);
    }

    public View(Model model, boolean bl) {
        this();
        this.build();
        if (model != null) {
            this.setModel(model, true);
        }
        if (bl) {
            for (JComponent jComponent : this.widgets.values()) {
                this.setEnabled(jComponent, false);
            }
        }
    }

    protected void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        if (bl) {
            jComponent.setBackground(enabledBackgroundColour);
            jComponent.setForeground(enabledForegroundColour);
        } else {
            jComponent.setBackground(disabledBackgroundColour);
            jComponent.setForeground(disabledForegroundColour);
        }
    }

    protected void setVisible(JComponent jComponent, boolean bl) {
        jComponent.setVisible(bl);
    }

    protected void addLabeledWidget(Container container, JLabel jLabel, JComponent jComponent) {
        container.add(jLabel);
        container.add(jComponent);
    }

    protected void addLabeledWidget(JLabel jLabel, JComponent jComponent) {
        this.addLabeledWidget(this, jLabel, jComponent);
        ++this.labeledWidgetsCount;
    }

    protected abstract void build();

    protected void layoutLabeledWidgets() {
        this.layoutLabeledWidgets(this, this.labeledWidgetsCount);
    }

    protected void layoutLabeledWidgets(Container container, int n) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        int n2 = -1;
        Component[] componentArray = container.getComponents();
        Insets insets = new Insets(this.insetAboveComponent, this.insetBelowComponent, 0, 0);
        Insets insets2 = new Insets(this.insetAboveComponent, this.insetBelowComponent, 0, 6);
        int n3 = 0;
        while (n3 < n) {
            gridBagConstraints.gridy = n3++;
            JLabel jLabel = (JLabel)componentArray[++n2];
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = insets2;
            jLabel.setHorizontalAlignment(2);
            jLabel.setVerticalAlignment(0);
            gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
            Component component = componentArray[++n2];
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = insets;
            gridBagLayout.addLayoutComponent(component, gridBagConstraints);
        }
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        this.update(fieldID, object);
    }

    public void refresh() {
        this.model.publish();
    }

    public String getUILabelToBOMapping(JComponent jComponent, String string) {
        if (jComponent == null || string == null) {
            return string;
        }
        if (this.uiLabelToBOMapping.containsKey(jComponent)) {
            Map<String, String> map = this.uiLabelToBOMapping.get(jComponent);
            for (String string2 : map.keySet()) {
                if (!map.get(string2).equals(string)) continue;
                return string2;
            }
        }
        return string;
    }

    protected String getBOMappingToUILabel(JComponent jComponent, String string) {
        if (jComponent == null || string == null) {
            return string;
        }
        if (this.uiLabelToBOMapping.containsKey(jComponent)) {
            for (String string2 : this.uiLabelToBOMapping.get(jComponent).keySet()) {
                if (!string2.equals(string)) continue;
                return this.uiLabelToBOMapping.get(jComponent).get(string2);
            }
        }
        return string;
    }

    private void register0(JComponent jComponent, FieldID fieldID) {
        this.widgets.put(fieldID, jComponent);
        if (jComponent.getName() == null) {
            jComponent.setName(fieldID.toString());
        }
    }

    public void register(JButton jButton, FieldID fieldID) {
        this.register0(jButton, fieldID);
    }

    public void register(JRadioButton jRadioButton, FieldID fieldID) {
        this.register0(jRadioButton, fieldID);
    }

    public void register(JCheckBox jCheckBox, FieldID fieldID) {
        this.register0(jCheckBox, fieldID);
    }

    public void register(JComboBox jComboBox, FieldID fieldID) {
        this.register0(jComboBox, fieldID);
    }

    public void register(OTComboBox oTComboBox, FieldID fieldID) {
        this.register0(oTComboBox, fieldID);
    }

    public void register(JLabel jLabel, FieldID fieldID) {
        this.register0(jLabel, fieldID);
    }

    public void register(JList jList, FieldID fieldID) {
        this.register0(jList, fieldID);
    }

    public void register(JSlider jSlider, FieldID fieldID) {
        this.register0(jSlider, fieldID);
    }

    public void register(JSpinner jSpinner, FieldID fieldID) {
        this.register0(jSpinner, fieldID);
    }

    public void register(JTabbedPane jTabbedPane, FieldID fieldID) {
        this.register0(jTabbedPane, fieldID);
    }

    public void register(JTable jTable, FieldID fieldID) {
        this.register0(jTable, fieldID);
    }

    public void register(OTBasicTextArea oTBasicTextArea, FieldID fieldID) {
        this.register0(oTBasicTextArea, fieldID);
        oTBasicTextArea.getJTextArea().putClientProperty("fieldId", fieldID);
        oTBasicTextArea.getJTextArea().putClientProperty("editor", this);
    }

    public void register(OTTextArea oTTextArea, FieldID fieldID) {
        this.register0(oTTextArea, fieldID);
        oTTextArea.getJTextArea().putClientProperty("fieldId", fieldID);
        oTTextArea.getJTextArea().putClientProperty("editor", this);
    }

    public void register(OTFileArea oTFileArea, FieldID fieldID) {
        this.register0(oTFileArea, fieldID);
    }

    public void register(JTextArea jTextArea, FieldID fieldID) {
        this.register0(jTextArea, fieldID);
        jTextArea.putClientProperty("fieldId", fieldID);
        jTextArea.putClientProperty("editor", this);
    }

    public void register(JTextField jTextField, FieldID fieldID) {
        this.register0(jTextField, fieldID);
        jTextField.putClientProperty("fieldId", fieldID);
        jTextField.putClientProperty("editor", this);
    }

    public void register(OTButtonGroup oTButtonGroup, FieldID fieldID) {
        this.register0(oTButtonGroup, fieldID);
    }

    public void register(JPanel jPanel, FieldID fieldID) {
        this.register0(jPanel, fieldID);
    }

    protected void restoreToolTipText(JComponent jComponent) {
        this.saveToolTipText(jComponent);
        String string = (String)jComponent.getClientProperty(TOOLTIP_TEXT);
        jComponent.setToolTipText(string);
    }

    public void resumeAllEvents() {
        for (Object object : this.listeners.keySet()) {
            if (object instanceof JCheckBox) {
                this.resumeEvents((JCheckBox)object);
                continue;
            }
            if (object instanceof JComboBox) {
                this.resumeEvents((JComboBox)object);
                continue;
            }
            if (object instanceof JList) {
                this.resumeEvents((JList)object);
                continue;
            }
            if (object instanceof JSpinner) {
                this.resumeEvents((JSpinner)object);
                continue;
            }
            if (object instanceof JTabbedPane) {
                this.resumeEvents((JTabbedPane)object);
                continue;
            }
            if (object instanceof OTButtonGroup) {
                this.resumeEvents((OTButtonGroup)object);
                continue;
            }
            if (!(object instanceof OTComboBox)) continue;
            this.resumeEvents((OTComboBox)object);
        }
    }

    public void resumeEvents(JCheckBox jCheckBox) {
        ItemListener itemListener = (ItemListener)this.listeners.get(jCheckBox);
        jCheckBox.addItemListener(itemListener);
    }

    public void resumeEvents(JComboBox jComboBox) {
        ActionListener actionListener = (ActionListener)this.listeners.get(jComboBox);
        jComboBox.addActionListener(actionListener);
    }

    public void resumeEvents(OTComboBox oTComboBox) {
        ActionListener actionListener = (ActionListener)this.listeners.get(oTComboBox);
        oTComboBox.addActionListener(actionListener);
    }

    public void resumeEvents(JList jList) {
        ListSelectionListener listSelectionListener = (ListSelectionListener)this.listeners.get(jList);
        jList.addListSelectionListener(listSelectionListener);
    }

    public void resumeEvents(JSpinner jSpinner) {
        ChangeListener changeListener = (ChangeListener)this.listeners.get(jSpinner);
        jSpinner.addChangeListener(changeListener);
    }

    public void resumeEvents(JTabbedPane jTabbedPane) {
        ChangeListener changeListener = (ChangeListener)this.listeners.get(jTabbedPane);
        jTabbedPane.addChangeListener(changeListener);
    }

    public void resumeEvents(OTButtonGroup oTButtonGroup) {
        ActionListener actionListener = (ActionListener)this.listeners.get(oTButtonGroup);
        oTButtonGroup.addActionListener(actionListener);
    }

    public JComponent getComponent(FieldID fieldID) {
        return this.widgets.get(fieldID);
    }

    protected void saveToolTipText(JComponent jComponent) {
        String string = jComponent.getToolTipText();
        if (string == null) {
            string = "";
        }
        jComponent.putClientProperty(TOOLTIP_TEXT, string);
    }

    public void set2(JComboBox jComboBox, Object object) {
        this.suspendEvents(jComboBox);
        jComboBox.setSelectedItem(object);
        this.resumeEvents(jComboBox);
    }

    public void set2(OTComboBox oTComboBox, Object object) {
        this.suspendEvents(oTComboBox);
        oTComboBox.setSelectedItem(object);
        this.resumeEvents(oTComboBox);
    }

    public void set(JCheckBox jCheckBox, Boolean bl) {
        jCheckBox.setSelected(bl);
    }

    public void set2(JCheckBox jCheckBox, Boolean bl) {
        this.suspendEvents(jCheckBox);
        jCheckBox.setSelected(bl);
        this.resumeEvents(jCheckBox);
    }

    public void set(JComboBox jComboBox, String string) {
        this.suspendEvents(jComboBox);
        if (string != null && this.uiLabelToBOMapping.containsKey(jComboBox) && this.uiLabelToBOMapping.get(jComboBox).containsKey(string)) {
            string = this.uiLabelToBOMapping.get(jComboBox).get(string);
        }
        if (this.includes(jComboBox, string)) {
            jComboBox.setSelectedItem(string);
            jComboBox.setForeground(Color.BLACK);
        } else {
            if (jComboBox.isEditable()) {
                jComboBox.getEditor().setItem(INVALID);
            }
            jComboBox.setForeground(Colors.OT_RED);
        }
        this.resumeEvents(jComboBox);
    }

    public void set(OTComboBox oTComboBox, String string) {
        this.suspendEvents(oTComboBox);
        if (this.includes(oTComboBox, string)) {
            oTComboBox.setSelectedItem(string);
            oTComboBox.setValid(true);
        } else {
            oTComboBox.setValid(false);
        }
        this.resumeEvents(oTComboBox);
    }

    private boolean includes(JComboBox jComboBox, String string) {
        if (string == null) {
            return false;
        }
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(jComboBox.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean includes(OTComboBox oTComboBox, String string) {
        if (string == null) {
            return false;
        }
        int n = oTComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(oTComboBox.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(JComponent jComponent, Object object) {
        if (jComponent == null) {
            return;
        }
        jComponent.putClientProperty("ProgrammaticChange", "true");
        try {
            String string;
            Class<OTComboBox> clazz = jComponent.getClass();
            String string2 = string = object == null ? null : object.toString();
            if (string != null && this.uiLabelToBOMapping.containsKey(jComponent) && this.uiLabelToBOMapping.get(jComponent).containsKey(string)) {
                string = this.uiLabelToBOMapping.get(jComponent).get(string);
            }
            if (clazz.equals(JCheckBox.class)) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                Boolean bl = Boolean.valueOf(object.toString());
                this.set(jCheckBox, bl);
                return;
            }
            if (JComboBox.class.isAssignableFrom(clazz)) {
                JComboBox jComboBox = (JComboBox)jComponent;
                this.set(jComboBox, string);
                return;
            }
            if (clazz.isAssignableFrom(OTComboBox.class)) {
                OTComboBox oTComboBox = (OTComboBox)jComponent;
                this.set(oTComboBox, string);
                return;
            }
            if (clazz.equals(JSlider.class)) {
                JSlider jSlider = (JSlider)jComponent;
                Integer n = Integer.valueOf(object.toString());
                this.set(jSlider, n);
                return;
            }
            if (clazz.equals(JSpinner.class)) {
                JSpinner jSpinner = (JSpinner)jComponent;
                SpinnerModel spinnerModel = jSpinner.getModel();
                if (spinnerModel instanceof SpinnerNumberModel) {
                    SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)spinnerModel;
                    Number number = spinnerNumberModel.getNumber();
                    if (object instanceof Number) {
                        this.set(jSpinner, (Number)object);
                        return;
                    } else if (object instanceof String && number instanceof Integer) {
                        Double d = Double.parseDouble(object.toString());
                        this.set(jSpinner, (Number)d.intValue());
                        return;
                    } else {
                        if (!(object instanceof String) || !(number instanceof Double)) throw new AssertionError((Object)("Unhandled spinner data type: " + object.getClass().getSimpleName()));
                        this.set(jSpinner, Double.parseDouble(object.toString()));
                    }
                    return;
                } else {
                    if (!(spinnerModel instanceof SpinnerDateModel)) return;
                    SpinnerDateModel spinnerDateModel = (SpinnerDateModel)spinnerModel;
                    Date date = spinnerDateModel.getDate();
                    this.set(jSpinner, date);
                    return;
                }
            }
            if (clazz.equals(JTextField.class)) {
                JTextField jTextField = (JTextField)jComponent;
                this.set(jTextField, string);
                return;
            }
            if (clazz.equals(OTTextField.class)) {
                OTTextField oTTextField = (OTTextField)jComponent;
                this.set(oTTextField, string);
                return;
            }
            if (clazz.equals(JTextArea.class)) {
                JTextArea jTextArea = (JTextArea)jComponent;
                this.set(jTextArea, string);
                return;
            }
            if (clazz.equals(OTJTextArea.class)) {
                OTJTextArea oTJTextArea = (OTJTextArea)jComponent;
                this.set(oTJTextArea, string);
                return;
            }
            if (OTTextArea.class.isAssignableFrom(clazz)) {
                OTTextArea oTTextArea = (OTTextArea)jComponent;
                this.set(oTTextArea, string);
                return;
            }
            if (OTBasicTextArea.class.isAssignableFrom(clazz)) {
                OTBasicTextArea oTBasicTextArea = (OTBasicTextArea)jComponent;
                this.set(oTBasicTextArea, string);
                return;
            }
            if (OTFileArea.class.isAssignableFrom(clazz)) {
                OTFileArea oTFileArea = (OTFileArea)jComponent;
                this.set(oTFileArea, string);
                return;
            }
            if (clazz.equals(JLabel.class)) {
                JLabel jLabel = (JLabel)jComponent;
                this.set(jLabel, string);
                return;
            }
            if (clazz.equals(OTButtonGroup.class)) {
                OTButtonGroup oTButtonGroup = (OTButtonGroup)jComponent;
                this.set(oTButtonGroup, string);
                return;
            }
            if (clazz.equals(JButton.class)) {
                return;
            }
            if (clazz.equals(JRadioButton.class)) {
                return;
            }
            if (clazz.equals(Table.class)) {
                Table table = (Table)jComponent;
                this.set(table, (Object[][])object);
                return;
            }
            if (clazz.equals(JList.class)) {
                JList jList = (JList)jComponent;
                this.set(jList, (String[])object);
                return;
            }
            String string3 = "Unknown widget class: " + clazz.getName();
            throw new RuntimeException(string3);
        }
        finally {
            jComponent.putClientProperty("ProgrammaticChange", null);
        }
    }

    public void set(JLabel jLabel, String string) {
        if (string == null) {
            return;
        }
        jLabel.setText(string.toString());
    }

    public void set(JList jList, Integer[] integerArray) {
        if (integerArray == null) {
            return;
        }
        this.suspendEvents(jList);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        jList.setSelectedIndices(nArray);
        this.resumeEvents(jList);
    }

    public void set(Table table, Object[][] objectArray) {
        TableModel tableModel = table.getModel();
        if (tableModel instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)tableModel;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = defaultTableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(defaultTableModel.getColumnName(i));
            }
            if (objectArray.length > 0) {
                while (arrayList.size() < objectArray[0].length) {
                    arrayList.add(Integer.toString(arrayList.size() + 1));
                }
            }
            Object[] objectArray2 = arrayList.toArray(new String[arrayList.size()]);
            defaultTableModel.setDataVector(objectArray, objectArray2);
            ColumnResizer.adjustColumnPreferredWidths(table);
        }
    }

    public void set(JList jList, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.suspendEvents(jList);
        if (stringArray.length != 0) {
            int n;
            ListModel listModel = jList.getModel();
            int[] nArray = new int[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = -1;
            }
            n = 0;
            for (int i = 0; i < listModel.getSize(); ++i) {
                String string = (String)listModel.getElementAt(i);
                for (String string2 : stringArray) {
                    if (!string.equals(string2)) continue;
                    nArray[n++] = i;
                }
            }
            jList.setSelectedIndices(nArray);
        }
        this.resumeEvents(jList);
    }

    public void set(JSlider jSlider, Integer n) {
        if (n == null) {
            return;
        }
        jSlider.setValue(n);
    }

    public void set(JSpinner jSpinner, Number number) {
        if (number == null) {
            return;
        }
        jSpinner.setValue(number);
    }

    public void set(JSpinner jSpinner, Date date) {
        if (date == null) {
            return;
        }
        jSpinner.setValue(date);
    }

    public void set(JTextArea jTextArea, String string) {
        if (string == null) {
            return;
        }
        jTextArea.setText(string);
    }

    public void set(OTTextArea oTTextArea, String string) {
        if (string == null) {
            return;
        }
        oTTextArea.setText(string);
    }

    public void set(OTBasicTextArea oTBasicTextArea, String string) {
        if (string == null) {
            return;
        }
        oTBasicTextArea.setText(string);
    }

    public void set(OTFileArea oTFileArea, String string) {
        if (string == null) {
            return;
        }
        oTFileArea.setText(string);
    }

    public void set(JTextField jTextField, String string) {
        if (string == null) {
            return;
        }
        jTextField.setText(string.toString());
    }

    public void set(OTButtonGroup oTButtonGroup, String string) {
        try {
            String string2;
            JRadioButton jRadioButton = oTButtonGroup.findButtonWithBOMapping(string);
            if (jRadioButton != null && (string2 = (String)jRadioButton.getClientProperty(UI_MAPPING_CLIENT_PROPERTY)) != null) {
                string = string2;
            }
            oTButtonGroup.setSelectedItem(string);
            oTButtonGroup.setForeground(Color.BLACK);
        }
        catch (RuntimeException runtimeException) {
            oTButtonGroup.setForeground(Colors.OT_RED);
        }
    }

    public void setModel(Model model) {
        this.setModel(model, false);
    }

    public void setModel(Model model, boolean bl) {
        this.model = model;
        this.controller = model.getController();
        this.model.subscribe(this);
        if (bl) {
            model.publish();
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    public void suspendAllEvents() {
        for (Object object : this.listeners.keySet()) {
            if (object instanceof JCheckBox) {
                this.suspendEvents((JCheckBox)object);
                continue;
            }
            if (object instanceof JComboBox) {
                this.suspendEvents((JComboBox)object);
                continue;
            }
            if (object instanceof JList) {
                this.suspendEvents((JList)object);
                continue;
            }
            if (object instanceof JSpinner) {
                this.suspendEvents((JSpinner)object);
                continue;
            }
            if (object instanceof JTabbedPane) {
                this.suspendEvents((JTabbedPane)object);
                continue;
            }
            if (object instanceof OTButtonGroup) {
                this.suspendEvents((OTButtonGroup)object);
                continue;
            }
            if (!(object instanceof OTComboBox)) continue;
            this.suspendEvents((OTComboBox)object);
        }
    }

    public void suspendEvents(JCheckBox jCheckBox) {
        ItemListener itemListener = (ItemListener)this.listeners.get(jCheckBox);
        jCheckBox.removeItemListener(itemListener);
    }

    public void suspendEvents(JComboBox jComboBox) {
        ActionListener actionListener = (ActionListener)this.listeners.get(jComboBox);
        while (Arrays.asList(jComboBox.getActionListeners()).contains(actionListener)) {
            jComboBox.removeActionListener(actionListener);
        }
    }

    public void suspendEvents(OTComboBox oTComboBox) {
        ActionListener actionListener = (ActionListener)this.listeners.get(oTComboBox);
        oTComboBox.removeActionListener(actionListener);
    }

    public void suspendEvents(JList jList) {
        ListSelectionListener listSelectionListener = (ListSelectionListener)this.listeners.get(jList);
        jList.removeListSelectionListener(listSelectionListener);
    }

    public void suspendEvents(JSpinner jSpinner) {
        ChangeListener changeListener = (ChangeListener)this.listeners.get(jSpinner);
        jSpinner.removeChangeListener(changeListener);
    }

    public void suspendEvents(JTabbedPane jTabbedPane) {
        ChangeListener changeListener = (ChangeListener)this.listeners.get(jTabbedPane);
        jTabbedPane.removeChangeListener(changeListener);
    }

    public void suspendEvents(OTButtonGroup oTButtonGroup) {
        ActionListener actionListener = (ActionListener)this.listeners.get(oTButtonGroup);
        oTButtonGroup.removeActionListener(actionListener);
    }

    public void update(FieldID fieldID, Object object) {
        JComponent jComponent = this.getComponent(fieldID);
        this.set(jComponent, object);
    }

    protected final GuiApi getGuiApi() {
        return this.guiApi;
    }

    public void setGuiApi(GuiApi guiApi) {
        this.guiApi = guiApi;
        for (View view : this.subViews) {
            view.setGuiApi(guiApi);
        }
    }

    protected boolean registerSubView(View view) {
        return this.subViews.add(view);
    }

    protected boolean forgetSubView(View view) {
        return this.subViews.remove(view);
    }

    public boolean isSubViewsEmpty() {
        return this.subViews.isEmpty();
    }

    public Set<View> getSubViews() {
        return this.subViews;
    }

    private void setComponentColor(JComponent jComponent, Color color) {
        jComponent.setForeground(color);
        if (jComponent instanceof JTable) {
            JTable jTable = (JTable)jComponent;
            jTable.getTableHeader().setForeground(color);
        }
    }

    public void invalidate(FieldID fieldID, String string) {
        JComponent jComponent = this.widgets.get(fieldID);
        if (jComponent == null) {
            throw new IllegalArgumentException("Unknown FieldID: " + String.valueOf(fieldID));
        }
        this.invalidate(jComponent, string);
    }

    private String trimHtmlHeadAndTailTags(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (!string2.contains("<html>")) {
            return string;
        }
        int n = string2.indexOf("<html>") + "<html>".length();
        int n2 = string2.indexOf("</html>");
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    public void invalidate(JComponent jComponent, String string) {
        this.saveToolTipText(jComponent);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = (String)jComponent.getClientProperty(TOOLTIP_TEXT);
        string2 = this.trimHtmlHeadAndTailTags(string2);
        stringBuilder.append("<html><body width=\"400\">");
        if (string2 != null) {
            if (string2.endsWith(".")) {
                stringBuilder.append(string2).append("<br>").append(string);
            } else {
                stringBuilder.append(string2).append(".<br>").append(string);
            }
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append("</body></html>");
        jComponent.setToolTipText(stringBuilder.toString());
        ColorPalette colorPalette = this.getGuiApi().getColorPalette();
        if (colorPalette == null) {
            this.setComponentColor(jComponent, Colors.OT_RED);
        } else {
            this.setComponentColor(jComponent, colorPalette.getErrorColor());
        }
    }

    public void revalidate(FieldID fieldID) {
        JComponent jComponent = this.widgets.get(fieldID);
        if (jComponent == null) {
            throw new IllegalArgumentException("Unknown FieldID: " + String.valueOf(fieldID));
        }
        this.revalidate(jComponent);
    }

    public void revalidate(JComponent jComponent) {
        this.restoreToolTipText(jComponent);
        ColorPalette colorPalette = this.getGuiApi().getColorPalette();
        if (colorPalette == null) {
            this.setComponentColor(jComponent, Color.BLACK);
        } else {
            this.setComponentColor(jComponent, colorPalette.getForegroundColor());
        }
    }

    @Override
    public void fieldInvalid(Model model, FieldID fieldID, String string) {
        this.invalidate(fieldID, string);
    }

    @Override
    public void fieldValid(Model model, FieldID fieldID) {
        this.revalidate(fieldID);
    }

    public boolean isMultipage() {
        return false;
    }

    public Integer getInsetAboveComponent() {
        return this.insetAboveComponent;
    }

    public void setInsetAboveComponent(Integer n) {
        this.insetAboveComponent = n;
    }

    public Integer getInsetBelowComponent() {
        return this.insetBelowComponent;
    }

    public void setInsetBelowComponent(Integer n) {
        this.insetBelowComponent = n;
    }

    public void createUILabelMapping(JComboBox jComboBox, String string, String string2) {
        Map map = this.uiLabelToBOMapping.computeIfAbsent(jComboBox, component -> new HashMap());
        map.put(string, string2);
        this.uiLabelToBOMapping.put(jComboBox, map);
    }

    public void setVisible(boolean bl, FieldID ... fieldIDArray) {
        if (fieldIDArray == null) {
            throw new NullPointerException("fieldIds is marked non-null but is null");
        }
        Stream.of(fieldIDArray).forEach(fieldID -> this.getComponent((FieldID)fieldID).setVisible(bl));
    }

    public void setEnabled(boolean bl, FieldID ... fieldIDArray) {
        if (fieldIDArray == null) {
            throw new NullPointerException("fieldIds is marked non-null but is null");
        }
        Stream.of(fieldIDArray).forEach(fieldID -> this.getComponent((FieldID)fieldID).setEnabled(bl));
    }

    public Controller getController() {
        return this.controller;
    }

    public Model getModel() {
        return this.model;
    }
}

