/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.examples.Book;
import alma.obsprep.guiutil.mvc.examples.LibraryTree;
import alma.obsprep.guiutil.mvc.examples.Shelf;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LibraryTreeTransferHandler
extends TransferHandler {
    private static final DataFlavor fBook = new DataFlavor(Book.class, "Book");
    private DataFlavor[] supportedDataFlavors = new DataFlavor[]{fBook};
    private LibraryTree ltree;
    private int currentAction;

    public LibraryTreeTransferHandler(LibraryTree libraryTree) {
        this.ltree = libraryTree;
        this.currentAction = 0;
    }

    private String decodeAction(int n) {
        if (n == 1) {
            return "COPY";
        }
        if (n == 3) {
            return "COPY_OR_MOVE";
        }
        if (n == 2) {
            return "MOVE";
        }
        if (n == 0) {
            return "NONE";
        }
        return "???";
    }

    private boolean isSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.supportedDataFlavors.length; ++i) {
            if (!this.supportedDataFlavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    private TreePath selectedPath(JTree jTree) {
        TreePath treePath = jTree.getSelectionPath();
        return treePath;
    }

    private DefaultMutableTreeNode selectedNode(JTree jTree) {
        TreePath treePath = this.selectedPath(jTree);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode;
    }

    private Object selectedUserObject(JTree jTree) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode(jTree);
        Object object = defaultMutableTreeNode.getUserObject();
        return object;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.isSupported(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        JTree jTree = (JTree)jComponent;
        Object object = this.selectedUserObject(jTree);
        if (!(object instanceof Book)) {
            return;
        }
        this.currentAction = n;
        this.ltree.setDndPending(true);
        super.exportAsDrag(jComponent, inputEvent, n);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        TreePath treePath = this.selectedPath(jTree);
        LibraryNodeTransferable libraryNodeTransferable = new LibraryNodeTransferable(treePath);
        return libraryNodeTransferable;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
        this.ltree.setDndPending(false);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTree jTree = (JTree)jComponent;
        Object object = this.selectedUserObject(jTree);
        if (!object.getClass().equals(Shelf.class)) {
            return false;
        }
        TreePath treePath = null;
        try {
            treePath = (TreePath)transferable.getTransferData(fBook);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode(jTree);
        Shelf shelf = (Shelf)object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
        Shelf shelf2 = (Shelf)defaultMutableTreeNode2.getUserObject();
        if (shelf2.equals(shelf)) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Book book = (Book)defaultMutableTreeNode3.getUserObject();
        System.out.println("==> " + this.decodeAction(this.currentAction) + ": from: [" + String.valueOf(shelf2) + "], dest: [" + String.valueOf(shelf) + "], book: [" + String.valueOf(book) + "]");
        if (this.currentAction == 1) {
            Book book2 = (Book)book.clone();
            shelf.add(book2);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(book2);
        } else {
            int n = shelf2.find(book);
            shelf2.remove(n);
            shelf.add(book);
        }
        int n = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode.insert(defaultMutableTreeNode3, n);
        TreePath treePath2 = this.selectedPath(jTree).pathByAddingChild(defaultMutableTreeNode3);
        this.ltree.refresh(defaultMutableTreeNode);
        this.ltree.refresh(defaultMutableTreeNode2);
        this.ltree.makeVisible(treePath2);
        this.ltree.scrollTo(defaultMutableTreeNode3);
        this.ltree.select(treePath2);
        return true;
    }

    private class LibraryNodeTransferable
    implements Transferable {
        private TreePath path = null;

        public LibraryNodeTransferable(TreePath treePath) {
            this.path = treePath;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            return this.path;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return LibraryTreeTransferHandler.this.supportedDataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return LibraryTreeTransferHandler.this.isSupported(dataFlavor);
        }
    }
}

