/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.CompactIsoDatePicker;
import alma.obsprep.ot.editors.obsproject.FinaliseEditingInterface;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;

public class DateEditorFactory {
    private DateEditor editor;
    private SimpleDateFormat format;

    public DateEditorFactory() {
        this("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public DateEditorFactory(String string) {
        this.format = new SimpleDateFormat(string);
        this.format.setLenient(false);
        this.editor = new DateEditor();
    }

    public DefaultCellEditor getEditor() {
        return this.editor;
    }

    private class DateEditor
    extends DefaultCellEditor
    implements FinaliseEditingInterface {
        private static final long serialVersionUID = -2393044215720773636L;
        private CompactIsoDatePicker picker;

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return !(eventObject instanceof MouseEvent);
        }

        public DateEditor() {
            super(new JFormattedTextField(new DateFormatter(DateEditorFactory.this.format)));
        }

        @Override
        public Object getCellEditorValue() {
            try {
                Component component = this.getComponent();
                if (JTextField.class.isAssignableFrom(component.getClass())) {
                    String string = ((JTextField)component).getText();
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(string);
                    DateEditorFactory.this.format.parse(string);
                    return zonedDateTime;
                }
            }
            catch (ParseException parseException) {
                return null;
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            FieldID fieldID = new FieldID("DateEditor.Date");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            String string = object instanceof ZonedDateTime ? ((ZonedDateTime)object).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")) : DateEditorFactory.this.format.format(object);
            this.picker = new CompactIsoDatePicker(null, fieldID, string, true);
            this.picker.setEditingCompletionListener(this);
            jPanel.add(this.picker);
            return jPanel;
        }

        private boolean parseDate(String string) {
            ParsePosition parsePosition = new ParsePosition(0);
            DateEditorFactory.this.format.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                return false;
            }
            Calendar calendar = DateEditorFactory.this.format.getCalendar();
            return calendar.get(1) < 2500;
        }

        @Override
        public boolean stopCellEditing() {
            this.picker.commitChanges();
            String string = this.picker.getIsoDateTimeField().getText();
            JTextField jTextField = (JTextField)this.getComponent();
            jTextField.setText(string);
            if (!string.equals("")) {
                this.picker.setValid(true);
                if (!this.parseDate(string)) {
                    this.picker.setValid(false);
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        @Override
        public void finaliseEditing() {
            this.stopCellEditing();
        }
    }
}

