/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.ReferencePointModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ReferencePointEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_COPY_REFERENCEPOSITION = new FieldID("ReferencePointEditor.copyReferencePosition");
    public static final FieldID FID_IS_COPY_REFERENCE_POSITION_AVAILABLE = new FieldID("ReferencePointEditor.isCopyReferencePositionAvailable");
    public static final FieldID FID_INTEGRATIONTIME_VUP = new FieldID("ReferencePointEditor.integrationTime");
    public static final FieldID FID_CYCLETIME_VUP = new FieldID("ReferencePointEditor.cycleTime");
    public static final FieldID FID_SUBSCANDURATION_VUP = new FieldID("ReferencePointEditor.subscanDuration");
    public static final FieldID FID_REFADJUST_BUTTON = new FieldID("ReferencePointEditor.refadjust");

    public ReferencePointEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected ReferencePointEditor() {
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_IS_COPY_REFERENCE_POSITION_AVAILABLE)) {
            boolean bl = (Boolean)object;
            this.getComponent(FID_COPY_REFERENCEPOSITION).setEnabled(bl);
        }
        super.update(fieldID, object);
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ReferencePointModel referencePointModel = (ReferencePointModel)this.getModel();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        CoordsEditor coordsEditor = new CoordsEditor(true, referencePointModel.getReferenceCoordinatesModel());
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "<html>Reference<br>Coordinates</html>", (JComponent)coordsEditor);
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, referencePointModel.getIntegrationTimeModel(), "Integration Time", "Integration Time");
        this.register(valueUnitPairEditor, FID_INTEGRATIONTIME_VUP);
        valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, referencePointModel.getCycleTimeModel(), "Cycle Time", "Cycle Time");
        this.register(valueUnitPairEditor, FID_CYCLETIME_VUP);
        valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, referencePointModel.getSubScanDurationModel(), "Subscan Duration", "The number of seconds the subscan will last - it must be a multiple of the integration duration");
        this.register(valueUnitPairEditor, FID_SUBSCANDURATION_VUP);
        JButton jButton = this.makeButton(FID_REFADJUST_BUTTON, "ADJUST Subscan", "Adjust the subscan duration to be a multiple of the integration duration");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Adjust subscan duration to a correct value ", (JComponent)jButton);
        JButton jButton2 = this.makeButton(FID_COPY_REFERENCEPOSITION, "Copy Reference Position", "Copy reference position to other science target field sources");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Copy reference position to other field sources", (JComponent)jButton2);
        this.constraints.weightx = 1.0;
        this.addComponent(jPanel);
    }

    @Override
    protected void build() {
        super.build("Reference");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        Reference reference = Reference.createReference();
        ReferencePointModel referencePointModel = new ReferencePointModel(null);
        ReferencePointEditor referencePointEditor = new ReferencePointEditor(referencePointModel);
        referencePointModel.setDocument(reference);
        JFrame jFrame = new JFrame("TEST:ReferenceEditor");
        jFrame.setPreferredSize(new Dimension(600, 600));
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.add(referencePointEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

