/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintTableModel;
import alma.obsprep.ot.gui.factory.Table;
import alma.valuetypes.Time;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class MonitoringConstraintsTable
extends Table {
    private static final Time ZERO_TIME = Time.createTimeSec(0.0);
    private static final long serialVersionUID = 3900865882362616898L;
    public static final int TABLE_WIDTH = 500;

    public MonitoringConstraintsTable(MonitoringConstraintTableModel monitoringConstraintTableModel) {
        super(monitoringConstraintTableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("TODO add tooltip");
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
    }

    private void setupTableCellEditors() {
        MonitoringConstraintTableModel monitoringConstraintTableModel = (MonitoringConstraintTableModel)this.getModel();
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        MonitoringConstraintEditor monitoringConstraintEditor = new MonitoringConstraintEditor(monitoringConstraintTableModel.getModel());
        monitoringConstraintEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(monitoringConstraintEditor);
    }

    private void setupTableCellRenderers() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 3474423374972813684L;
            String sdfStr = "yyyy-MM-dd HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(this.sdfStr);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setToolTipText("<html><p>Click on a row and select <b>'Edit'</b> to change details</p></html>");
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                MonitoringConstraint monitoringConstraint = (MonitoringConstraint)((Object)object);
                Object object2 = "<html>";
                Time time = monitoringConstraint.getMonitoringLength();
                Time time2 = monitoringConstraint.getCycleTime();
                Time time3 = monitoringConstraint.getAllowedMargin();
                if (monitoringConstraint.hasIsFixedStart() && monitoringConstraint.getIsFixedStart() && "" != monitoringConstraint.getStartTime()) {
                    time3 = ZERO_TIME;
                    monitoringConstraint.setAllowedMargin(time3);
                    object2 = (String)object2 + "Start date of ";
                    object2 = (String)object2 + this.sdf.format(monitoringConstraint.getStartTimeAsDate());
                } else {
                    object2 = (String)object2 + "Arbitrary start ";
                }
                if (time.getContent() > 0.0) {
                    object2 = (String)object2 + " with a monitoring length of ";
                    object2 = (String)object2 + time.getContent();
                    object2 = (String)object2 + " ";
                    object2 = (String)object2 + time.getUnit();
                }
                if (time2.getContent() > 0.0) {
                    object2 = (String)object2 + " and a cycle time of ";
                    object2 = (String)object2 + time2.getContent();
                    object2 = (String)object2 + " ";
                    object2 = (String)object2 + time2.getUnit();
                }
                if (time3.getContent() > 0.0) {
                    object2 = (String)object2 + " with a margin of &plusmn; ";
                    object2 = (String)object2 + time3.getContent();
                    object2 = (String)object2 + " ";
                    object2 = (String)object2 + time3.getUnit();
                }
                object2 = (String)object2 + "</html>";
                this.setText((String)object2);
                return this;
            }
        };
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    public int getPreferredEditorWidth() {
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        MonitoringConstraintEditor monitoringConstraintEditor = (MonitoringConstraintEditor)tableColumn.getCellEditor();
        return monitoringConstraintEditor.getPreferredSize().width;
    }
}

