/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameterModel;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class MosaicParameterEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_FREQUENCY = new FieldID("MosaicParameter.Frequency");
    public static final FieldID FID_BEAMSIZE = new FieldID("MosaicParameter.Beamsize");
    public static final FieldID FID_OVERLAP = new FieldID("MosaicParameter.Overlap");
    public static final FieldID FID_SPACING = new FieldID("MosaicParameter.Spacing");
    public static final FieldID FID_ANTENNA = new FieldID("MosaicParameter.Antenna");
    public static final FieldID FID_LAYOUTTYPE = new FieldID("MosaicParameter.Layouttype");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();

    public MosaicParameterEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public MosaicParameterModel getModel() {
        return (MosaicParameterModel)super.getModel();
    }

    @Override
    public void addComponents(String string) {
        this.constraints.weightx = 1.0;
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, this.getModel().getFrequencyModel(), "Frequency", tooltips.get(FID_FREQUENCY));
        OTTextField oTTextField = this.addTextComponent(this, this.layout, this.constraints, FID_BEAMSIZE, "<html>Antenna Beamsize (" + Antenna.BEAMSIZE_TIP_STRING + ")</html>", tooltips.get(FID_BEAMSIZE));
        oTTextField.setFocusable(false);
        oTTextField.setEditable(false);
        oTTextField = this.addTextComponent(this, this.layout, this.constraints, FID_OVERLAP, "Overlap[%]", tooltips.get(FID_OVERLAP));
        this.setVerifier(oTTextField, "FOCUSLOST_VERIFIER", new DoubleVerifier((Editor)this, (JTextField)oTTextField, -1.7976931348623157E308, 100.0, false, false));
        oTTextField = this.addTextComponent(this, this.layout, this.constraints, FID_SPACING, "Spacing[arcsec]", tooltips.get(FID_SPACING));
        this.setVerifier(oTTextField, "FOCUSLOST_VERIFIER", new DoubleVerifier((Editor)this, (JTextField)oTTextField, 0.0, Double.MAX_VALUE, false, false));
        this.addOTButtonGroup((JComponent)this, this.layout, this.constraints, FID_ANTENNA, "Antenna", tooltips.get(FID_ANTENNA), Antenna.getLabels());
        this.addOTButtonGroup((JComponent)this, this.layout, this.constraints, FID_LAYOUTTYPE, "Layout Type", tooltips.get(FID_LAYOUTTYPE), MosaicParameters.knownTypeList);
    }

    @Override
    public void build() {
        this.build("Mosaic Parameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_ANTENNA)) {
            Antenna antenna = (Antenna)((Object)object);
            super.update(fieldID, antenna.getLabel());
            return;
        }
        if (fieldID.equals(FID_BEAMSIZE)) {
            Angle angle = (Angle)((Object)object);
            super.update(fieldID, Antenna.formatBeamSize(angle));
            return;
        }
        if (fieldID.equals(FID_OVERLAP) || fieldID.equals(FID_SPACING)) {
            Double d = (Double)object;
            if (d.isInfinite()) {
                d = 0.0;
            }
            String string = TextUtils.format(d, 3, 5);
            super.update(fieldID, string);
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        MosaicParameterModel mosaicParameterModel = new MosaicParameterModel(null);
        MosaicParameterEditor mosaicParameterEditor = new MosaicParameterEditor(mosaicParameterModel);
        MosaicParameters mosaicParameters = new MosaicParameters();
        mosaicParameterModel.setDocument(mosaicParameters);
        JFrame jFrame = new JFrame(mosaicParameterEditor.getClass().getSimpleName());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(mosaicParameterEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static {
        tooltips.put(FID_FREQUENCY, "Frequency used to calculate the beamsize and the default spacing");
        tooltips.put(FID_BEAMSIZE, "Beamsize of each pointings");
        tooltips.put(FID_OVERLAP, "Overlap % of the beams. Negative value for sparse.");
        tooltips.put(FID_SPACING, "Distance between two FOVs");
        tooltips.put(FID_ANTENNA, "Antenna Diameter");
        tooltips.put(FID_LAYOUTTYPE, "Layout Type");
    }
}

