/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.SkyCoordinates;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PolygonModel
extends Model
implements TableModel {
    private SkyCoordsModel centreModel = null;
    private AbstractTableModel tmDelegate = null;
    public final FieldID raValueFID = new FieldID("Polygon RA Value");
    public final FieldID raUnitFID = new FieldID("Polygon RA Units");
    public final FieldID decValueFID = new FieldID("Polygon DEC Value");
    public final FieldID decUnitFID = new FieldID("Polygon DEC Units");

    public PolygonModel(Polygon polygon) {
        super((Object)polygon);
        this.centreModel = new SkyCoordsModel(null);
        Object[] objectArray = new String[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            objectArray[i] = this.getColumnName(i);
        }
        this.tmDelegate = new DefaultTableModel(objectArray, 5);
    }

    private Polygon getShape() {
        return (Polygon)((Object)this.getDocument());
    }

    public SkyCoordsModel getCentreModel() {
        return this.centreModel;
    }

    @Override
    public void publish() {
        Polygon polygon = this.getShape();
        if (polygon != null) {
            this.getCentreModel().publish();
            this.publish(FieldIDs.nameFID, polygon.getName());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.nameFID) {
            String string = (String)object;
            this.getShape().setName(string);
            return string;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        Polygon polygon = this.getShape();
        SkyCoordinates skyCoordinates = polygon.getCentre();
        this.getCentreModel().setDocument(skyCoordinates);
    }

    @Override
    public int getRowCount() {
        Polygon polygon = this.getShape();
        if (polygon != null) {
            return this.getShape().getPointCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Latitude";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "Longitude";
            }
            case 3: {
                return "";
            }
        }
        return "<unknown>";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Double.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SkyCoordinates skyCoordinates = this.getShape().getPoint(n);
        switch (n2) {
            case 0: {
                return skyCoordinates.getLatitude().getContent();
            }
            case 1: {
                return skyCoordinates.getLatitude().getUnit();
            }
            case 2: {
                return skyCoordinates.getLongitude().getContent();
            }
            case 3: {
                return skyCoordinates.getLongitude().getUnit();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SkyCoordinates skyCoordinates = this.getShape().getPoint(n);
        switch (n2) {
            case 0: {
                Double d = (Double)object;
                skyCoordinates.getLatitude().setContent(d);
                break;
            }
            case 1: {
                String string = (String)object;
                skyCoordinates.getLatitude().setUnit(string);
                break;
            }
            case 2: {
                Double d = (Double)object;
                skyCoordinates.getLongitude().setContent(d);
                break;
            }
            case 3: {
                String string = (String)object;
                skyCoordinates.getLongitude().setUnit(string);
                break;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tmDelegate.addTableModelListener(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tmDelegate.removeTableModelListener(tableModelListener);
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.tmDelegate.fireTableRowsDeleted(n, n2);
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.tmDelegate.fireTableRowsInserted(n, n2);
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.tmDelegate.fireTableRowsUpdated(n, n2);
    }

    public void addPoint(int n) {
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        if (n == -1) {
            n = this.getRowCount();
        }
        this.getShape().addPoint(n, skyCoordinates);
        this.fireTableRowsInserted(n, n);
    }

    public void deletePoint(int n) {
        if (n != -1) {
            SkyCoordinates skyCoordinates = this.getShape().getPoint(n);
            this.getShape().removePoint(skyCoordinates);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void movePointUp(int n) {
        if (n > 0) {
            SkyCoordinates skyCoordinates = this.getShape().getPoint(n);
            SkyCoordinates skyCoordinates2 = this.getShape().getPoint(n - 1);
            this.getShape().setPoint(n, skyCoordinates2);
            this.getShape().setPoint(n - 1, skyCoordinates);
            this.fireTableRowsUpdated(n - 1, n);
        }
    }

    public void movePointDown(int n) {
        if (n != -1 && n < this.getRowCount() - 1) {
            SkyCoordinates skyCoordinates = this.getShape().getPoint(n);
            SkyCoordinates skyCoordinates2 = this.getShape().getPoint(n + 1);
            this.getShape().setPoint(n, skyCoordinates2);
            this.getShape().setPoint(n + 1, skyCoordinates);
            this.fireTableRowsUpdated(n, n + 1);
        }
    }
}

