/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import java.util.List;
import lombok.NonNull;

public class PhaseCalObs
extends CalObs {
    private Speed windSpeed;
    private PhaseFluctuations phaseFluctuations;
    private double phaseFluctuationsFunction = PhaseCalObs.getCalObsProperties().getPhaseFluctuationsFunction();
    private double thermalFluctuations = 0.025;
    private Angle zenithAngle;

    public PhaseCalObs() {
        this.setCalType(CalType.Phase);
    }

    public PhaseCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    public Angle getZenithAngle() {
        if (this.zenithAngle == null) {
            this.zenithAngle = Angle.createAngle();
        }
        this.zenithAngle.setContentAndUnit(this.zenithAngleDeg(), Angle.UNIT_DEG);
        return this.zenithAngle;
    }

    private double zenithAngleDeg() {
        double d = this.getCalibratorCoordinates().getLatitude().getDegs();
        double d2 = this.getObservatoryLatitude().getDegs();
        return Math.abs(d - d2);
    }

    @Override
    public boolean atmCalRequired(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        List<Target> list = schedBlock.getScienceTargets();
        return list != null && list.size() > 1;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        return (Frequency)ScienceSpectralWindow.getSingleContinuumBandwidth().multiply(4.0);
    }

    @Override
    public double getDefaultSNR() {
        return PhaseCalObs.getCalObsProperties().getPhaseCalSNR();
    }

    @Override
    public Flux getDefaultFlux() {
        Flux flux = PhaseCalObs.getCalObsProperties().getPhaseFlux();
        try {
            ReceiverBand receiverBand = this.getReceiverBand();
            if (receiverBand.getNumber() == 9) {
                flux = Flux.createFlux((double)10.0, (String)Flux.UNIT_JY);
            }
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            // empty catch block
        }
        return flux;
    }

    @Override
    public Time calTime(Time time) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        if (time.getContentInUnits(Time.UNIT_S) > 2.0) {
            return time;
        }
        return Time.createTimeSec(2.0);
    }

    @Override
    public Time rawCycleTime() {
        double d = this.getWindSpeed().getContentInUnits(Speed.UNIT_M_S);
        double d2 = this.getSciFrequency().getWavelengthM();
        double d3 = this.zenithAngleDeg() / 180.0 * Math.PI;
        double d4 = 1.0 / Math.cos(d3);
        double d5 = d2 * 1000000.0 / (Math.PI * 2 * this.getPhaseFluctuations().getValue() * Math.sqrt(d4));
        double d6 = Math.pow(d5, 1.0 / this.getPhaseFluctuationsFunction());
        double d7 = 2.0 / d * d6;
        return Time.createTime((double)d7, (String)Time.UNIT_S);
    }

    @Override
    public Time cycleTime(Time time) {
        double d = time.getContentInUnits(Time.UNIT_S);
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        double d2 = Math.min(Math.max(d, 15.0), 300.0);
        return Time.createTimeSec(d2);
    }

    public Speed getWindSpeed() {
        if (this.windSpeed == null) {
            this.windSpeed = PhaseCalObs.getCalObsProperties().getAverageWindSpeed();
        }
        return this.windSpeed;
    }

    public double getPhaseFluctuationsFunction() {
        return this.phaseFluctuationsFunction;
    }

    public void setAlpha(double d) {
        this.phaseFluctuationsFunction = d;
    }

    public PhaseFluctuations getDefaultPhaseFluctuations() {
        PhaseFluctuations phaseFluctuations = PhaseFluctuations.Second;
        try {
            ReceiverBand receiverBand = this.getReceiverBand();
            if (receiverBand.getNumber() >= 7) {
                phaseFluctuations = PhaseFluctuations.First;
            }
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            // empty catch block
        }
        return phaseFluctuations;
    }

    public PhaseFluctuations getPhaseFluctuations() {
        if (this.phaseFluctuations == null) {
            this.phaseFluctuations = this.getDefaultPhaseFluctuations();
        }
        return this.phaseFluctuations;
    }

    public void setPhaseFluctuations(PhaseFluctuations phaseFluctuations) {
        this.phaseFluctuations = phaseFluctuations;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append("\n");
        stringBuilder.append("========= " + this.getClass().getSimpleName() + " ==========\n");
        stringBuilder.append("wind speed            = " + String.valueOf((Object)this.getWindSpeed())).append("\n");
        stringBuilder.append("alpha                 = " + this.getPhaseFluctuationsFunction()).append("\n");
        stringBuilder.append("phase fluctuations    = " + String.valueOf((Object)this.getPhaseFluctuations()));
        return stringBuilder.toString();
    }

    public void setWindSpeed(Speed speed) {
        this.windSpeed = speed;
    }

    public double getThermalFluctuations() {
        return this.thermalFluctuations;
    }

    public void setThermalFluctuations(double d) {
        this.thermalFluctuations = d;
    }

    public static enum PhaseFluctuations {
        Best("10% best weather"),
        First("First Quartile"),
        Second("Second Quartile"),
        Third("Third Quartile");

        private final String label;
        private static String[] knownLabels;

        public static synchronized String[] getKnownLabels() {
            if (knownLabels == null) {
                knownLabels = new String[PhaseFluctuations.values().length];
                for (int i = 0; i < knownLabels.length; ++i) {
                    PhaseFluctuations.knownLabels[i] = PhaseFluctuations.values()[i].toString();
                }
            }
            return knownLabels;
        }

        public static PhaseFluctuations getPhaseFluctuations(String string) {
            for (PhaseFluctuations phaseFluctuations : PhaseFluctuations.values()) {
                if (!phaseFluctuations.name().equals(string) && !phaseFluctuations.label.equals(string) && !phaseFluctuations.toString().equals(string)) continue;
                return phaseFluctuations;
            }
            return null;
        }

        public static PhaseFluctuations getPhaseFluctuations(double d) {
            for (PhaseFluctuations phaseFluctuations : PhaseFluctuations.values()) {
                if (phaseFluctuations.getValue() != d) continue;
                return phaseFluctuations;
            }
            return null;
        }

        public double getValue() {
            return switch (this) {
                case Best -> CalObs.getCalObsProperties().getPhaseFluctuationsBest();
                case First -> CalObs.getCalObsProperties().getPhaseFluctuations1st();
                case Second -> CalObs.getCalObsProperties().getPhaseFluctuations2nd();
                case Third -> CalObs.getCalObsProperties().getPhaseFluctuations3rd();
                default -> throw new RuntimeException("Unexpected Error");
            };
        }

        public String toString() {
            return String.format("%s : %.1f", this.label, this.getValue());
        }

        private PhaseFluctuations(String string2) {
            this.label = string2;
        }
    }
}

