/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.common.sensitivitycalculatorcore.calc.SensitivityCalculatorEngine;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.etc.editor.SensitivityCalculatorModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;

public class EtcParamsSeed
implements EventReceiver {
    private ProjectTreeNode m_treeNode;
    private BusinessObject m_bo;
    private final SensitivityCalculatorModel model;

    public EtcParamsSeed(SensitivityCalculatorModel sensitivityCalculatorModel) {
        this.model = sensitivityCalculatorModel;
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_treeNode = (ProjectTreeNode)event.getSource();
        this.m_bo = (BusinessObject)this.m_treeNode.getUserObject();
        if (this.m_bo != null) {
            SensitivityCalculatorEngine sensitivityCalculatorEngine = (SensitivityCalculatorEngine)this.model.getDocument();
            if (Target.isTargetWithScienceParameters(this.m_bo)) {
                Target target = (Target)this.m_bo;
                FieldSource fieldSource = target.getFieldSource();
                SpectralSpec spectralSpec = target.getSpectralSpec();
                if (fieldSource != null) {
                    this.seedCoordinates(fieldSource, sensitivityCalculatorEngine);
                }
                if (spectralSpec != null) {
                    this.seedFrequency(spectralSpec, sensitivityCalculatorEngine);
                }
                this.model.publish();
            } else {
                BusinessObject businessObject = this.m_bo;
                if (businessObject instanceof FieldSource) {
                    FieldSource fieldSource = (FieldSource)businessObject;
                    this.seedCoordinates(fieldSource, sensitivityCalculatorEngine);
                    this.model.publish();
                } else {
                    businessObject = this.m_bo;
                    if (businessObject instanceof SpectralSpec) {
                        SpectralSpec spectralSpec = (SpectralSpec)businessObject;
                        this.seedFrequency(spectralSpec, sensitivityCalculatorEngine);
                        this.model.publish();
                    }
                }
            }
        }
    }

    private void seedCoordinates(FieldSource fieldSource, SensitivityCalculatorEngine sensitivityCalculatorEngine) {
        SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
        Latitude latitude = skyCoordinates.getLatitude();
        skyCoordinates.getLongitude();
        sensitivityCalculatorEngine.setRaDec(latitude.getDegs());
    }

    private void seedFrequency(SpectralSpec spectralSpec, SensitivityCalculatorEngine sensitivityCalculatorEngine) {
        Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
        sensitivityCalculatorEngine.setObservingFrequencyInGHZ(frequency.getContentInGHz());
    }
}

