/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.valuetypes.Frequency;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jsky.catalog.FieldDesc;
import jsky.catalog.vo.VoTable;
import org.apache.commons.lang3.StringUtils;

public class SlapParser {
    private static final String DESCRIPTION_ID = "chemicalname";
    private static final String FREQUENCY_ID = "frequency";
    private static final String PROVENANCE_ID = "catalog name";
    private static final String SIJMU2_ID = "sijmu2";
    private static final String SPECIES_ID = "molformula_noparens";
    private static final String TRANSITION_ID = "quantum numbers";
    private static final String UPPERSTATEENERGY_ID = "upperstateenergyK";
    private static final String SPLATALOG_ID = "line_id";
    private static final Map<String, Class<? extends ColumnParser>> PARSER_MAPPING = new HashMap<String, Class<? extends ColumnParser>>();
    private final List<ColumnParser> columnParsers = new ArrayList<ColumnParser>();

    public List<SpectralLine> parse(VoTable voTable, String string, boolean bl) {
        this.constructColumnParsers(voTable);
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("chemicalSpecies is an empty string");
        }
        String string2 = null;
        if (bl) {
            string2 = string.trim().replaceAll("\\s+", " ").replaceAll("\\s+", " ").replaceAll("&(Sigma|Omega);", "$1").replaceAll("Sigma", "\u03a3").replaceAll("(\\D{1}=\\d+)", " $1").replaceAll("\\s+", " ");
            try {
                string2 = URLDecoder.decode(string2, Charset.defaultCharset().name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (voTable == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: vot");
        }
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>(200);
        Vector vector = voTable.getDataVector();
        for (Vector vector2 : vector) {
            SpectralLine spectralLine = this.getSpectralLineFromRow(vector2);
            if (bl) {
                assert (string2 != null);
                if (!spectralLine.getSpecies().equalsIgnoreCase(string2)) continue;
                arrayList.add(spectralLine);
                continue;
            }
            arrayList.add(spectralLine);
        }
        return arrayList;
    }

    public List<SpectralLine> parse(VoTable voTable) {
        this.constructColumnParsers(voTable);
        if (voTable == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: vot");
        }
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>(200);
        Vector vector = voTable.getDataVector();
        for (Vector vector2 : vector) {
            SpectralLine spectralLine = this.getSpectralLineFromRow(vector2);
            arrayList.add(spectralLine);
        }
        return arrayList;
    }

    private void constructColumnParsers(VoTable voTable) {
        Class[] classArray = new Class[]{SlapParser.class, Integer.TYPE};
        block2: for (int i = 0; i < voTable.getColumnCount(); ++i) {
            FieldDesc fieldDesc = voTable.getColumnDesc(i);
            String string = fieldDesc.getName();
            if (string == null) continue;
            for (String string2 : PARSER_MAPPING.keySet()) {
                if (!string2.equals(string)) continue;
                Class<? extends ColumnParser> clazz = PARSER_MAPPING.get(string2);
                try {
                    Constructor<? extends ColumnParser> constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{this, i};
                    ColumnParser columnParser = constructor.newInstance(objectArray);
                    this.columnParsers.add(columnParser);
                    continue block2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private SpectralLine getSpectralLineFromRow(Vector<Object> vector) {
        SpectralLine spectralLine = new SpectralLine();
        spectralLine.setType(SpectralLine.Type.ONLINE);
        for (ColumnParser columnParser : this.columnParsers) {
            columnParser.parse(spectralLine, vector);
        }
        return spectralLine;
    }

    static {
        PARSER_MAPPING.put(DESCRIPTION_ID, DescriptionParser.class);
        PARSER_MAPPING.put(FREQUENCY_ID, FrequencyParser.class);
        PARSER_MAPPING.put(PROVENANCE_ID, ProvenanceParser.class);
        PARSER_MAPPING.put(SIJMU2_ID, Sijmu2Parser.class);
        PARSER_MAPPING.put(SPECIES_ID, SpeciesParser.class);
        PARSER_MAPPING.put(TRANSITION_ID, TransitionParser.class);
        PARSER_MAPPING.put(UPPERSTATEENERGY_ID, UpperStateEnergyParser.class);
        PARSER_MAPPING.put(SPLATALOG_ID, SplatalogIdParser.class);
    }

    private static interface ColumnParser {
        public void parse(SpectralLine var1, Vector<Object> var2);
    }

    class DescriptionParser
    implements ColumnParser {
        private final int index;

        public DescriptionParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof String) {
                String string = (String)object;
                spectralLine.setDescription(string);
            }
        }
    }

    class FrequencyParser
    implements ColumnParser {
        private final int index;

        public FrequencyParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof Double) {
                double d = (Double)object;
                spectralLine.setFrequency(Frequency.createFrequency((double)d, (String)Frequency.UNIT_MHZ));
            }
        }
    }

    class ProvenanceParser
    implements ColumnParser {
        private final int index;

        public ProvenanceParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof String) {
                String string = (String)object;
                spectralLine.setProvenance(string);
            }
        }
    }

    class Sijmu2Parser
    implements ColumnParser {
        private final int index;

        public Sijmu2Parser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof Double) {
                double d = (Double)object;
                spectralLine.setSmu(d);
            }
        }
    }

    class SpeciesParser
    implements ColumnParser {
        private final int index;

        public SpeciesParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof String) {
                String string = (String)object;
                spectralLine.setSpecies(string);
            }
        }
    }

    class TransitionParser
    implements ColumnParser {
        private final int index;

        public TransitionParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof String) {
                String string = (String)object;
                spectralLine.setTransition(string);
            }
        }
    }

    class UpperStateEnergyParser
    implements ColumnParser {
        private final int index;

        public UpperStateEnergyParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof Double) {
                double d = (Double)object;
                spectralLine.setUpperStateEnergy(d);
            }
        }
    }

    public class SplatalogIdParser
    implements ColumnParser {
        private final int index;

        public SplatalogIdParser(int n) {
            this.index = n;
        }

        @Override
        public void parse(SpectralLine spectralLine, Vector<Object> vector) {
            Object object = vector.get(this.index);
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                spectralLine.setLineId(n);
            }
        }
    }
}

