/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.services.experts.spectralline.gui.DateRenderer;
import alma.obsprep.services.experts.spectralline.gui.LineTitleRenderer;
import alma.obsprep.services.experts.spectralline.gui.OTTableRenderer;
import alma.obsprep.services.experts.spectralline.gui.UnitFormat;
import alma.obsprep.services.experts.spectralline.gui.UnitFormatTableCellRenderer;

public class TableCellRendererFactory {
    public static OTTableRenderer getTableCellRenderer(Units units) {
        switch (units) {
            case DEBYE_SQUARED: {
                return new UnitFormatTableCellRenderer(UnitFormat.debyeSquared());
            }
            case FREQUENCY: {
                return new UnitFormatTableCellRenderer(UnitFormat.frequency());
            }
            case FLUX_DENSITY: {
                return new UnitFormatTableCellRenderer(UnitFormat.fluxDensity());
            }
            case TEMPERATURE: {
                return new UnitFormatTableCellRenderer(UnitFormat.temperature());
            }
            case SEPARATION: {
                return new UnitFormatTableCellRenderer(UnitFormat.sexagesimalArc());
            }
            case DATE: {
                return new DateRenderer();
            }
            case LINETITLE: {
                return new LineTitleRenderer();
            }
        }
        return new OTTableRenderer();
    }

    public static enum Units {
        TEMPERATURE,
        DEBYE_SQUARED,
        FREQUENCY,
        FLUX_DENSITY,
        SEPARATION,
        LINETITLE,
        DATE,
        CAL_FLUX_DENSITY;

    }
}

