/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public abstract class SpectralSpecWorker {
    private static final double DELTA = 1.0E-10;
    protected final SpectralSetupParameters ssp;
    protected final Velocity velocity;
    protected final CorrelatorExpert correxp;
    @NonNull
    protected Optional<SBGenerationContext> sbGenerationContext;

    protected SpectralSpecWorker(SpectralSetupParameters spectralSetupParameters, CorrelatorType correlatorType, Velocity velocity, @NonNull Optional<SBGenerationContext> optional) {
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        this.ssp = spectralSetupParameters;
        this.velocity = velocity;
        this.correxp = CorrelatorExpert.getInstance(correlatorType);
        this.sbGenerationContext = optional;
    }

    public Map<String, SpectralSpec> getSpectralSpecHash() throws WizardSBGenerationException {
        this.validate();
        HashMap<String, SpectralSpec> hashMap = new HashMap<String, SpectralSpec>();
        SpectralSpec spectralSpec = this.createSpectralSpecWithCorrelatorConfiguration();
        this.setupSpectralSpec(spectralSpec);
        hashMap.put("SCIENCE", spectralSpec);
        SpectralSpec spectralSpec2 = this.createSpectralSpecWithCorrelatorConfiguration();
        this.setupBand3Spec(spectralSpec2);
        hashMap.put("POINTING", spectralSpec2);
        hashMap.put("TDMAmpBP", this.cloneTDMAmpBPSpectralSpec(spectralSpec));
        if (!this.ssp.isSingleContinuum()) {
            hashMap.put("TDMPhase", this.cloneTDMPhaseSpectralSpec(spectralSpec));
        }
        if (!this.ssp.isSingleContinuum()) {
            hashMap.put("TDMATM", this.cloneTDMAtmCalSpectralSpec(spectralSpec));
        }
        return hashMap;
    }

    protected abstract SpectralSpec createSpectralSpecWithCorrelatorConfiguration();

    protected void validate() throws WizardSBGenerationException {
    }

    public void setupSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        Object object;
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        String string = this.ssp.getType();
        Frequency frequency = null;
        Object object2 = null;
        ReceiverBand receiverBand = null;
        Velocity velocity = this.velocity.deepCopy();
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            frequency = this.ssp.getSingleContinuumFrequency();
            if (this.ssp.isSingleContinuumSkyFrequency()) {
                object2 = "SkyCont(" + String.valueOf((Object)frequency) + ")";
                velocity = Velocity.createVelocity();
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                object2 = "RestCont(" + String.valueOf((Object)frequency) + ")";
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_REST);
            }
        } else if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            object = this.ssp.getScienceSpectralWindow(0);
            frequency = object.getCenterFrequency();
            object2 = this.ssp.getAbstractScienceSpectralWindow(0).getTransitionName();
            if (this.ssp.isDerivedSSP() || VLBIExpert.isScienceGoalLegalVLBISpectralLine(this.ssp.getScienceGoal())) {
                velocity = Velocity.createVelocity();
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_REST);
            }
        } else if (string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            throw new RuntimeException("Spectral Window Type is not supported : " + string);
        }
        frequency.dopplerShifted(velocity);
        receiverBand = this.ssp.getReceiverBand();
        if (receiverBand == null) {
            GUIUtilities.warning(null, "Unable to determine receiver band - invalid frequency?");
            throw new WizardSBGenerationException("Unable to determine receiver band - invalid frequency?");
        }
        frequencySetup.getRestFrequency().setContentInGHz(frequency.getContentInGHz());
        spectralSpec.setName((String)object2 + " Science setup");
        frequencySetup.setRestFrequency(frequency.deepCopy());
        frequencySetup.setTransitionName((String)object2);
        frequencySetup.setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        object = spectralSpec.getCorrelatorConfiguration();
        this.setupCorrelatorConfig((AbstractCorrelatorConfiguration)object);
        String string2 = spectralSpec.getReceiverType();
        if (string2.equals(SpectralSpec.RECEIVERTYPE_TSB) || string2.equals(SpectralSpec.RECEIVERTYPE_DSB)) {
            ((AbstractCorrelatorConfiguration)object).setEnable180DegreeWalshFunction(true);
            object.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        }
        if (string2.equals(SpectralSpec.RECEIVERTYPE_SSB)) {
            ((AbstractCorrelatorConfiguration)object).setEnable180DegreeWalshFunction(true);
        }
    }

    public void setupBand3Spec(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(98.0);
        ReceiverBand receiverBand = null;
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequency);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.warning(null, illegalArgumentException.getMessage());
            throw new WizardSBGenerationException(illegalArgumentException.getMessage());
        }
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        frequencySetup.getRestFrequency().setContentInGHz(frequency.getContentInGHz());
        frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        spectralSpec.setName("Band 3 Pointing setup");
        spectralSpec.getFrequencySetup().setRestFrequency(frequency.deepCopy());
        spectralSpec.getFrequencySetup().setTransitionName("Pointing");
        spectralSpec.getFrequencySetup().setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        this.setupCalibrationContinuumBasebands(abstractCorrelatorConfiguration);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
    }

    public SpectralSpec cloneTDMAmpBPSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.ssp.getCorrPolarization());
        spectralSpec2.setName("TDM Amp, BP Cal setup");
        for (int i = 0; i < spectralSpec2.getBaseBandCount(); ++i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec2.getBaseBandConfig(i);
            for (int j = 0; j < abstractBaseBandConfig.getSingleSpectralWindowCount(); ++j) {
                abstractBaseBandConfig.removeSingleSpectralWindow(abstractBaseBandConfig.getSingleSpectralWindow(j));
            }
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        return spectralSpec2;
    }

    public SpectralSpec cloneTDMPhaseSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        AbstractSpectralWindow abstractSpectralWindow;
        AbstractBaseBandConfig abstractBaseBandConfig;
        Frequency frequency;
        int n;
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec2.getAbstractCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.ssp.getCorrPolarization());
        Frequency frequency2 = spectralSpec2.getLO1Frequency();
        Frequency frequency3 = frequency2.inverseDopplerShifted(this.velocity);
        spectralSpec2.setName("TDM Phase Cal setup");
        spectralSpec2.setRestFrequency(frequency3);
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        Frequency[] frequencyArray = new Frequency[]{Frequency.createFrequencyGHZ(-receiverBand.getIFMax() + 1.0 + 1.0E-10), Frequency.createFrequencyGHZ(-receiverBand.getIFMax() + 3.0 - 1.0E-10), Frequency.createFrequencyGHZ(receiverBand.getIFMax() - 3.0 + 1.0E-10), Frequency.createFrequencyGHZ(receiverBand.getIFMax() - 1.0 - 1.0E-10)};
        for (n = 0; n < spectralSpec2.getBaseBandConfigCount(); ++n) {
            frequency = (Frequency)frequency3.plus((AbstractDoubleWithUnit)frequencyArray[n]);
            abstractBaseBandConfig = spectralSpec2.getBaseBandConfig(n);
            abstractBaseBandConfig.setCenterFrequency(frequency);
            for (int i = 0; i < abstractBaseBandConfig.getSingleSpectralWindowCount(); ++i) {
                abstractBaseBandConfig.removeSingleSpectralWindow(abstractBaseBandConfig.getSingleSpectralWindow(i));
            }
            abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        for (n = spectralSpec2.getBaseBandConfigCount(); n < 4; ++n) {
            frequency = (Frequency)frequency3.plus((AbstractDoubleWithUnit)frequencyArray[n]);
            abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency);
            abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec2.setLOInSpectralSpec(this.velocity);
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    public SpectralSpec cloneTDMAtmCalSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.ssp.getCorrPolarization());
        spectralSpec2.setName("TDM Atm Cal setup");
        for (int i = 0; i < spectralSpec2.getBaseBandCount(); ++i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec2.getBaseBandConfig(i);
            for (int j = 0; j < abstractBaseBandConfig.getSingleSpectralWindowCount(); ++j) {
                abstractBaseBandConfig.removeSingleSpectralWindow(abstractBaseBandConfig.getSingleSpectralWindow(j));
            }
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        return spectralSpec2;
    }

    public void setupCorrelatorConfig(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        if (this.ssp.isSingleContinuum()) {
            this.setupSingleContinuumBasebands(abstractCorrelatorConfiguration);
        } else {
            this.setupBasebands(abstractCorrelatorConfiguration);
        }
    }

    protected void setupSingleContinuumBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws IllegalArgumentException {
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.ssp.getCorrPolarization());
        SingleContinuumExpert singleContinuumExpert = this.ssp.getScienceSpectralWindow(0).getIsSkyFrequency() ? new SingleContinuumExpert(this.ssp.getSingleContinuumFrequency(), Velocity.createVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY) : new SingleContinuumExpert(this.ssp.getSingleContinuumFrequency(), this.ssp.getSourceVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY);
        Range<Frequency>[] rangeArray = singleContinuumExpert.calculateSingleContinuumBasebands(true);
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        spectralSpec.getReceiverBand().getReceiverType();
        for (int i = 0; i < 4; ++i) {
            Frequency frequency = rangeArray[i].mid();
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency);
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        if (this.ssp.getScienceSpectralWindow(0).getIsSkyFrequency()) {
            spectralSpec.setLOInSpectralSpec(Velocity.createVelocity());
        } else {
            spectralSpec.setLOInSpectralSpec(this.ssp.getSourceVelocity());
        }
        spectralSpec.getCorrelatorConfiguration().updateSideband();
    }

    protected void setupCalibrationContinuumBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws IllegalArgumentException {
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.ssp.getCorrPolarization());
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(spectralSpec.getRestFrequency(), Velocity.createVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY);
        Range<Frequency>[] rangeArray = singleContinuumExpert.calculateSingleContinuumBasebands(true);
        spectralSpec.getReceiverBand().getReceiverType();
        for (int i = 0; i < 4; ++i) {
            Frequency frequency = rangeArray[i].mid();
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency);
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec.setLOInSpectralSpec(Velocity.createVelocity());
        spectralSpec.getCorrelatorConfiguration().updateSideband();
    }

    protected void setupBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        Object object;
        Velocity velocity = this.ssp.getSourceVelocity();
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        spectralSpec.getReceiverBand().getReceiverType();
        try {
            object = new BaseBandDeployer(this.ssp);
            Frequency[] frequencyArray = ((BaseBandDeployer)object).getAdjustedBaseBandCenterFrequenciesRest();
            String[] stringArray = BaseBandSpecification.getKnownBaseBandNameList();
            for (int i = 0; i < frequencyArray.length; ++i) {
                if (frequencyArray[i].isEqual((AbstractDoubleWithUnit)BaseBandDeployer.dummyFrequency)) continue;
                AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
                abstractBaseBandConfig.setCenterFrequency(frequencyArray[i]);
                abstractBaseBandConfig.setBaseBandName(stringArray[i]);
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new WizardSBGenerationException(baseBandNotDeployableException);
        }
        try {
            object = this.ssp.getGroupIndexSet();
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            invalidGroupIndexException.printStackTrace();
            throw new WizardSBGenerationException(invalidGroupIndexException);
        }
        spectralSpec.setLOInSpectralSpec(velocity);
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ScienceSpectralWindow[] scienceSpectralWindowArray;
            int n2 = (Integer)iterator.next();
            for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray = this.ssp.getScienceSpectralWindowGroup(n2)) {
                AbstractSpectralWindow abstractSpectralWindow = this.addNewSpectralWindow(abstractCorrelatorConfiguration.getBaseBandConfig(n), scienceSpectralWindow);
                abstractSpectralWindow.setCorrConfigMode(scienceSpectralWindow.getCorrConfigMode());
                abstractSpectralWindow.adjustCenterFrequency();
                abstractSpectralWindow.publishCorrConfigMode();
                SpectralLine spectralLine = SpectralLine.createSpectralLine();
                spectralLine.setRestFrequency(scienceSpectralWindow.getCenterFrequency().deepCopy());
                spectralLine.setTransition(scienceSpectralWindow.getTransitionName());
                spectralLine.setSplatalogId(scienceSpectralWindow.getSplatalogId());
                abstractSpectralWindow.addSpectralLine(spectralLine);
            }
            ++n;
        }
    }

    protected AbstractBaseBandConfig addNewBaseBandConfig(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        SpectralSpec spectralSpec = abstractCorrelatorConfiguration.getSpectralSpec();
        AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.addNewBaseBand().getBaseBandConfig();
        abstractBaseBandConfig.setDataProducts(AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractBaseBandConfig.setSwitchingType(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
        return abstractBaseBandConfig;
    }

    protected AbstractSpectralWindow addNewSpectralWindow(@NonNull AbstractBaseBandConfig abstractBaseBandConfig, @NonNull ScienceSpectralWindow scienceSpectralWindow) {
        if (abstractBaseBandConfig == null) {
            throw new NullPointerException("bbc is marked non-null but is null");
        }
        if (scienceSpectralWindow == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        scienceSpectralWindow.getGroupIndex();
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        abstractSpectralWindow.setEffectiveBandwidth(frequency);
        abstractSpectralWindow.setEffectiveNumberOfChannels(7680);
        abstractSpectralWindow.setAssociatedSpectralWindowNumberInPair(0);
        String string = this.ssp.getPolarisation();
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(string);
        abstractSpectralWindow.setPolnProducts(corrPolarization.polnProducts);
        this.ssp.getType();
        Velocity velocity = this.ssp.getSourceVelocity();
        Frequency[] frequencyArray = abstractSpectralWindow.getBaseBandConfig().getLOFrequencies();
        Frequency frequency2 = frequencyArray[0];
        Frequency frequency3 = frequencyArray[1];
        Frequency frequency4 = scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity);
        NetSideBand netSideBand = frequency4.compareTo((AbstractDoubleWithUnit)frequency2) > 0 ? NetSideBand.USB : NetSideBand.LSB;
        abstractSpectralWindow.setSideBand(netSideBand.toString());
        if (scienceSpectralWindow.getBandWidth().isEqual((AbstractDoubleWithUnit)BaseBandDeployer.BASEBANDWIDTH)) {
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(3000.0);
        } else {
            Frequency frequency5 = netSideBand.getBaseBandFrequency(frequency4, frequency2, frequency3);
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(frequency5.getContentInMHz());
        }
        abstractSpectralWindow.setBandParameters((Frequency)((Object)scienceSpectralWindow.getBandWidth()), scienceSpectralWindow.getNumberOfChannels(), SpectralWindowBand.ChannelType.NOMINAL);
        return abstractSpectralWindow;
    }
}

