/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.sfi;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;

public enum ScienceGoalEditorViewEnum {
    DEFAULTVIEW,
    VLBI,
    SOLAR,
    ACASUPPLEMENTALCALL;


    public static ScienceGoalEditorViewEnum getScienceGoalSubview(ScienceGoal scienceGoal) throws UnableToDetermineSubviewException {
        if (scienceGoal == null) {
            throw new UnableToDetermineSubviewException();
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal != null) {
                if (obsProposal.isSupplementalCallProposal()) {
                    return ACASUPPLEMENTALCALL;
                }
                if (obsProposal.isVLBIorPhasedArray()) {
                    return VLBI;
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalEditorViewEnum.class).info("Unable to determine if science goal is VLBI " + unknownEntityException.getMessage());
        }
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalEditorViewEnum.class).info("Unable to determine if the SG is Solar: " + unknownEntityException.getMessage());
        }
        if (bl) {
            return SOLAR;
        }
        return DEFAULTVIEW;
    }

    public static class UnableToDetermineSubviewException
    extends Exception {
    }
}

