/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.UserFrequencyT;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.util.UserFrequencyUnitMap;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserUnitHelper;
import alma.valuetypes.UserUnitValueUnitPair;
import alma.valuetypes.data.UserFrequencyData;
import java.util.Arrays;

public class UserFrequency
extends UserFrequencyData
implements UserUnitValueUnitPair<Frequency> {
    private UserUnitHelper uuhelper;
    private String[] sortedKnownUserUnitList = new String[]{USERUNIT_HZ, USERUNIT_KHZ, USERUNIT_MHZ, USERUNIT_GHZ, USERUNIT_M_S, USERUNIT_KM_S};
    private Frequency observingFrequency;
    private UserFrequencyUnitMap unitMap;
    private Speed speed;

    public UserFrequency(UserFrequencyT userFrequencyT) {
        super(userFrequencyT);
        this.unitMap().acceptNonModelUnits();
        this.uuhelper = new UserUnitHelper(this);
    }

    protected synchronized void initAsNew() {
        super.initAsNew();
        this.setUserUnit(this.defaultUnit());
    }

    public static UserFrequency createUserFrequency(double d, String string) {
        UserFrequency userFrequency = UserFrequency.createUserFrequency();
        userFrequency.setContent(d);
        userFrequency.setUnit(string);
        return userFrequency;
    }

    public static UserFrequency createUserFrequency(Frequency frequency) {
        return UserFrequency.createUserFrequency(frequency.getContent(), frequency.getUnit());
    }

    public static UserFrequency createUserFrequencyGHZ(double d) {
        UserFrequency userFrequency = UserFrequency.createUserFrequency();
        userFrequency.setContent(d);
        userFrequency.setUnit(Frequency.UNIT_GHZ);
        return userFrequency;
    }

    public static UserFrequency createUserFrequencyMHZ(double d) {
        UserFrequency userFrequency = UserFrequency.createUserFrequency();
        userFrequency.setContent(d);
        userFrequency.setUnit(Frequency.UNIT_MHZ);
        return userFrequency;
    }

    public static boolean isModelSupportUnit(String string) {
        for (String string2 : UserFrequency.getKnownUnitList()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getKnownModelUnits() {
        return knownUnitList;
    }

    @Override
    public String[] getKnownUserUnits() {
        return this.sortedKnownUserUnitList;
    }

    public synchronized Frequency getObservingFrequency() {
        if (this.observingFrequency == null) {
            this.observingFrequency = Frequency.createFrequency();
        }
        return this.observingFrequency;
    }

    public synchronized Frequency gettrueObservingFrequency() {
        return this.observingFrequency;
    }

    public synchronized void setObservingFrequency(Frequency frequency) {
        this.observingFrequency = frequency;
        UserFrequencyUnitMap userFrequencyUnitMap = this.unitMap();
        if (userFrequencyUnitMap.gettrueObservingFrequency() == null) {
            userFrequencyUnitMap.setObservingFrequency(frequency);
        } else {
            userFrequencyUnitMap.gettrueObservingFrequency().setContentAndUnit((ValueUnitPair)frequency);
            userFrequencyUnitMap.updateUnitMap();
        }
    }

    public synchronized UserFrequencyUnitMap unitMap() {
        if (this.unitMap == null) {
            this.unitMap = new UserFrequencyUnitMap(this);
        }
        return this.unitMap;
    }

    public String getFriendlyUnit() {
        return this.uuhelper.getFriendlyUnit();
    }

    public synchronized Speed asSpeed() {
        String string = Speed.UNIT_KM_S;
        double d = this.getContentInUnits(string);
        if (this.speed == null) {
            this.speed = Speed.createSpeed();
        }
        this.speed.setContentAndUnit(d, string);
        return this.speed;
    }

    public synchronized UserFrequency deepCopy() {
        return super.deepCopy();
    }

    protected synchronized void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        UserFrequency userFrequency = (UserFrequency)iBusinessObject;
        String[] stringArray = userFrequency.gettrueUserUnitList();
        if (stringArray != null) {
            this.setUserUnitList(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (userFrequency.observingFrequency != null) {
            this.unitMap().suspendUnitMapUpdater();
            this.setObservingFrequency(userFrequency.getObservingFrequency().deepCopy());
            this.unitMap().resumeUnitMapUpdater();
        } else {
            this.setObservingFrequency(null);
        }
    }

    public synchronized void setContentAndUnit(double d, String string) {
        super.setContentAndUnit(d, string);
    }

    public double getKms() {
        return this.getContentInUnits(USERUNIT_KM_S);
    }

    public synchronized void setContentAndUnit(ValueUnitPair valueUnitPair) {
        this.setContentAndUnit(valueUnitPair.getContent(), valueUnitPair.getUnit());
    }

    public UserFrequency divide(double d) {
        return (UserFrequency)super.divide(d);
    }

    public synchronized double getContentInUnits(String string) {
        return this.uuhelper.getContentInUnits(string);
    }

    @Override
    public synchronized void setUserContent(double d) {
        this.uuhelper.setUserContent(d);
    }

    @Override
    public void setUserContent(double d, String string) {
        this.uuhelper.setUserContent(d, string);
    }

    protected void updateContentAndUnit(double d, String string) {
        this.uuhelper.updateContentAndUnit(d, string);
    }

    public void setUserContentAndUserUnit(double d, String string) {
        this.uuhelper.setUserContentAndUserUnit(d, string);
    }

    public void setUserContentAndUserUnit(ValueUnitPair valueUnitPair) {
        this.uuhelper.setUserContentAndUserUnit(valueUnitPair);
    }

    @Override
    public double getUserContent() {
        return this.uuhelper.getUserContent();
    }

    @Override
    public String gettrueUserUnit() {
        return this.uuhelper.gettrueUserUnit();
    }

    public String[] gettrueUserUnitList() {
        return this.uuhelper.gettrueUserUnitList();
    }

    @Override
    public String[] getUserUnitList() {
        return this.uuhelper.getUserUnitList();
    }

    @Override
    public void setUserUnitList(String[] stringArray) {
        this.uuhelper.setUserUnitList(stringArray);
    }

    @Override
    public void convertToUserUnit(String string) {
        this.uuhelper.convertToUserUnit(string);
    }

    @Override
    public boolean isModelUnit(String string) {
        return this.uuhelper.isModelUnit(string);
    }

    @Override
    public void dependeeChanged() {
        if (this.uuhelper != null) {
            this.uuhelper.dependeeChanged();
        }
    }

    @Override
    public void unitMapUpdated() {
        if (this.uuhelper != null) {
            this.uuhelper.unitMapUpdated();
        }
    }

    @Override
    public boolean inModelUnit() {
        return this.isModelUnit(this.getUserUnit());
    }
}

