/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.InputStream;
import java.io.OutputStream;
import jsky.image.fits.codec.FITSDecoder;
import jsky.image.fits.codec.FITSEncodeParam;
import jsky.image.fits.codec.FITSEncoder;

public final class FITSCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "fits";
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public Class getEncodeParamClass() {
        return null;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int numBands = sampleModel.getNumBands();
        return numBands == 1;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        FITSEncodeParam p = null;
        if (param != null) {
            p = (FITSEncodeParam)param;
        }
        return new FITSEncoder(dst, p);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        try {
            return new FITSDecoder(new ForwardSeekableStream(src), param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        try {
            return new FITSDecoder(src, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNumHeaderBytes() {
        return 6;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 83 && header[1] == 73 && header[2] == 77 && header[3] == 80 && header[4] == 76 && header[5] == 69;
    }
}

