/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class BufferedFileTester {
    static long lastTime;

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        int dim = 1000;
        if (args.length > 1) {
            dim = Integer.parseInt(args[1]);
        }
        int iter = 1;
        if (args.length > 2) {
            iter = Integer.parseInt(args[2]);
        }
        System.out.println("Allocating arrays.");
        double[] db = new double[dim];
        float[] fl = new float[dim];
        int[] in = new int[dim];
        long[] ln = new long[dim];
        short[] sh = new short[dim];
        byte[] by = new byte[dim];
        char[] ch = new char[dim];
        boolean[] bl = new boolean[dim];
        System.out.println("Initializing arrays -- may take a while");
        int sign = 1;
        for (int i = 0; i < dim; ++i) {
            double x;
            db[i] = x = (double)sign * Math.pow(10.0, 20.0 * Math.random() - 10.0);
            fl[i] = (float)x;
            if (Math.abs(x) < 1.0) {
                x = 1.0 / x;
            }
            in[i] = (int)x;
            ln[i] = (long)x;
            sh[i] = (short)x;
            by[i] = (byte)x;
            ch[i] = (char)x;
            bl[i] = x > 0.0;
            sign = -sign;
        }
        by[0] = -128;
        by[1] = 127;
        by[2] = 0;
        ch[0] = '\u0000';
        ch[1] = 65535;
        ch[2] = '\u0000';
        sh[0] = Short.MAX_VALUE;
        sh[1] = Short.MIN_VALUE;
        sh[0] = 0;
        in[0] = Integer.MAX_VALUE;
        in[1] = Integer.MIN_VALUE;
        in[2] = 0;
        ln[0] = Long.MIN_VALUE;
        ln[1] = Long.MAX_VALUE;
        ln[2] = 0L;
        fl[0] = Float.MIN_VALUE;
        fl[1] = Float.MAX_VALUE;
        fl[2] = Float.POSITIVE_INFINITY;
        fl[3] = Float.NEGATIVE_INFINITY;
        fl[4] = Float.NaN;
        fl[5] = 0.0f;
        db[0] = Double.MIN_VALUE;
        db[1] = Double.MAX_VALUE;
        db[2] = Double.POSITIVE_INFINITY;
        db[3] = Double.NEGATIVE_INFINITY;
        db[4] = Double.NaN;
        db[5] = 0.0;
        double[] db2 = new double[dim];
        float[] fl2 = new float[dim];
        int[] in2 = new int[dim];
        long[] ln2 = new long[dim];
        short[] sh2 = new short[dim];
        byte[] by2 = new byte[dim];
        char[] ch2 = new char[dim];
        boolean[] bl2 = new boolean[dim];
        int[][][][] multi = new int[10][10][10][10];
        int[][][][] multi2 = new int[10][10][10][10];
        for (int i = 0; i < 10; ++i) {
            multi[i][i][i][i] = i;
        }
        if (args.length < 4 || args[3].indexOf(79) >= 0) {
            BufferedFileTester.standardFileTest(filename, iter, in, in2);
            BufferedFileTester.standardStreamTest(filename, iter, in, in2);
        }
        if (args.length < 4 || args[3].indexOf(88) >= 0) {
            BufferedFileTester.buffStreamSimpleTest(filename, iter, in, in2);
        }
        if (args.length < 4 || args[3].indexOf(82) >= 0) {
            BufferedFileTester.bufferedFileTest(filename, iter, db, db2, fl, fl2, ln, ln2, in, in2, sh, sh2, ch, ch2, by, by2, bl, bl2, multi, multi2);
        }
        if (args.length < 4 || args[3].indexOf(83) >= 0) {
            BufferedFileTester.bufferedStreamTest(filename, iter, db, db2, fl, fl2, ln, ln2, in, in2, sh, sh2, ch, ch2, by, by2, bl, bl2, multi, multi2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void standardFileTest(String filename, int iter, int[] in, int[] in2) throws Exception {
        int i;
        int j;
        System.out.println("Standard I/O library: java.io.RandomAccessFile");
        RandomAccessFile f = new RandomAccessFile(filename, "rw");
        int dim = in.length;
        BufferedFileTester.resetTime();
        f.seek(0L);
        for (j = 0; j < iter; ++j) {
            for (i = 0; i < dim; ++i) {
                f.writeInt(in[i]);
            }
        }
        System.out.println("  RAF Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        f.seek(0L);
        BufferedFileTester.resetTime();
        for (j = 0; j < iter; ++j) {
            for (i = 0; i < dim; ++i) {
                in2[i] = f.readInt();
            }
        }
        System.out.println("  RAF Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        RandomAccessFile randomAccessFile = f;
        synchronized (randomAccessFile) {
            int i2;
            int j2;
            f.seek(0L);
            for (j2 = 0; j2 < iter; ++j2) {
                for (i2 = 0; i2 < dim; ++i2) {
                    f.writeInt(in[i2]);
                }
            }
            System.out.println("  SyncRAF Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
            f.seek(0L);
            BufferedFileTester.resetTime();
            for (j2 = 0; j2 < iter; ++j2) {
                for (i2 = 0; i2 < dim; ++i2) {
                    in2[i2] = f.readInt();
                }
            }
        }
        System.out.println("  SyncRAF Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void standardStreamTest(String filename, int iter, int[] in, int[] in2) throws Exception {
        System.out.println("Standard I/O library: java.io.DataXXputStream");
        System.out.println("                      layered atop a BufferedXXputStream");
        DataOutputStream f = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 32768));
        BufferedFileTester.resetTime();
        int dim = in.length;
        for (int j = 0; j < iter; ++j) {
            for (int i = 0; i < dim; ++i) {
                f.writeInt(in[i]);
            }
        }
        f.flush();
        f.close();
        System.out.println("  DIS Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(filename), 32768));
        BufferedFileTester.resetTime();
        for (int j = 0; j < iter; ++j) {
            for (int i = 0; i < dim; ++i) {
                in2[i] = is.readInt();
            }
        }
        System.out.println("  DIS Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        f = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 32768));
        BufferedFileTester.resetTime();
        dim = in.length;
        DataOutputStream dataOutputStream = f;
        synchronized (dataOutputStream) {
            int i;
            int j;
            for (j = 0; j < iter; ++j) {
                for (i = 0; i < dim; ++i) {
                    f.writeInt(in[i]);
                }
            }
            f.flush();
            f.close();
            System.out.println("  DIS Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
            is = new DataInputStream(new BufferedInputStream(new FileInputStream(filename), 32768));
            BufferedFileTester.resetTime();
            for (j = 0; j < iter; ++j) {
                for (i = 0; i < dim; ++i) {
                    in2[i] = is.readInt();
                }
            }
        }
        System.out.println("  DIS Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
    }

    public static void buffStreamSimpleTest(String filename, int iter, int[] in, int[] in2) throws Exception {
        System.out.println("New libraries:  nom.tam.BufferedDataXXputStream");
        System.out.println("                Using non-array I/O");
        BufferedDataOutputStream f = new BufferedDataOutputStream(new FileOutputStream(filename), 32768);
        BufferedFileTester.resetTime();
        int dim = in.length;
        for (int j = 0; j < iter; ++j) {
            for (int i = 0; i < dim; ++i) {
                f.writeInt(in[i]);
            }
        }
        f.flush();
        f.close();
        System.out.println("  BDS Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        BufferedDataInputStream is = new BufferedDataInputStream(new BufferedInputStream(new FileInputStream(filename), 32768));
        BufferedFileTester.resetTime();
        for (int j = 0; j < iter; ++j) {
            for (int i = 0; i < dim; ++i) {
                in2[i] = is.readInt();
            }
        }
        System.out.println("  BDS Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
    }

    public static void bufferedStreamTest(String filename, int iter, double[] db, double[] db2, float[] fl, float[] fl2, long[] ln, long[] ln2, int[] in, int[] in2, short[] sh, short[] sh2, char[] ch, char[] ch2, byte[] by, byte[] by2, boolean[] bl, boolean[] bl2, int[][][][] multi, int[][][][] multi2) throws Exception {
        int i;
        int i2;
        int dim = db.length;
        double ds = Math.random() - 0.5;
        float fs = (float)(Math.random() - 0.5);
        int is = (int)(1000000.0 * (Math.random() - 500000.0));
        long ls = (long)(1.0E11 * (Math.random() - 5.0E10));
        short ss = (short)(60000.0 * (Math.random() - 30000.0));
        char cs = (char)(60000.0 * Math.random());
        byte bs = (byte)(256.0 * Math.random() - 128.0);
        boolean bls = Math.random() > 0.5;
        System.out.println("New libraries: nom.tam.util.BufferedDataXXputStream");
        System.out.println("               Using array I/O methods");
        Closeable f = new BufferedDataOutputStream(new FileOutputStream(filename));
        BufferedFileTester.resetTime();
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(db);
        }
        System.out.println("  BDS Dbl write: " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(fl);
        }
        System.out.println("  BDS Flt write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(in);
        }
        System.out.println("  BDS Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(ln);
        }
        System.out.println("  BDS Lng write: " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(sh);
        }
        System.out.println("  BDS Sht write: " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(ch);
        }
        System.out.println("  BDS Chr write: " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(by);
        }
        System.out.println("  BDS Byt write: " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataOutputStream)f).writeArray(bl);
        }
        System.out.println("  BDS Boo write: " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        ((BufferedDataOutputStream)f).writeByte(bs);
        ((BufferedDataOutputStream)f).writeChar(cs);
        ((BufferedDataOutputStream)f).writeShort(ss);
        ((BufferedDataOutputStream)f).writeInt(is);
        ((BufferedDataOutputStream)f).writeLong(ls);
        ((BufferedDataOutputStream)f).writeFloat(fs);
        ((BufferedDataOutputStream)f).writeDouble(ds);
        ((BufferedDataOutputStream)f).writeBoolean(bls);
        ((BufferedDataOutputStream)f).writeArray(multi);
        ((BufferedOutputStream)f).flush();
        ((FilterOutputStream)f).close();
        f = new BufferedDataInputStream(new FileInputStream(filename));
        BufferedFileTester.resetTime();
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(db2);
        }
        System.out.println("  BDS Dbl read:  " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(fl2);
        }
        System.out.println("  BDS Flt read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(in2);
        }
        System.out.println("  BDS Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(ln2);
        }
        System.out.println("  BDS Lng read:  " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(sh2);
        }
        System.out.println("  BDS Sht read:  " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(ch2);
        }
        System.out.println("  BDS Chr read:  " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(by2);
        }
        System.out.println("  BDS Byt read:  " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i2 = 0; i2 < iter; ++i2) {
            ((BufferedDataInputStream)f).readLArray(bl2);
        }
        System.out.println("  BDS Boo read:  " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        byte bs2 = ((BufferedDataInputStream)f).readByte();
        char cs2 = ((BufferedDataInputStream)f).readChar();
        short ss2 = ((BufferedDataInputStream)f).readShort();
        int is2 = ((BufferedDataInputStream)f).readInt();
        long ls2 = ((BufferedDataInputStream)f).readLong();
        float fs2 = ((BufferedDataInputStream)f).readFloat();
        double ds2 = ((BufferedDataInputStream)f).readDouble();
        boolean bls2 = ((BufferedDataInputStream)f).readBoolean();
        for (i2 = 0; i2 < 10; ++i2) {
            multi2[i2][i2][i2][i2] = 0;
        }
        for (i2 = 0; i2 < 5; ++i2) {
            System.out.println("Multiread:" + i2);
            ((BufferedDataInputStream)f).skipBytes(4000);
            ((BufferedDataInputStream)f).readLArray(multi2[2 * i2 + 1]);
        }
        ((BufferedInputStream)f).close();
        System.out.println("Stream Verification:");
        System.out.println("  An error should be reported for double and float NaN's");
        System.out.println("  Arrays:");
        for (i = 0; i < dim; ++i) {
            if (db[i] != db2[i]) {
                System.out.println("     Double error at " + i + " " + db[i] + " " + db2[i]);
            }
            if (fl[i] != fl2[i]) {
                System.out.println("     Float error at " + i + " " + fl[i] + " " + fl2[i]);
            }
            if (in[i] != in2[i]) {
                System.out.println("     Int error at " + i + " " + in[i] + " " + in2[i]);
            }
            if (ln[i] != ln2[i]) {
                System.out.println("     Long error at " + i + " " + ln[i] + " " + ln2[i]);
            }
            if (sh[i] != sh2[i]) {
                System.out.println("     Short error at " + i + " " + sh[i] + " " + sh2[i]);
            }
            if (ch[i] != ch2[i]) {
                System.out.println("     Char error at " + i + " " + ch[i] + " " + ch2[i]);
            }
            if (by[i] != by2[i]) {
                System.out.println("     Byte error at " + i + " " + by[i] + " " + by2[i]);
            }
            if (bl[i] == bl2[i]) continue;
            System.out.println("     Bool error at " + i + " " + bl[i] + " " + bl2[i]);
        }
        System.out.println("  Scalars:");
        if (bls != bls2) {
            System.out.println("     Bool Scalar mismatch:" + bls + " " + bls2);
        }
        if (bs != bs2) {
            System.out.println("     Byte Scalar mismatch:" + bs + " " + bs2);
        }
        if (cs != cs2) {
            System.out.println("     Char Scalar mismatch:" + cs + " " + cs2);
        }
        if (ss != ss2) {
            System.out.println("     Short Scalar mismatch:" + ss + " " + ss2);
        }
        if (is != is2) {
            System.out.println("     Int Scalar mismatch:" + is + " " + is2);
        }
        if (ls != ls2) {
            System.out.println("     Long Scalar mismatch:" + ls + " " + ls2);
        }
        if (fs != fs2) {
            System.out.println("     Float Scalar mismatch:" + fs + " " + fs2);
        }
        if (ds != ds2) {
            System.out.println("     Double Scalar mismatch:" + ds + " " + ds2);
        }
        System.out.println("  Multi: odd rows should match");
        for (i = 0; i < 10; ++i) {
            System.out.println("      " + i + " " + multi[i][i][i][i] + " " + multi2[i][i][i][i]);
        }
        System.out.println("Done BufferedStream Tests");
    }

    public static void bufferedFileTest(String filename, int iter, double[] db, double[] db2, float[] fl, float[] fl2, long[] ln, long[] ln2, int[] in, int[] in2, short[] sh, short[] sh2, char[] ch, char[] ch2, byte[] by, byte[] by2, boolean[] bl, boolean[] bl2, int[][][][] multi, int[][][][] multi2) throws Exception {
        int i;
        int dim = db.length;
        double ds = Math.random() - 0.5;
        float fs = (float)(Math.random() - 0.5);
        int is = (int)(1000000.0 * (Math.random() - 500000.0));
        long ls = (long)(1.0E11 * (Math.random() - 5.0E10));
        short ss = (short)(60000.0 * (Math.random() - 30000.0));
        char cs = (char)(60000.0 * Math.random());
        byte bs = (byte)(256.0 * Math.random() - 128.0);
        boolean bls = Math.random() > 0.5;
        System.out.println("New libraries: nom.tam.util.BufferedFile");
        System.out.println("               Using array I/O methods.");
        BufferedFile f = new BufferedFile(filename, "rw");
        BufferedFileTester.resetTime();
        for (i = 0; i < iter; ++i) {
            f.writeArray(db);
        }
        System.out.println("  BF  Dbl write: " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(fl);
        }
        System.out.println("  BF  Flt write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(in);
        }
        System.out.println("  BF  Int write: " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(ln);
        }
        System.out.println("  BF  Lng write: " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(sh);
        }
        System.out.println("  BF  Sht write: " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(ch);
        }
        System.out.println("  BF  Chr write: " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(by);
        }
        System.out.println("  BF  Byt write: " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.writeArray(bl);
        }
        System.out.println("  BF  Boo write: " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        f.writeByte(bs);
        f.writeChar(cs);
        f.writeShort(ss);
        f.writeInt(is);
        f.writeLong(ls);
        f.writeFloat(fs);
        f.writeDouble(ds);
        f.writeBoolean(bls);
        f.writeArray(multi);
        f.seek(0L);
        BufferedFileTester.resetTime();
        for (i = 0; i < iter; ++i) {
            f.readLArray(db2);
        }
        System.out.println("  BF  Dbl read:  " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(fl2);
        }
        System.out.println("  BF  Flt read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(in2);
        }
        System.out.println("  BF  Int read:  " + (double)(4 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(ln2);
        }
        System.out.println("  BF  Lng read:  " + (double)(8 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(sh2);
        }
        System.out.println("  BF  Sht read:  " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(ch2);
        }
        System.out.println("  BF  Chr read:  " + (double)(2 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(by2);
        }
        System.out.println("  BF  Byt read:  " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        for (i = 0; i < iter; ++i) {
            f.readLArray(bl2);
        }
        System.out.println("  BF  Boo read:  " + (double)(1 * dim * iter) / (1000.0 * BufferedFileTester.deltaTime()));
        byte bs2 = f.readByte();
        char cs2 = f.readChar();
        short ss2 = f.readShort();
        int is2 = f.readInt();
        long ls2 = f.readLong();
        float fs2 = f.readFloat();
        double ds2 = f.readDouble();
        boolean bls2 = f.readBoolean();
        for (i = 0; i < 5; ++i) {
            f.skipBytes(4000);
            f.readLArray(multi2[2 * i + 1]);
        }
        System.out.println("BufferedFile Verification:");
        System.out.println("  An error should be reported for double and float NaN's");
        System.out.println("  Arrays:");
        for (i = 0; i < dim; ++i) {
            if (db[i] != db2[i]) {
                System.out.println("     Double error at " + i + " " + db[i] + " " + db2[i]);
            }
            if (fl[i] != fl2[i]) {
                System.out.println("     Float error at " + i + " " + fl[i] + " " + fl2[i]);
            }
            if (in[i] != in2[i]) {
                System.out.println("     Int error at " + i + " " + in[i] + " " + in2[i]);
            }
            if (ln[i] != ln2[i]) {
                System.out.println("     Long error at " + i + " " + ln[i] + " " + ln2[i]);
            }
            if (sh[i] != sh2[i]) {
                System.out.println("     Short error at " + i + " " + sh[i] + " " + sh2[i]);
            }
            if (ch[i] != ch2[i]) {
                System.out.println("     Char error at " + i + " " + ch[i] + " " + ch2[i]);
            }
            if (by[i] != by2[i]) {
                System.out.println("     Byte error at " + i + " " + by[i] + " " + by2[i]);
            }
            if (bl[i] == bl2[i]) continue;
            System.out.println("     Bool error at " + i + " " + bl[i] + " " + bl2[i]);
        }
        System.out.println("  Scalars:");
        if (bls != bls2) {
            System.out.println("     Bool Scalar mismatch:" + bls + " " + bls2);
        }
        if (bs != bs2) {
            System.out.println("     Byte Scalar mismatch:" + bs + " " + bs2);
        }
        if (cs != cs2) {
            System.out.println("     Char Scalar mismatch:" + cs + " " + cs2);
        }
        if (ss != ss2) {
            System.out.println("     Short Scalar mismatch:" + ss + " " + ss2);
        }
        if (is != is2) {
            System.out.println("     Int Scalar mismatch:" + is + " " + is2);
        }
        if (ls != ls2) {
            System.out.println("     Long Scalar mismatch:" + ls + " " + ls2);
        }
        if (fs != fs2) {
            System.out.println("     Float Scalar mismatch:" + fs + " " + fs2);
        }
        if (ds != ds2) {
            System.out.println("     Double Scalar mismatch:" + ds + " " + ds2);
        }
        System.out.println("  Multi: odd rows should match");
        for (i = 0; i < 10; ++i) {
            System.out.println("      " + i + " " + multi[i][i][i][i] + " " + multi2[i][i][i][i]);
        }
        System.out.println("Done BufferedFile Tests");
    }

    static void resetTime() {
        lastTime = new Date().getTime();
    }

    static double deltaTime() {
        long time = lastTime;
        lastTime = new Date().getTime();
        return (double)(lastTime - time) / 1000.0;
    }

    @Test
    public void testBufferedFile() throws Exception {
        double[][] td = new double[100][600];
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 600; ++j) {
                td[i][j] = i + 2 * j;
            }
        }
        int[][][] ti = new int[5][4][3];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    ti[i][j][k] = i * j * k;
                }
            }
        }
        float[][] tf = new float[10][];
        for (int i = 0; i < 10; ++i) {
            tf[i] = new float[i];
            for (int j = 0; j < i; ++j) {
                tf[i][j] = (float)Math.sin(i * j);
            }
        }
        boolean[] tb = new boolean[100];
        for (int i = 2; i < 100; ++i) {
            tb[i] = !tb[i - 1];
        }
        short[][] ts = new short[5][5];
        ts[2][2] = 222;
        byte[] tbyte = new byte[1024];
        for (int i = 0; i < tbyte.length; ++i) {
            tbyte[i] = (byte)i;
        }
        char[] tc = new char[10];
        tc[3] = 99;
        long[][][] tl0 = new long[1][1][1];
        long[][][] tl1 = new long[1][1][0];
        BufferedFile bf = new BufferedFile("jtest.fil", "rw");
        bf.writeArray(td);
        bf.writeArray(tf);
        bf.writeArray(ti);
        bf.writeArray(ts);
        bf.writeArray(tb);
        bf.writeArray(tbyte);
        bf.writeArray(tc);
        bf.writeArray(tl0);
        bf.writeArray(tl1);
        bf.writeArray(ts);
        bf.close();
        bf = new BufferedFile("jtest.fil", "r");
        boolean thrown = false;
        try {
            bf.writeArray(td);
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"BufferedFile protections", (Object)true, (Object)thrown);
        try {
            bf.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        bf = new BufferedFile("jtest.fil", "r");
        this.testArray(bf, "double", td);
        this.testArray(bf, "float", tf);
        this.testArray(bf, "int", ti);
        this.testArray(bf, "short", ts);
        this.testArray(bf, "bool", tb);
        this.testArray(bf, "byte", tbyte);
        this.testArray(bf, "char", tc);
        this.testArray(bf, "long1", tl0);
        this.testArray(bf, "longnull", tl1);
        this.testArray(bf, "short2", ts);
    }

    @Test
    public void testBufferedStreams() throws Exception {
        double[][] td = new double[100][600];
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 600; ++j) {
                td[i][j] = i + 2 * j;
            }
        }
        int[][][] ti = new int[5][4][3];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    ti[i][j][k] = i * j * k;
                }
            }
        }
        float[][] tf = new float[10][];
        for (int i = 0; i < 10; ++i) {
            tf[i] = new float[i];
            for (int j = 0; j < i; ++j) {
                tf[i][j] = (float)Math.sin(i * j);
            }
        }
        boolean[] tb = new boolean[100];
        for (int i = 2; i < 100; ++i) {
            tb[i] = !tb[i - 1];
        }
        short[][] ts = new short[5][5];
        ts[2][2] = 222;
        byte[] tbyte = new byte[1024];
        for (int i = 0; i < tbyte.length; ++i) {
            tbyte[i] = (byte)i;
        }
        char[] tc = new char[10];
        tc[3] = 99;
        long[][][] tl0 = new long[1][1][1];
        long[][][] tl1 = new long[1][1][0];
        BufferedDataOutputStream bf = new BufferedDataOutputStream(new FileOutputStream("jtest.fil"));
        bf.writeArray(td);
        bf.writeArray(tf);
        bf.writeArray(ti);
        bf.writeArray(ts);
        bf.writeArray(tb);
        bf.writeArray(tbyte);
        bf.writeArray(tc);
        bf.writeArray(tl0);
        bf.writeArray(tl1);
        bf.writeArray(ts);
        bf.close();
        BufferedDataInputStream bi = new BufferedDataInputStream(new FileInputStream("jtest.fil"));
        this.testArray(bi, "sdouble", td);
        this.testArray(bi, "sfloat", tf);
        this.testArray(bi, "sint", ti);
        this.testArray(bi, "sshort", ts);
        this.testArray(bi, "sbool", tb);
        this.testArray(bi, "sbyte", tbyte);
        this.testArray(bi, "schar", tc);
        this.testArray(bi, "slong1", tl0);
        this.testArray(bi, "slongnull", tl1);
        this.testArray(bi, "sshort2", ts);
    }

    void testArray(ArrayDataInput bf, String label, Object array) throws Exception {
        Object newArray = ArrayFuncs.mimicArray(array, ArrayFuncs.getBaseClass(array));
        bf.readLArray(newArray);
        boolean state = ArrayFuncs.arrayEquals(array, newArray);
        Assert.assertEquals((String)label, (Object)true, (Object)state);
    }
}

