/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.net.URL;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import skyview.executive.Settings;
import skyview.geometry.WCS;
import skyview.survey.HDecompressor;
import skyview.survey.Image;
import skyview.survey.Util;

public class DSSImage
extends Image {
    private int[][] dssData;
    private static char[] suffixes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private String directory;
    private String plate;
    private String[] urlPrefixes = Settings.getArray("LocalURL");
    private int nTiles = 28;
    private int tileSize = 500;
    private int xSize;
    private int ySize;
    private int subimageCount = 0;
    private int[] dssIndex = new int[60];
    static String lastImage;

    public DSSImage(String directory) throws Exception {
        this.directory = directory;
        int slash = directory.lastIndexOf(47);
        this.plate = directory.substring(slash + 1);
        Header h = this.getHeader(directory + "/" + this.plate + ".hhh");
        WCS w = new WCS(h);
        int[] axes = w.getHeaderNaxis();
        this.xSize = axes[0];
        this.ySize = axes[1];
        if (this.xSize > 14000) {
            this.nTiles = 30;
            this.tileSize = 768;
        }
        this.initialize(null, w, this.xSize, this.ySize, 1);
        this.setName(this.plate);
    }

    @Override
    public double getData(int npix) {
        if (this.dssData == null) {
            this.dssData = new int[this.nTiles * this.nTiles][];
        }
        int x = npix % this.xSize;
        int y = npix / this.xSize;
        int px = x / this.tileSize;
        int py = y / this.tileSize;
        x %= this.tileSize;
        y %= this.tileSize;
        int tile = px + this.nTiles * py;
        if (this.dssData[tile] == null) {
            try {
                String file = this.directory + "/" + this.plate + '.' + suffixes[py] + suffixes[px];
                lastImage = file = Util.replacePrefix(file, this.urlPrefixes);
                this.dssData[tile] = file.startsWith("http:") ? HDecompressor.decompress(new URL(file).openStream()) : HDecompressor.decompress(new FileInputStream(file));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new Error("Unable to decompress file:" + this.directory + "/" + this.plate + '.' + suffixes[py] + suffixes[px]);
            }
            int idx = this.subimageCount % this.dssIndex.length;
            if (this.subimageCount > this.dssIndex.length) {
                this.dssData[this.dssIndex[idx]] = null;
            }
            this.dssIndex[idx] = tile;
            ++this.subimageCount;
        }
        return this.dssData[tile][x + this.tileSize * y];
    }

    @Override
    public double[] getDataArray() {
        throw new Error("getDataArray: Invalid operation on DSS image");
    }

    @Override
    public void setData(int npix, double newData) {
        throw new Error("setData: Invalid operation on DSS image");
    }

    @Override
    public void clearData() {
        this.dssData = null;
    }

    @Override
    public void setDataArray(double[] newData) {
        throw new Error("setDataArray: Invalid operation on DSS image");
    }

    private Header getHeader(String headerFile) throws Exception {
        String s;
        byte[] buf = new byte[80];
        Header h = new Header();
        DataInputStream in = (headerFile = Util.replacePrefix(headerFile, this.urlPrefixes)).startsWith("http:") ? new DataInputStream(new BufferedInputStream(new URL(headerFile).openStream())) : new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
        Cursor c = h.iterator();
        do {
            in.readFully(buf);
            s = new String(buf);
            HeaderCard hc = new HeaderCard(s);
            String key = hc.getKey();
            if (key.equals("") || key.equals("COMMENT") || key.equals("HISTORY")) continue;
            c.add(hc.getKey(), hc);
        } while (!s.substring(0, 4).equals("END "));
        if (h.getDoubleValue("CNPIX1") == 1.0 && h.getDoubleValue("CNPIX2") == 1.0) {
            h.addValue("CNPIX1", 0L, (String)null);
            h.addValue("CNPIX2", 0L, (String)null);
        }
        return h;
    }

    @Override
    public boolean isTiled() {
        return true;
    }
}

